/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.model.system;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.MetricScope;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.metrics.MetricCategory;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.element.TypescriptProviderId;
import java.util.Arrays;
import java.util.List;

public final class TypescriptMetricId
extends Enum<TypescriptMetricId>
implements IMetricId {
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_NAMESPACES = new TypescriptMetricId("Number of Typescript Namespaces", "Number of Typescript Namespaces containing elements in fully analyzed and issue ignoring code.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.SIZE});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_NAMESPACES_FULLY_ANALYZED = new TypescriptMetricId("Number of Typescript Namespaces (Full Analysis)", "Number of Typescript Namespaces containing fully analyzed types.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.SIZE});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_DIRECTORY_CYCLE_GROUPS = new TypescriptMetricId("Number of all Typescript Directory Cycle Groups", "Number of all Typescript Directory cycle groups", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_CRITICAL_DIRECTORY_CYCLE_GROUPS = new TypescriptMetricId("Number of Critical Typescript Directory Cycle Groups", "Number of Typescript Directory cycle groups marked as errors.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_CYCLIC_DIRECTORIES = new TypescriptMetricId("Number of Cyclic Typescript Directories", "Number of cyclic Typescript Directories.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_IGNORED_CYCLIC_DIRECTORIES = new TypescriptMetricId("Number of Ignored Cyclic Typescript Directories", "Number of ignored cyclic Typescript Directories.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_BIGGEST_DIRECTORY_CYCLE_GROUP = new TypescriptMetricId("Biggest Typescript Directory Cycle Group", "Biggest Typescript Directory cycle group.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_DIRECTORIES = new TypescriptMetricId("Number of Typescript Directories", "Number of Typescript Directories containing types in fully analyzed and issue ignoring code.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.SIZE});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_DIRECTORIES_FULLY_ANALYZED = new TypescriptMetricId("Number of Typescript Directories (Full Analysis)", "Number of Typescript Directories containing fully analyzed types.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.SIZE});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_STRUCTURAL_DEBT_INDEX_DIRECTORIES = new TypescriptMetricId("Structural Debt Index (Typescript Directories)", "Cumulative structural debt index of all Typescript Directory cycle groups.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CODE_ANALYSIS});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_PARSER_DEPENDENCIES_TO_REMOVE_DIRECTORIES = new TypescriptMetricId("Parser Dependencies to Remove (Typescript Directories)", "Number of code lines to change to break up all Typescript Directory cycle groups.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CODE_ANALYSIS, MetricCategory.DEPENDENCY});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_COMPONENT_DEPENDENCIES_TO_REMOVE_DIRECTORIES = new TypescriptMetricId("Component Dependencies to Remove (Typescript Directories)", "Number of component dependencies to remove to break up all Typescript Directory cycle groups.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CODE_ANALYSIS, MetricCategory.DEPENDENCY});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_CYCLICITY_DIRECTORIES = new TypescriptMetricId("Cyclicity (Typescript Directories)", "Cumulated cyclicity of Typescript Directory cycle groups.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_RELATIVE_CYCLICITY_DIRECTORIES = new TypescriptMetricId("Relative Cyclicity (Typescript Directories)", "Relative Typescript Directory cyclicity in percent.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ TypescriptMetricId TYPESCRIPT_AVERAGE_RELATIVE_CYCLICITY_DIRECTORIES = new TypescriptMetricId("Average Relative Cyclicity (Typescript Directories)", "Weighted average of relative Typescript Directory cyclicity of modules in percent.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, new IMetricCategory[]{MetricCategory.CYCLE});
    private final String m_presentationName;
    private final String m_description;
    private final boolean m_isFloat;
    private final IMetricId.StandardSorting m_sorting;
    private final IMetricId.MetricRange m_range;
    private final IMetricCategory[] m_categories;
    private final MetricScope m_metricScope;
    private static final /* synthetic */ TypescriptMetricId[] ENUM$VALUES;

    static {
        ENUM$VALUES = new TypescriptMetricId[]{TYPESCRIPT_NAMESPACES, TYPESCRIPT_NAMESPACES_FULLY_ANALYZED, TYPESCRIPT_DIRECTORY_CYCLE_GROUPS, TYPESCRIPT_CRITICAL_DIRECTORY_CYCLE_GROUPS, TYPESCRIPT_CYCLIC_DIRECTORIES, TYPESCRIPT_IGNORED_CYCLIC_DIRECTORIES, TYPESCRIPT_BIGGEST_DIRECTORY_CYCLE_GROUP, TYPESCRIPT_DIRECTORIES, TYPESCRIPT_DIRECTORIES_FULLY_ANALYZED, TYPESCRIPT_STRUCTURAL_DEBT_INDEX_DIRECTORIES, TYPESCRIPT_PARSER_DEPENDENCIES_TO_REMOVE_DIRECTORIES, TYPESCRIPT_COMPONENT_DEPENDENCIES_TO_REMOVE_DIRECTORIES, TYPESCRIPT_CYCLICITY_DIRECTORIES, TYPESCRIPT_RELATIVE_CYCLICITY_DIRECTORIES, TYPESCRIPT_AVERAGE_RELATIVE_CYCLICITY_DIRECTORIES};
    }

    private TypescriptMetricId(String presentationName, String description, boolean isFloat, IMetricId.StandardSorting sorting, IMetricId.MetricRange range, IMetricCategory ... category) {
        this(presentationName, description, isFloat, sorting, range, MetricScope.SYSTEM, category);
    }

    private TypescriptMetricId(String presentationName, String description, boolean isFloat, IMetricId.StandardSorting sorting, IMetricId.MetricRange range, MetricScope metricScope, IMetricCategory ... category) {
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'TypescriptMetricId' must not be empty";
        assert (description != null && description.length() > 0) : "Parameter 'description' of method 'TypescriptMetricId' must not be empty";
        assert (metricScope != null) : "Parameter 'metricScope' of method 'TypescriptMetricId' must not be null";
        this.m_presentationName = presentationName;
        this.m_description = description;
        this.m_isFloat = isFloat;
        this.m_metricScope = metricScope;
        this.m_categories = category;
        this.m_sorting = sorting;
        this.m_range = range;
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public IProviderId getProvider() {
        return TypescriptProviderId.INSTANCE;
    }

    public String getDescription() {
        return this.m_description;
    }

    public boolean isFloat() {
        return this.m_isFloat;
    }

    public List<IMetricCategory> getCategories() {
        return Arrays.asList(this.m_categories);
    }

    public IMetricId.IMetricRange getRange() {
        return this.m_range;
    }

    public IMetricId.StandardSorting getSorting() {
        return this.m_sorting;
    }

    public MetricScope getMetricScope() {
        return this.m_metricScope;
    }

    public static TypescriptMetricId[] values() {
        TypescriptMetricId[] typescriptMetricIdArray = ENUM$VALUES;
        int n = typescriptMetricIdArray.length;
        TypescriptMetricId[] typescriptMetricIdArray2 = new TypescriptMetricId[n];
        System.arraycopy(ENUM$VALUES, 0, typescriptMetricIdArray2, 0, n);
        return typescriptMetricIdArray2;
    }

    public static TypescriptMetricId valueOf(String string) {
        return Enum.valueOf(TypescriptMetricId.class, string);
    }
}

