/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericClass;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import java.io.IOException;

public final class TypescriptClass
extends GenericClass {
    private String m_typeParameters;

    public TypescriptClass(NamedElement parent) {
        super(parent);
    }

    public TypescriptClass(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, boolean isAbstract) {
        super(msp, parent, name, lineNumber, isAbstract);
    }

    public void setTypeParameters(String typeParameters) {
        this.m_typeParameters = typeParameters;
    }

    public String getShortName() {
        StringBuilder sb = new StringBuilder(super.getShortName());
        if (this.m_typeParameters.length() > 0) {
            sb.append('<').append(this.m_typeParameters.replace(";", ", ")).append('>');
        }
        return sb.toString();
    }

    public String getName() {
        NamedElement parent = this.getParent();
        if (parent instanceof SourceFile) {
            return this.getShortName();
        }
        return parent.getName() + "." + this.getShortName();
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_typeParameters);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_typeParameters = reader.readString();
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitTypescriptClass(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitTypescriptClass(TypescriptClass var1);
    }
}

