/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.foundation.common;

import com.hello2morrow.sonargraph.foundation.utilities.PathReader;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeJsLocator {
    private static final Logger LOGGER;
    private static List<String> PATH;
    private static String NODE;
    private static String NODE_EXE;

    static {
        int n;
        String[] extraLocations;
        LOGGER = LoggerFactory.getLogger(NodeJsLocator.class);
        PATH = new ArrayList<String>();
        NODE_EXE = null;
        if (Platform.isWindows()) {
            String programFiles = System.getenv("ProgramFiles");
            if (programFiles == null || programFiles.length() == 0) {
                programFiles = "C:\\Program Files";
            }
            NODE = "node.exe";
            extraLocations = new String[]{programFiles + "\\nodejs"};
        } else if (Platform.isMac()) {
            NODE = "node";
            extraLocations = new String[]{"/usr/local/bin", "/opt/homebrew/bin"};
        } else {
            NODE = "node";
            extraLocations = new String[]{"/usr/local/bin"};
        }
        String path = PathReader.readPathFromEnvironment();
        if (path != null) {
            String[] dirs;
            String[] stringArray = dirs = path.split(File.pathSeparator);
            int n2 = dirs.length;
            n = 0;
            while (n < n2) {
                String dir = stringArray[n];
                PATH.add(dir);
                ++n;
            }
        }
        String[] stringArray = extraLocations;
        n = extraLocations.length;
        int n3 = 0;
        while (n3 < n) {
            File dirFile;
            String dir = stringArray[n3];
            if (!PATH.contains(dir) && (dirFile = new File(dir)).isDirectory()) {
                PATH.add(dir);
            }
            ++n3;
        }
    }

    private NodeJsLocator() {
    }

    public static String locateNodeJsExecutable() {
        TFile node = null;
        if (NODE_EXE == null) {
            for (String dir : PATH) {
                node = new TFile(dir, NODE);
                if (!node.exists()) continue;
                NODE_EXE = node.getNormalizedAbsolutePath();
                LOGGER.info("Located node executable at: " + NODE_EXE);
                break;
            }
        }
        if (NODE_EXE == null) {
            LOGGER.error("Could not locate NodeJS in path " + PATH.toString());
        }
        return NODE_EXE;
    }
}

