/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client;

import com.hello2morrow.sonargraph.build.api.ISonargraphBuild;
import com.hello2morrow.sonargraph.build.api.ServiceResponse;
import com.hello2morrow.sonargraph.build.api.SonargraphBuildException;
import com.hello2morrow.sonargraph.build.api.StartupRequest;
import com.hello2morrow.sonargraph.build.api.StatusCode;
import com.hello2morrow.sonargraph.build.client.ILogger;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildProxy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

final class SonargraphBuildProxy
implements ISonargraphBuildProxy {
    private static final String SHARED_BUILD_API_PACKAGE = "com.hello2morrow.sonargraph.build.api";
    private static final String BUNDLE_NAME = "com.hello2morrow.sonargraph.build";
    private static final String APPLICATION_NAME = "SonargraphBuild";
    private static final String BUILD_APPLICATION = "com.hello2morrow.sonargraph.build.application";
    private static final long APPLICATION_START_TIMEOUT = 90000L;
    private static final long MAX_WAIT_PERIOD_FOR_SHUTDOWN_IN_MILLIS = 5000L;
    private static final String LOGBACK_XML = "logback.xml";
    private static final String SYS_PROPERTY_TIMEOUT = "sonargraph.startupTimeout";
    public static final String DEFAULT_LOG_FILENAME = "sonargraph_build.log";
    private Bundle m_bundle;
    private BundleContext m_context;
    private final String m_installationDir;
    private final StartupRequest m_startupRequest;
    private ServiceResponse m_startupResponse;
    private ISonargraphBuild.Version m_version;
    private final ILogger m_logger;
    private Path m_tempConfigurationArea;

    public SonargraphBuildProxy(String installationDir, StartupRequest request, ILogger logger) {
        this.m_installationDir = installationDir;
        this.m_startupRequest = request;
        this.m_logger = logger;
    }

    @Override
    public ServiceResponse start() {
        try {
            this.m_tempConfigurationArea = Files.createTempDirectory(null, new FileAttribute[0]);
        }
        catch (Throwable t) {
            return this.createError("Failed to create temporary folder: " + t.getMessage());
        }
        Path configurationPath = Paths.get(this.m_installationDir, "configuration");
        String configurationInInstallation = configurationPath.toAbsolutePath().normalize().toString().replace('\\', '/');
        String tempDirectoryPath = this.m_tempConfigurationArea.toAbsolutePath().normalize().toString().replace('\\', '/');
        this.applyLogConfiguration(this.m_tempConfigurationArea, configurationInInstallation, tempDirectoryPath);
        this.m_bundle = null;
        try {
            HashMap<String, String> initialProperties = new HashMap<String, String>();
            initialProperties.put("java.awt.headless", "true");
            initialProperties.put("eclipse.ignoreApp", "false");
            initialProperties.put("osgi.noShutdown", "false");
            initialProperties.put("osgi.sharedConfiguration.area", configurationInInstallation);
            initialProperties.put("org.osgi.framework.storage", this.m_tempConfigurationArea.toAbsolutePath().toString());
            initialProperties.put("org.osgi.framework.system.packages.extra", SHARED_BUILD_API_PACKAGE);
            EclipseStarter.setInitialProperties(initialProperties);
            this.m_context = EclipseStarter.startup((String[])new String[]{"-clean", "-consoleLog", "-application", BUILD_APPLICATION}, null);
            for (Bundle next : this.m_context.getBundles()) {
                if (next.getSymbolicName().equals(BUNDLE_NAME)) {
                    this.m_bundle = next;
                }
                if (!this.isLogLevelDebugOrFiner(this.m_startupRequest)) continue;
                this.logBundle(next);
            }
            if (this.m_bundle == null) {
                return this.createError(String.format("Failed to find bundle '%s'. Please check that the installation directory '%s' and classpath configuration are correct.", BUNDLE_NAME, this.m_installationDir));
            }
            long startupTimeout = this.determineStartupTimeout();
            this.m_startupResponse = new ServiceResponse(StatusCode.OK, "Starting application");
            Thread application = new Thread(() -> {
                try {
                    Object response = EclipseStarter.run((Object)this.m_startupRequest);
                    this.m_startupResponse = response instanceof ServiceResponse ? (ServiceResponse)response : this.createError("Failed to startup SonargraphBuild. Please check the log for details.");
                }
                catch (Exception e) {
                    System.err.print("Failed to start Sonargraph Build: ");
                    e.printStackTrace();
                    this.m_startupResponse = this.createError("Failed to startup SonargraphBuild. Please check the log for details.");
                }
            }, APPLICATION_NAME);
            application.start();
            ISonargraphBuild service = this.getServiceReference();
            long start = System.currentTimeMillis();
            long duration = 0L;
            while (this.m_startupResponse.getStatusCode() == StatusCode.OK && (service == null || service.getInitializationStatus().getStatusCode() != StatusCode.OK)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                duration = System.currentTimeMillis() - start;
                if (duration > startupTimeout) {
                    application.interrupt();
                    return this.createError("Failed to startup SonargraphBuild within " + startupTimeout + " ms. Please check the log for details.");
                }
                service = this.getServiceReference();
            }
            if (this.m_startupResponse.isFailure()) {
                throw new SonargraphBuildException(this.m_startupResponse.getStatusMessage());
            }
            this.m_version = service.getVersion();
            return this.m_startupResponse;
        }
        catch (Exception ex) {
            return this.createError("Failed to startup SonargraphBuild: " + ex.getMessage());
        }
    }

    private void applyLogConfiguration(Path tempFolder, String configurationDirectoryPath, String tempDirectoryPath) {
        if (this.m_startupRequest.getLogFile() != null) {
            File inputFile = Paths.get(this.m_installationDir, "configuration", LOGBACK_XML).toFile();
            File outputFile = Paths.get(tempFolder.toString(), LOGBACK_XML).toFile();
            if (this.writeLogbackConfiguration(inputFile, outputFile, this.m_startupRequest.getLogFile())) {
                System.setProperty("logback.configurationFile", tempDirectoryPath + "/logback.xml");
            } else {
                System.setProperty("logback.configurationFile", configurationDirectoryPath + "/logback.xml");
            }
        } else {
            System.setProperty("logback.configurationFile", configurationDirectoryPath + "/logback.xml");
        }
    }

    private long determineStartupTimeout() {
        String timeout = System.getProperty(SYS_PROPERTY_TIMEOUT);
        long startupTimeout = 90000L;
        if (timeout != null) {
            try {
                long parsedNumber = Long.parseLong(timeout);
                if (parsedNumber < 1L) {
                    System.err.println("System property 'sonargraph.startupTimeout' must be a positive number, but is currently set to '" + parsedNumber + "'. Using default value '90000' instead.");
                }
                startupTimeout = parsedNumber < 1L ? 90000L : parsedNumber;
            }
            catch (NumberFormatException ex) {
                System.err.println("System property 'sonargraph.startupTimeout' is not a valid number:" + ex.getMessage() + ". Using default value '90000' instead.");
            }
        } else {
            long retryPeriod;
            if (this.m_startupRequest.getWaitForLicense() == StartupRequest.WaitForLicenseTicket.INFINITE) {
                return 900000L;
            }
            if (this.m_startupRequest.getWaitForLicense() != StartupRequest.WaitForLicenseTicket.NEVER && (retryPeriod = (long)(this.m_startupRequest.getWaitForLicense().getCount() * 60 * 1000)) > startupTimeout) {
                startupTimeout = retryPeriod + 30000L;
            }
        }
        return startupTimeout;
    }

    private boolean isLogLevelDebugOrFiner(StartupRequest request) {
        assert (request != null) : "Parameter 'request' of method 'isLogLevelDebugOrFiner' must not be null";
        switch (request.getLogLevel().toLowerCase()) {
            case "debug": 
            case "trace": 
            case "all": {
                return true;
            }
        }
        return false;
    }

    private void logBundle(Bundle next) {
        int state = next.getState();
        this.m_logger.info("Installed bundle: " + next.getSymbolicName() + ", " + (switch (state) {
            case 2 -> "INSTALLED";
            case 4 -> "RESOLVED";
            case 8 -> "STARTING";
            case 16 -> "STOPPING";
            case 32 -> "ACTIVE";
            default -> "unknown";
        }) + ", " + next.getLocation());
        if (next.getRegisteredServices() != null) {
            this.m_logger.info("\tServices registered:");
            for (ServiceReference nextService : next.getRegisteredServices()) {
                this.m_logger.info("\t\tService: " + nextService.toString());
            }
        }
    }

    private boolean writeLogbackConfiguration(File inputFile, File outputFile, String path) {
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFile));
             BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            Object line;
            while ((line = reader.readLine()) != null) {
                int fileIndex = ((String)line).indexOf("<file>");
                if (fileIndex >= 0) {
                    line = "<file>" + path + "</file>";
                }
                writer.append((CharSequence)line);
                writer.newLine();
            }
        }
        catch (Exception e) {
            this.m_logger.error("Failed to apply configured log file '" + this.m_startupRequest.getLogFile() + "'. Using default './sonargraph_build.log'.\n  Exception: " + e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ServiceResponse stop() {
        String msg;
        StringBuilder error = new StringBuilder();
        try {
            if (this.m_bundle != null && this.m_bundle.getState() == 32) {
                this.m_bundle.stop();
            }
        }
        catch (BundleException ex) {
            msg = "Failed to stop SonargraphBuild: " + ex.getMessage();
            System.err.println(msg);
            error.append(msg).append("\n");
        }
        finally {
            try {
                EclipseStarter.shutdown();
                long start = System.currentTimeMillis();
                while (true) {
                    if (!EclipseStarter.isRunning() || System.currentTimeMillis() - start > 5000L) {
                        error.append("Failed to stop Sonargraph-Build within 5000ms.");
                        break;
                    }
                    try {
                        this.m_logger.info("Waiting for Sonargraph-Build to shut down (" + (System.currentTimeMillis() - start) + "ms) ...");
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Exception e) {
                msg = "Failed to stop SonargraphBuild: " + e.getMessage();
                this.m_logger.error(msg);
                error.append(msg).append("\n");
            }
            finally {
                if (this.m_tempConfigurationArea != null) {
                    String errorMsg = "Failed to delete temporary directory '" + String.valueOf(this.m_tempConfigurationArea.toAbsolutePath()) + "'";
                    try {
                        Files.walk(this.m_tempConfigurationArea, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                        if (this.m_tempConfigurationArea.toFile().exists()) {
                            this.m_logger.error(errorMsg);
                        }
                    }
                    catch (IOException ex) {
                        this.m_logger.error(errorMsg + ": " + ex.getMessage());
                    }
                }
            }
        }
        if (error.length() > 0) {
            return new ServiceResponse(StatusCode.FAILED, error.toString());
        }
        return new ServiceResponse(StatusCode.OK, "Successfully stopped SonargraphBuild");
    }

    @Override
    public ISonargraphBuild getServiceReference() {
        if (this.m_context == null) {
            return null;
        }
        ServiceReference reference = this.m_context.getServiceReference(ISonargraphBuild.class);
        if (reference == null) {
            return null;
        }
        ISonargraphBuild service = (ISonargraphBuild)this.m_context.getService(reference);
        if (this.m_version == null) {
            this.m_version = service.getVersion();
        }
        return service;
    }

    public ServiceResponse close() {
        ISonargraphBuild service = this.getServiceReference();
        if (service != null) {
            ServiceResponse close = service.close();
            if (close.getStatusCode() == StatusCode.OK) {
                this.m_logger.info("System successfully closed");
            } else {
                this.m_logger.error("Failed to close system: " + close.getStatusMessage());
            }
            return close;
        }
        return this.createError("Failed to close software system. No service available!");
    }

    private ServiceResponse createError(String errorMsg) {
        assert (errorMsg != null) : "Parameter 'errorMsg' of method 'createError' must not be null";
        return new ServiceResponse(StatusCode.FAILED, errorMsg);
    }
}

