/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.api;

import com.hello2morrow.sonargraph.build.api.ProgressInfo;

public final class StartupRequest {
    private static final ProgressInfo DEFAULT_PROGRESS_INFO = ProgressInfo.NONE;
    private String m_installationDirectory;
    private String m_activationCode;
    private String m_licenseFile;
    private String m_languages;
    private String m_logFilePath;
    private String m_logLevel = "info";
    private String m_proxyHost;
    private String m_proxyPort;
    private String m_proxyUsername;
    private String m_proxyPassword;
    private String m_licenseServerUrl;
    private String m_licenseServerHost;
    private String m_licenseServerPort;
    private String m_analyzerExecutionLevel;
    private ProgressInfo m_progressInfo = DEFAULT_PROGRESS_INFO;
    private WaitForLicenseTicket m_waitForLicense = WaitForLicenseTicket.NEVER;
    private String m_waitForLicenseString;

    public String getInstallationDirectory() {
        return this.m_installationDirectory;
    }

    public void setInstallationDirectory(String installationDirectory) {
        assert (installationDirectory != null) : "Parameter 'installationDirectory' of method 'setInstallationDirectory' must not be null";
        this.m_installationDirectory = installationDirectory;
    }

    public String getActivationCode() {
        return this.m_activationCode;
    }

    public void setActivationCode(String activationCode) {
        this.m_activationCode = activationCode;
    }

    public String getLicenseFile() {
        return this.m_licenseFile;
    }

    public void setLicenseFile(String licenseFile) {
        this.m_licenseFile = licenseFile;
    }

    public String getAnalyzerExecutionLevel() {
        return this.m_analyzerExecutionLevel == null ? "FULL" : this.m_analyzerExecutionLevel.toUpperCase();
    }

    public void setAnalyzerExecutionLevel(String analyzerExecutionLevel) {
        this.m_analyzerExecutionLevel = analyzerExecutionLevel;
    }

    public void addLanguageIfNotPresent(String language) {
        if (language == null || language.trim().isEmpty()) {
            return;
        }
        if (this.m_languages != null && !this.m_languages.contains(language)) {
            this.m_languages = this.m_languages.endsWith(",") ? this.m_languages + language : this.m_languages + "," + language;
        }
    }

    public String getLanguages() {
        return this.m_languages;
    }

    public void setLanguages(String languages) {
        this.m_languages = languages != null ? languages.trim() : null;
    }

    @Deprecated
    public String getLogFilePath() {
        return this.getLogFile();
    }

    public String getLogFile() {
        return this.m_logFilePath;
    }

    public void setLogFile(String logFilePath) {
        this.m_logFilePath = logFilePath;
    }

    public String getLogLevel() {
        return this.m_logLevel;
    }

    public void setLogLevel(String logLevel) {
        if (logLevel != null) {
            this.m_logLevel = logLevel;
        }
    }

    public String getProxyHost() {
        return this.m_proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.m_proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.m_proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.m_proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.m_proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.m_proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.m_proxyPassword = proxyPassword;
    }

    public String getProxyPassword() {
        return this.m_proxyPassword;
    }

    public String getLicenseServerUrl() {
        if (this.m_licenseServerUrl != null && !this.m_licenseServerUrl.trim().isEmpty()) {
            return this.m_licenseServerUrl.trim();
        }
        int port = 8080;
        if (this.m_licenseServerHost == null || this.m_licenseServerHost.isEmpty()) {
            return null;
        }
        if (this.m_licenseServerPort != null && !this.m_licenseServerPort.isEmpty()) {
            try {
                port = Integer.valueOf(this.m_licenseServerPort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return String.format("http://%s:%d", this.m_licenseServerHost.trim(), port);
    }

    public void setLicenseServerUrl(String licenseServerUrl) {
        this.m_licenseServerUrl = licenseServerUrl;
    }

    public void setLicenseServerHost(String licenseServerHost) {
        this.m_licenseServerHost = licenseServerHost;
    }

    public void setLicenseServerPort(String licenseServerPort) {
        this.m_licenseServerPort = licenseServerPort;
    }

    public ProgressInfo getProgressInfo() {
        return this.m_progressInfo;
    }

    public void setProgressInfoAsString(String progressInfoValue) {
        this.m_progressInfo = progressInfoValue == null || progressInfoValue.trim().length() == 0 ? DEFAULT_PROGRESS_INFO : ProgressInfo.fromString(progressInfoValue);
    }

    public void initWaitForLicense() {
        this.m_waitForLicense = this.m_waitForLicenseString == null || this.m_waitForLicenseString.trim().isEmpty() ? WaitForLicenseTicket.NEVER : WaitForLicenseTicket.create(this.m_waitForLicenseString);
    }

    public WaitForLicenseTicket getWaitForLicense() {
        if (this.m_waitForLicense == null) {
            throw new RuntimeException("initWaitForLicense must be called first!");
        }
        return this.m_waitForLicense;
    }

    public void setWaitForLicenseString(String tries) {
        this.m_waitForLicenseString = tries;
    }

    public String getWaitForLicenseString() {
        return this.m_waitForLicenseString;
    }

    public static final class WaitForLicenseTicket {
        public static final WaitForLicenseTicket NEVER = new WaitForLicenseTicket(0);
        public static final WaitForLicenseTicket INFINITE = new WaitForLicenseTicket(-1);
        public static final WaitForLicenseTicket DEFAULT = NEVER;
        public static final int PAUSE_FOR_RETRY_IN_SECONDS = 60;
        private final int m_count;

        private WaitForLicenseTicket(int count) {
            this.m_count = count;
        }

        public int getCount() {
            return this.m_count;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.m_count;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WaitForLicenseTicket other = (WaitForLicenseTicket)obj;
            return this.m_count == other.m_count;
        }

        public static WaitForLicenseTicket create(String tries) {
            if (tries == null || tries.trim().isEmpty()) {
                return DEFAULT;
            }
            return WaitForLicenseTicket.create(Integer.parseInt(tries));
        }

        public static WaitForLicenseTicket create(int tries) {
            switch (tries) {
                case -1: {
                    return INFINITE;
                }
                case 0: {
                    return NEVER;
                }
            }
            return new WaitForLicenseTicket(tries);
        }
    }
}

