/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.pmd;

import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.ISourceFileAccess;
import com.hello2morrow.sonargraph.api.ITypeAccess;
import com.hello2morrow.sonargraph.api.ModelVisitor;
import de.schlichtherle.truezip.file.TFile;
import java.util.HashMap;
import java.util.Map;

final class SourceFileRegistry
extends ModelVisitor {
    private final Map<String, ISourceFileAccess> m_pathToSourceFile = new HashMap<String, ISourceFileAccess>();

    SourceFileRegistry() {
    }

    public void visitNamedElementAccess(INamedElementAccess element) {
        assert (element != null) : "Parameter 'element' of method 'visitNamedElementAccess' must not be null";
        if (element.isExternal() || element.isExcluded() || element.ignoreIssues()) {
            return;
        }
        if (element instanceof ITypeAccess) {
            TFile sourceFile;
            ITypeAccess typeAccess = (ITypeAccess)element;
            ISourceFileAccess sourceFileAccess = typeAccess.getSourceFile();
            if (sourceFileAccess != null && !sourceFileAccess.isModified() && (sourceFile = sourceFileAccess.getFile()) != null && sourceFile.exists()) {
                if (sourceFile.isEntry()) {
                    String archive = sourceFile.getEnclArchive().getAbsolutePath();
                    String inArchive = sourceFile.getEnclEntryName();
                    this.m_pathToSourceFile.put(archive + ":" + inArchive, sourceFileAccess);
                } else {
                    this.m_pathToSourceFile.put(sourceFile.getAbsolutePath(), sourceFileAccess);
                }
            }
            return;
        }
        super.visitNamedElementAccess(element);
    }

    ISourceFileAccess getSourceFileAccess(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'getSourceFileAccess' must not be empty";
        return this.m_pathToSourceFile.get(path);
    }

    boolean isEmpty() {
        return this.m_pathToSourceFile.isEmpty();
    }
}

