/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.refactoring;

import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaInternalCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaPackageFragment;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaRefactoringUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaRefactoringUtility.class);

    public static List<NamedElement> getElements(RefactoringDefinition refactoring) {
        assert (refactoring != null) : "Parameter 'refactoring' of method 'getElements()' must not be null";
        ArrayList<NamedElement> elements = new ArrayList<NamedElement>();
        for (IIssue issue : refactoring.getAssociatedIssues()) {
            Element element = issue.getAffectedElement();
            if (element instanceof JavaElement) {
                elements.add((NamedElement)((JavaElement)element).getOriginal());
                continue;
            }
            if (element instanceof JavaPackageFragment) {
                elements.add(((JavaPackageFragment)element).getOriginal());
                continue;
            }
            if (element instanceof JavaInternalCompilationUnit) {
                elements.add(((JavaInternalCompilationUnit)element).getOriginal());
                continue;
            }
            if (element instanceof JavaSourceFile) {
                LOGGER.warn("Detected unexpected source file: {}", (Object)((JavaSourceFile)element).getOriginalFullyQualifiedName());
                elements.add(((JavaSourceFile)element).getOriginal());
                continue;
            }
            LOGGER.trace("No Java Element! {}", (Object)element);
        }
        return elements;
    }

    public static boolean isDependencyRefactoring(RefactoringDefinition refactoring) {
        assert (refactoring != null) : "Parameter 'refactoring' of method 'isDependencyRefactoring' must not be null";
        for (IIssue issue : refactoring.getAssociatedIssues()) {
            Element element = issue.getAffectedElement();
            if (!(element instanceof Dependency)) continue;
            return true;
        }
        return false;
    }
}

