/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.kotlinfile;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.AnonymousNestedTypesHelper;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.AnonymousTypeInfo;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.ChangeParentProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaGlobalModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaModuleModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.JavaFileParseResult;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.KotlinTypeProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.MethodProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.kotlinfile.IKotlinType;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.kotlinfile.Identifier;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.kotlinfile.IdentifierVisitor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.kotlinfile.KotlinParser;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.kotlinfile.KotlinParserBaseVisitor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.kotlinfile.MultiIdentifierVisitor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.kotlinfile.ParameterListVisitor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaConstructor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaNonInitializer;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.KotlinFunction;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.KotlinGhostProxy;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.objectweb.asm.Type;

public final class KotlinSyntaxTreeVisitor
extends KotlinParserBaseVisitor<Void> {
    private static Set<String> s_scopeFunctionNames = new THashSet();
    private final JavaFileParseResult m_result;
    private final IJavaGlobalModel m_globalModel;
    private final IJavaModuleModel m_moduleModel;
    private final Deque<JavaElement> m_elementStack = new ArrayDeque<JavaElement>();
    private final Map<JavaElement, JavaType> m_associatedAnonymousClass = new THashMap();
    private JavaType m_kotlinHelperClass = null;
    private Identifier m_currentIdent;
    private JavaMethod m_currentMethod;
    private int m_currentNesting;
    private int m_maxNesting;
    private boolean m_isScopeFunction;
    private boolean m_inFileAnnotations = false;
    private String m_fileAnnotationName;
    private String m_fileAnnotationValue;
    private String m_helperClassName;

    static {
        s_scopeFunctionNames.add("apply");
        s_scopeFunctionNames.add("let");
        s_scopeFunctionNames.add("run");
        s_scopeFunctionNames.add("also");
        s_scopeFunctionNames.add("with");
    }

    public KotlinSyntaxTreeVisitor(String fileName, JavaFileParseResult result, IJavaGlobalModel globalModel, IJavaModuleModel moduleModel) {
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'KotlinSyntaxTreeVisitor' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'KotlinSyntaxTreeVisitor' must not be null";
        assert (globalModel != null) : "Parameter 'globalModel' of method 'KotlinSyntaxTreeVisitor' must not be null";
        assert (moduleModel != null) : "Parameter 'modu' of method 'KotlinSyntaxTreeVisitor' must not be null";
        this.m_result = result;
        this.m_globalModel = globalModel;
        this.m_moduleModel = moduleModel;
        this.m_helperClassName = (FileUtility.removeExtension((String)fileName).toLowerCase() + "kt").replace("-", "_");
    }

    @Override
    public Void visitKotlinFile(KotlinParser.KotlinFileContext ctx) {
        assert (ctx != null) : "Parameter 'ctx' of method 'visitKotlinFile' must not be null";
        this.visitChildren((RuleNode)ctx);
        ArrayList unasssignedAnonymousClasses = new ArrayList();
        for (JavaElement tle : this.m_result.getTopLevelElements()) {
            tle.getChildrenRecursively(JavaType.class, new Class[0]).stream().filter(t -> t.isAnonymous() && t.getLineNumber() <= 0).forEach(t -> {
                boolean bl = unasssignedAnonymousClasses.add(t);
            });
        }
        return null;
    }

    @Override
    public Void visitFileAnnotation(KotlinParser.FileAnnotationContext ctx) {
        assert (!this.m_inFileAnnotations);
        this.m_inFileAnnotations = true;
        try {
            this.visitChildren((RuleNode)ctx);
            if (this.m_fileAnnotationName != null && this.m_fileAnnotationName.equals("JvmName") && this.m_fileAnnotationValue != null) {
                this.m_globalModel.addKotlinHelperClass(this.m_fileAnnotationValue);
                this.m_helperClassName = this.m_fileAnnotationValue.toLowerCase();
            }
        }
        finally {
            this.m_inFileAnnotations = false;
            this.m_fileAnnotationName = null;
            this.m_fileAnnotationValue = null;
        }
        return null;
    }

    @Override
    public Void visitUserType(KotlinParser.UserTypeContext ctx) {
        KotlinParser.SimpleUserTypeContext suc;
        super.visitUserType(ctx);
        if (this.m_inFileAnnotations && (suc = ctx.simpleUserType(0)) != null) {
            this.m_fileAnnotationName = suc.simpleIdentifier().Identifier().getText();
        }
        return null;
    }

    @Override
    public Void visitLineStringContent(KotlinParser.LineStringContentContext ctx) {
        super.visitLineStringContent(ctx);
        if (this.m_inFileAnnotations) {
            this.m_fileAnnotationValue = ctx.LineStrText().getText();
        }
        return null;
    }

    @Override
    public Void visitPackageHeader(KotlinParser.PackageHeaderContext ctx) {
        assert (ctx != null) : "Parameter 'ctx' of method 'visitPackageHeader' must not be null";
        KotlinParser.IdentifierContext idContext = ctx.identifier();
        String pkgName = null;
        if (idContext != null) {
            pkgName = ctx.identifier().accept(new IdentifierVisitor()).getName();
            this.m_result.setPackageName(pkgName);
        }
        this.m_kotlinHelperClass = this.m_globalModel.findKotlinHelperClass(this.m_moduleModel.getModule(), this.m_helperClassName, pkgName);
        if (this.m_kotlinHelperClass != null) {
            this.m_kotlinHelperClass.addFlag(JavaElementFlag.GHOST);
            this.m_kotlinHelperClass.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            this.m_result.addTopLevelElement(this.m_kotlinHelperClass);
            this.m_globalModel.addProcessor(new KotlinTypeProcessor(this.m_kotlinHelperClass, 0));
        }
        return null;
    }

    private JavaType findToplevelType(String name) {
        assert (name != null) : "Parameter 'name' of method 'findToplevelType' must not be null";
        String pkgName = this.m_result.getPackageName();
        Object fullName = pkgName == null || pkgName.isEmpty() ? name : pkgName + "." + name;
        return this.m_globalModel.getType(this.m_moduleModel.getModule(), (String)fullName);
    }

    @Override
    public Void visitClassDeclaration(KotlinParser.ClassDeclarationContext ctx) {
        JavaType newCurrentType;
        assert (ctx != null) : "Parameter 'ctx' of method 'visitClassDeclaration' must not be null";
        Identifier id = ctx.simpleIdentifier().accept(new IdentifierVisitor());
        JavaElement parent = null;
        if (this.m_elementStack.isEmpty()) {
            newCurrentType = this.findToplevelType(id.getName());
            if (newCurrentType != null) {
                this.m_result.addTopLevelElement(newCurrentType);
            }
        } else {
            JavaType current = this.getCurrentType(false);
            String contextName = this.getContextName(false) + id.getName();
            parent = this.m_elementStack.peek();
            newCurrentType = (JavaType)current.getFirstChild(c -> c.getName().endsWith(contextName), JavaType.class);
        }
        if (newCurrentType != null) {
            newCurrentType.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            newCurrentType.setLineNumber(id.getLine());
            if (parent != null && parent != newCurrentType.getParent()) {
                this.m_globalModel.addProcessor(new ChangeParentProcessor(parent, newCurrentType));
            }
            this.m_elementStack.push(newCurrentType);
            if (ctx.primaryConstructor() != null) {
                ctx.primaryConstructor().accept(this);
            }
            if (ctx.classBody() != null) {
                ctx.classBody().accept(this);
            } else if (ctx.enumClassBody() != null) {
                ctx.enumClassBody().accept(this);
            }
            this.m_elementStack.pop();
            this.m_globalModel.addProcessor(new KotlinTypeProcessor(newCurrentType, ctx.stop.getLine()));
        }
        return null;
    }

    @Override
    public Void visitPrimaryConstructor(KotlinParser.PrimaryConstructorContext ctx) {
        assert (ctx != null) : "Parameter 'ctx' of method 'visitPrimaryConstructor' must not be null";
        List<IKotlinType> paramTypes = ctx.classParameters().accept(new ParameterListVisitor());
        this.matchConstructor((JavaType)this.m_elementStack.peek(), paramTypes, ctx.classParameters().start.getLine());
        this.visitChildren((RuleNode)ctx);
        return null;
    }

    private String getContextName(boolean considerNestedFunctionHelpers) {
        ArrayDeque<String> nameParts = new ArrayDeque<String>();
        Iterator<JavaElement> iter = this.m_elementStack.iterator();
        boolean sawType = false;
        while (iter.hasNext()) {
            JavaType associatedClass;
            JavaElement element = iter.next();
            if (element instanceof JavaType) {
                JavaType type = (JavaType)element;
                nameParts.push(type.getName());
                sawType = true;
                break;
            }
            if (considerNestedFunctionHelpers && (associatedClass = this.m_associatedAnonymousClass.get(element)) != null) {
                nameParts.push(associatedClass.getName());
                sawType = true;
                break;
            }
            nameParts.push(element.getShortName());
        }
        if (!sawType && this.m_kotlinHelperClass != null) {
            nameParts.push(this.m_kotlinHelperClass.getName());
        }
        StringBuilder sb = new StringBuilder();
        while (!nameParts.isEmpty()) {
            sb.append((String)nameParts.pop()).append('$');
        }
        return sb.toString();
    }

    private JavaType getCurrentType(boolean considerNestedFunctionHelpers) {
        for (JavaElement element : this.m_elementStack) {
            JavaType associatedClass;
            if (element instanceof JavaType) {
                return (JavaType)element;
            }
            if (!considerNestedFunctionHelpers || (associatedClass = this.m_associatedAnonymousClass.get(element)) == null) continue;
            return associatedClass;
        }
        assert (this.m_kotlinHelperClass != null);
        return this.m_kotlinHelperClass;
    }

    private boolean matches(Type javaType, IKotlinType kotlinType) {
        assert (javaType != null) : "Parameter 'javaType' of method 'matches' must not be null";
        assert (kotlinType != null) : "Parameter 'kotlinType' of method 'matches' must not be null";
        return kotlinType.matches(javaType);
    }

    private JavaConstructor matchConstructor(List<JavaConstructor> constructors, List<IKotlinType> paramTypes) {
        assert (constructors != null) : "Parameter 'constructors' of method 'matchConstructor' must not be null";
        assert (paramTypes != null) : "Parameter 'paramTypes' of method 'matchConstructor' must not be null";
        JavaConstructor match = null;
        block0: for (JavaConstructor c : constructors) {
            Type[] argTypes = c.getParameterTypes();
            int i = 0;
            while (i < argTypes.length) {
                if (!this.matches(argTypes[i], paramTypes.get(i))) continue block0;
                ++i;
            }
            match = c;
            break;
        }
        return match;
    }

    private JavaConstructor matchConstructor(JavaType type, List<IKotlinType> paramTypes, int lineNumber) {
        assert (type != null) : "Parameter 'type' of method 'matchConstructor' must not be null";
        assert (paramTypes != null) : "Parameter 'paramTypes' of method 'matchConstructor' must not be null";
        JavaConstructor result = null;
        List constructors = type.getChildren(JavaConstructor.class);
        Iterator iter = constructors.iterator();
        while (iter.hasNext()) {
            JavaConstructor c = (JavaConstructor)iter.next();
            if (c.getNumberOfParameters() == paramTypes.size()) continue;
            iter.remove();
        }
        if (constructors.size() == 1) {
            result = (JavaConstructor)constructors.get(0);
        } else if (constructors.size() > 1) {
            result = this.matchConstructor(constructors, paramTypes);
        }
        if (result != null) {
            result.setLineNumber(lineNumber);
            result.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
        }
        return result;
    }

    @Override
    public Void visitSecondaryConstructor(KotlinParser.SecondaryConstructorContext ctx) {
        assert (ctx != null) : "Parameter 'ctx' of method 'visitSecondaryConstructor' must not be null";
        List<IKotlinType> paramTypes = ctx.functionValueParameters().accept(new ParameterListVisitor());
        JavaConstructor constructor = this.matchConstructor((JavaType)this.m_elementStack.peek(), paramTypes, ctx.CONSTRUCTOR().getSymbol().getLine());
        if (constructor != null && ctx.block() != null) {
            this.m_elementStack.push(constructor);
            ctx.block().accept(this);
            this.m_elementStack.pop();
        }
        return null;
    }

    @Override
    public Void visitCompanionObject(KotlinParser.CompanionObjectContext ctx) {
        assert (ctx != null) : "Parameter 'ctx' of method 'visitCompanionObject' must not be null";
        Identifier id = ctx.simpleIdentifier() != null ? ctx.simpleIdentifier().accept(new IdentifierVisitor()) : new Identifier("Companion", ctx.OBJECT().getSymbol().getLine());
        JavaElement parent = this.m_elementStack.peek();
        assert (parent instanceof JavaType);
        JavaType companionClass = (JavaType)parent.getFirstChild(e -> e.getShortName().equals(id.getName()), JavaType.class);
        if (companionClass != null) {
            companionClass.setLineNumber(id.getLine());
            companionClass.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            this.m_elementStack.push(companionClass);
            if (ctx.classBody() != null) {
                ctx.classBody().accept(this);
            }
            this.m_elementStack.pop();
            this.m_globalModel.addProcessor(new KotlinTypeProcessor(companionClass, ctx.stop.getLine()));
            JavaField companionField = (JavaField)parent.getFirstChild(e -> e.getShortName().equals(id.getName()), JavaField.class);
            if (companionField != null) {
                companionField.setLineNumber(id.getLine());
                companionField.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            }
        }
        return null;
    }

    @Override
    public Void visitFunctionDeclaration(KotlinParser.FunctionDeclarationContext ctx) {
        Identifier id = ctx.simpleIdentifier().accept(new IdentifierVisitor());
        JavaElement parent = this.m_elementStack.peek();
        if (parent instanceof JavaType) {
            JavaType type = (JavaType)parent;
            JavaMethod method = type.getChildren(e -> e.getShortName().equals(id.getName()) && e.getLineNumber() <= 0, JavaMethod.class).stream().filter(m -> !m.isStatic() && !m.isSynthetic() && !m.isBridge()).findFirst().orElse(null);
            if (method != null) {
                this.processMethod(ctx, method);
                JavaMethod parentStaticMethod = type.getParent().getChildren(e -> e.getShortName().equals(id.getName()) && e.getLineNumber() <= 0, JavaMethod.class).stream().filter(m -> m.isStatic() && method.getDescriptor().equals(m.getDescriptor())).findFirst().orElse(null);
                if (parentStaticMethod != null) {
                    parentStaticMethod.addFlag(JavaElementFlag.GHOST);
                    parentStaticMethod.addChild(new KotlinGhostProxy((NamedElement)parentStaticMethod, method, true));
                }
            }
        } else if (parent == null) {
            JavaMethod method;
            if (this.m_kotlinHelperClass != null && (method = (JavaMethod)this.m_kotlinHelperClass.getChildren(e -> e.getShortName().equals(id.getName()) && e.getLineNumber() <= 0, JavaMethod.class).stream().findFirst().orElse(null)) != null) {
                this.processMethod(ctx, method);
            }
        } else {
            assert (parent instanceof JavaMethod);
            JavaType currentType = this.getCurrentType(true);
            List<JavaType> anonymousTypes = AnonymousNestedTypesHelper.getNestedAnonymousTypes(currentType);
            JavaType anonymousType = this.matchByLine(anonymousTypes, ctx.start.getLine(), ctx.stop.getLine());
            if (anonymousType == null && (anonymousType = (JavaType)anonymousTypes.stream().filter(t -> t.getName().startsWith(this.getContextName(true))).findFirst().orElse(null)) == null) {
                anonymousType = anonymousTypes.stream().filter(t -> t.getName().startsWith(currentType.getName())).findFirst().orElse(null);
            }
            if (anonymousType != null) {
                this.m_associatedAnonymousClass.put(parent, anonymousType);
                anonymousType.setLineNumber(ctx.simpleIdentifier().start.getLine());
                anonymousType.addFlag(JavaElementFlag.GHOST);
                anonymousType.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
                this.m_globalModel.addProcessor(new ChangeParentProcessor(parent, anonymousType));
                this.m_globalModel.addProcessor(new KotlinTypeProcessor(anonymousType, ctx.stop.getLine()));
                JavaMethod invoke = (JavaMethod)anonymousType.getFirstChild(e -> e.getShortName().equals("invoke") && !((JavaElement)e).hasFlag(JavaElementFlag.BRIDGE), JavaMethod.class);
                if (invoke != null) {
                    invoke.addFlag(JavaElementFlag.GHOST);
                    invoke.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
                    KotlinFunction funct = (KotlinFunction)anonymousType.getFirstChild(c -> c.getShortName().equals(id.getName()), KotlinFunction.class);
                    if (funct == null) {
                        funct = new KotlinFunction(invoke.getModelServiceProvider(), (NamedElement)anonymousType, id.getName(), invoke.getDescriptor());
                        funct.setNumberOfParameters(invoke.getNumberOfParameters());
                        anonymousType.addChild((NamedElement)funct);
                    }
                    funct.addFlag(JavaElementFlag.KEEP);
                    this.processMethod(ctx, funct);
                    invoke.addChild(new KotlinGhostProxy((NamedElement)invoke, funct, false));
                }
            }
        }
        return null;
    }

    private void processMethod(KotlinParser.FunctionDeclarationContext ctx, JavaMethod method) {
        if (method.hasFlag(JavaElementFlag.SYNTHETIC)) {
            this.m_globalModel.removeSyntheticMethod(method);
        }
        method.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
        method.setLineNumber(ctx.simpleIdentifier().start.getLine());
        if (ctx.functionBody() != null) {
            this.m_elementStack.push(method);
            ctx.functionBody().accept(this);
            this.m_elementStack.pop();
        }
    }

    @Override
    public Void visitObjectDeclaration(KotlinParser.ObjectDeclarationContext ctx) {
        JavaType singletonClass;
        Identifier id = ctx.simpleIdentifier().accept(new IdentifierVisitor());
        JavaElement parent = this.m_elementStack.peek();
        if (parent instanceof JavaType) {
            singletonClass = (JavaType)parent.getFirstChild(e -> e.getShortName().equals(id.getName()), JavaType.class);
        } else {
            assert (parent == null);
            singletonClass = this.findToplevelType(id.getName());
            if (singletonClass != null) {
                this.m_result.addTopLevelElement(singletonClass);
            }
        }
        if (singletonClass != null) {
            singletonClass.setLineNumber(id.getLine());
            singletonClass.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            this.m_elementStack.push(singletonClass);
            if (ctx.classBody() != null) {
                ctx.classBody().accept(this);
            }
            this.m_elementStack.pop();
            this.m_globalModel.addProcessor(new KotlinTypeProcessor(singletonClass, ctx.stop.getLine()));
            JavaField instanceField = (JavaField)singletonClass.getFirstChild(e -> e.getShortName().equals("INSTANCE"), JavaField.class);
            if (instanceField != null) {
                instanceField.setLineNumber(id.getLine());
                singletonClass.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            }
        }
        return null;
    }

    private void processProperty(KotlinParser.PropertyDeclarationContext ctx, Identifier id) {
        KotlinFunction funct;
        int line;
        JavaType parentType;
        assert (id != null) : "Parameter 'id' of method 'processProperty' must not be null";
        JavaElement parent = this.m_elementStack.peek();
        if (parent instanceof JavaType) {
            parentType = (JavaType)parent;
        } else if (parent == null) {
            parentType = this.m_kotlinHelperClass;
        } else {
            if (ctx != null && ctx.expression() != null) {
                Identifier oldIdent = this.m_currentIdent;
                this.m_currentIdent = id;
                ctx.expression().accept(this);
                this.m_currentIdent = oldIdent;
            }
            return;
        }
        JavaField field = (JavaField)parentType.getFirstChild(e -> e.getShortName().equals(id.getName()), JavaField.class);
        if (field != null) {
            field.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            field.setLineNumber(id.getLine());
            field.removeFlag(JavaElementFlag.BRIDGE);
            field.removeFlag(JavaElementFlag.SYNTHETIC);
            this.m_globalModel.removeSyntheticField(field);
        } else {
            JavaField prop = this.m_globalModel.addField(parentType, id.getName(), null);
            prop.setLineNumber(id.getLine());
            prop.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            prop.addFlag(JavaElementFlag.KEEP);
            field = prop;
            JavaField javaStaticField = (JavaField)parentType.getParent().getFirstChild(e -> e.getShortName().equals(id.getName()), JavaField.class);
            if (javaStaticField != null && javaStaticField.isStatic()) {
                javaStaticField.addFlag(JavaElementFlag.GHOST);
                javaStaticField.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
                javaStaticField.addChild(new KotlinGhostProxy((NamedElement)javaStaticField, prop, true));
            }
        }
        String modifiedFieldName = id.getName().substring(0, 1).toUpperCase(Locale.ENGLISH) + id.getName().substring(1);
        String getterName = "get" + modifiedFieldName;
        String setterName = "set" + modifiedFieldName;
        List getters = parentType.getChildren(e -> e.getShortName().equals(getterName), JavaMethod.class).stream().filter(m -> m.getNumberOfParameters() == 0).collect(Collectors.toList());
        List setters = parentType.getChildren(e -> e.getShortName().equals(setterName), JavaMethod.class).stream().filter(m -> m.getNumberOfParameters() == 1).collect(Collectors.toList());
        JavaMethod getter = null;
        JavaMethod setter = null;
        if (getters.size() == 1) {
            getter = (JavaMethod)getters.get(0);
        } else if (getters.size() > 0) {
            getter = getters.stream().filter(g -> g.isSynthetic() || g.isBridge()).findFirst().orElse(null);
        }
        if (setters.size() == 1) {
            setter = (JavaMethod)setters.get(0);
        } else if (setters.size() > 0) {
            setter = setters.stream().filter(s -> s.isSynthetic() || s.isBridge()).findFirst().orElse(null);
        }
        if (getter != null) {
            KotlinParser.GetterContext gctx = ctx == null ? null : ctx.getter();
            line = gctx == null ? id.getLine() : gctx.start.getLine();
            funct = this.processGetterOrSetter(field, getter, "get", line);
            if (gctx != null && gctx.functionBody() != null) {
                this.m_elementStack.push(funct);
                gctx.functionBody().accept(this);
                this.m_elementStack.pop();
            }
        }
        if (setter != null) {
            KotlinParser.SetterContext sctx = ctx == null ? null : ctx.setter();
            line = sctx == null ? id.getLine() : sctx.start.getLine();
            funct = this.processGetterOrSetter(field, setter, "set", line);
            if (sctx != null && sctx.functionBody() != null) {
                this.m_elementStack.push(funct);
                sctx.functionBody().accept(this);
                this.m_elementStack.pop();
            }
        }
        if (ctx != null) {
            Identifier oldIdent = this.m_currentIdent;
            this.m_currentIdent = null;
            this.m_elementStack.push(field);
            if (ctx.expression() != null) {
                ctx.expression().accept(this);
            } else if (ctx.propertyDelegate() != null) {
                ctx.propertyDelegate().accept(this);
            }
            this.m_elementStack.pop();
            this.m_currentIdent = oldIdent;
        }
    }

    private KotlinFunction processGetterOrSetter(JavaElement field, JavaMethod m, String newName, int line) {
        KotlinFunction funct = (KotlinFunction)field.getFirstChild(c -> c.getShortName().equals(newName), KotlinFunction.class);
        if (funct == null) {
            funct = new KotlinFunction(m.getModelServiceProvider(), (NamedElement)field, newName, m.getDescriptor());
            field.addChild((NamedElement)funct);
            funct.setNumberOfParameters(m.getNumberOfParameters());
        }
        funct.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
        m.addFlag(JavaElementFlag.GHOST);
        m.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
        m.addChild(new KotlinGhostProxy((NamedElement)m, funct, false));
        funct.setLineNumber(line);
        m.setLineNumber(line);
        return funct;
    }

    @Override
    public Void visitPropertyDeclaration(KotlinParser.PropertyDeclarationContext ctx) {
        if (ctx.variableDeclaration() != null) {
            Identifier id2 = ctx.variableDeclaration().accept(new IdentifierVisitor());
            this.processProperty(ctx, id2);
        } else {
            List<Identifier> ids = ctx.multiVariableDeclaration().accept(new MultiIdentifierVisitor());
            ids.forEach(id -> this.processProperty(ctx, (Identifier)id));
        }
        return null;
    }

    @Override
    public Void visitAnonymousInitializer(KotlinParser.AnonymousInitializerContext ctx) {
        JavaType type = (JavaType)this.m_elementStack.peek();
        List constructors = type.getChildren(JavaConstructor.class);
        JavaConstructor primary = constructors.stream().filter(c -> c.getLineNumber() > 0).findFirst().orElse(null);
        JavaMethod method = this.m_currentMethod;
        int oldNesting = this.m_currentNesting;
        int oldMaxNesting = this.m_maxNesting;
        if (primary == null) {
            assert (constructors.size() == 1);
            primary = (JavaConstructor)constructors.get(0);
            primary.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            primary.setLineNumber(ctx.start.getLine());
            primary.initMetrics();
            this.m_maxNesting = 0;
        } else {
            this.m_maxNesting = primary.getMaxNesting();
        }
        this.m_currentNesting = 0;
        this.m_currentMethod = primary;
        this.m_elementStack.push(primary);
        ctx.block().accept(this);
        this.m_elementStack.pop();
        this.m_currentMethod = method;
        this.m_currentNesting = oldNesting;
        this.m_maxNesting = oldMaxNesting;
        return null;
    }

    @Override
    public Void visitClassParameter(KotlinParser.ClassParameterContext ctx) {
        if (ctx.VAL() != null || ctx.VAR() != null) {
            Identifier id = ctx.simpleIdentifier().accept(new IdentifierVisitor());
            this.processProperty(null, id);
        }
        return null;
    }

    private JavaType matchByLine(List<JavaType> anonymousTypes, int firstLineNumber, int lastLineNumber) {
        Iterator<JavaType> iter = anonymousTypes.iterator();
        ArrayList<JavaType> matches = new ArrayList<JavaType>();
        while (iter.hasNext()) {
            int firstStatementLine;
            JavaType candidate = iter.next();
            AnonymousTypeInfo info = this.m_moduleModel.getAnonymousTypeInfo(candidate);
            if (info == null) continue;
            if (info.hasInstantiationInfo()) {
                List<Integer> instList;
                Map<JavaMethod, List<Integer>> instMap = info.getInstantiationInfo();
                if (this.m_currentMethod != null ? (instList = instMap.get(this.m_currentMethod)) != null && instList.contains(firstLineNumber) : instMap.values().stream().anyMatch(list -> list.contains(firstLineNumber))) {
                    return candidate;
                }
            }
            if ((firstStatementLine = info.getLineNumberOfFirstInstructionInMethod()) <= 0 || firstLineNumber > firstStatementLine || firstStatementLine > lastLineNumber) continue;
            matches.add(candidate);
        }
        return matches.isEmpty() ? null : (JavaType)matches.get(0);
    }

    private JavaType getAnonymousType(JavaType type, ParserRuleContext ctx) {
        List<JavaType> anonymousTypes = AnonymousNestedTypesHelper.getNestedAnonymousTypes(type);
        JavaType anonymousType = this.matchByLine(anonymousTypes, ctx.start.getLine(), ctx.stop.getLine());
        if (anonymousType == null) {
            Object contextName = this.m_currentIdent != null ? this.getContextName(false) + this.m_currentIdent.getName() + "$" : this.getContextName(false);
            anonymousType = anonymousTypes.stream().filter(arg_0 -> KotlinSyntaxTreeVisitor.lambda$28((String)contextName, arg_0)).findFirst().orElse(null);
        }
        if (anonymousType != null) {
            anonymousType.setLineNumber(ctx.start.getLine());
            anonymousType.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            JavaElement parent = this.m_elementStack.peek();
            if (parent != null && anonymousType.getParent() != parent) {
                anonymousType.changeParent((NamedElement)parent, true);
            }
            this.m_globalModel.addProcessor(new KotlinTypeProcessor(anonymousType, ctx.stop.getLine()));
        }
        return anonymousType;
    }

    @Override
    public Void visitObjectLiteral(KotlinParser.ObjectLiteralContext ctx) {
        JavaType anonymousType = this.getAnonymousType(this.getCurrentType(false), ctx);
        if (anonymousType != null) {
            this.m_elementStack.push(anonymousType);
            ctx.classBody().accept(this);
            this.m_elementStack.pop();
        }
        return null;
    }

    @Override
    public Void visitPostfixUnaryExpression(KotlinParser.PostfixUnaryExpressionContext ctx) {
        boolean isScopeFunction = this.m_isScopeFunction;
        if (ctx.primaryExpression() != null) {
            ctx.primaryExpression().accept(this);
        }
        Identifier lastIdent = null;
        for (KotlinParser.PostfixUnarySuffixContext suffix : ctx.postfixUnarySuffix()) {
            if (suffix.navigationSuffix() != null) {
                lastIdent = suffix.navigationSuffix().simpleIdentifier() != null ? suffix.navigationSuffix().simpleIdentifier().accept(new IdentifierVisitor()) : null;
            } else if (suffix.callSuffix() != null) {
                this.m_isScopeFunction = lastIdent != null && s_scopeFunctionNames.contains(lastIdent.getName());
            } else {
                lastIdent = null;
            }
            suffix.accept(this);
        }
        this.m_isScopeFunction = isScopeFunction;
        return null;
    }

    @Override
    public Void visitCallSuffix(KotlinParser.CallSuffixContext ctx) {
        this.m_isScopeFunction = this.m_isScopeFunction && ctx.typeArguments() == null && ctx.valueArguments() == null;
        return (Void)super.visitCallSuffix(ctx);
    }

    @Override
    public Void visitFunctionBody(KotlinParser.FunctionBodyContext ctx) {
        NamedElement currentElement = (NamedElement)this.m_elementStack.peek();
        JavaMethod method = this.m_currentMethod;
        int oldNesting = this.m_currentNesting;
        int oldMaxNesting = this.m_maxNesting;
        if (currentElement instanceof JavaMethod) {
            this.m_currentMethod = (JavaMethod)currentElement;
            this.m_currentMethod.initMetrics();
            this.m_currentNesting = 0;
            this.m_maxNesting = 0;
            this.m_globalModel.addProcessor(new MethodProcessor(this.m_currentMethod, ctx.getStop().getLine()));
        } else {
            this.m_currentMethod = null;
        }
        this.visitChildren((RuleNode)ctx);
        if (this.m_currentMethod != null) {
            if (ctx.expression() != null && this.m_currentMethod.getNumberOfStatements() == 0) {
                this.m_currentMethod.incrementNumberOfStatements();
            }
            this.m_currentMethod.setMaxNesting(this.m_maxNesting);
        }
        this.m_currentMethod = method;
        this.m_currentNesting = oldNesting;
        this.m_maxNesting = oldMaxNesting;
        return null;
    }

    @Override
    public Void visitLambdaLiteral(KotlinParser.LambdaLiteralContext ctx) {
        NamedElement currentElement = (NamedElement)this.m_elementStack.peek();
        JavaMethod method = this.m_currentMethod;
        int oldNesting = this.m_currentNesting;
        int oldMaxNesting = this.m_maxNesting;
        if (currentElement instanceof JavaMethod) {
            this.m_currentMethod = (JavaMethod)currentElement;
            this.m_currentMethod.initMetrics();
            this.m_currentNesting = 0;
            this.m_maxNesting = 0;
            this.m_globalModel.addProcessor(new MethodProcessor(this.m_currentMethod, ctx.getStop().getLine()));
        } else {
            this.m_currentMethod = null;
        }
        this.visitChildren((RuleNode)ctx);
        if (this.m_currentMethod != null) {
            this.m_currentMethod.setMaxNesting(this.m_maxNesting);
        }
        this.m_currentMethod = method;
        this.m_currentNesting = oldNesting;
        this.m_maxNesting = oldMaxNesting;
        return null;
    }

    @Override
    public Void visitStatement(KotlinParser.StatementContext ctx) {
        this.visitChildren((RuleNode)ctx);
        if (this.m_currentMethod != null) {
            this.m_currentMethod.incrementNumberOfStatements();
        }
        return null;
    }

    @Override
    public Void visitControlStructureBody(KotlinParser.ControlStructureBodyContext ctx) {
        ++this.m_currentNesting;
        this.visitChildren((RuleNode)ctx);
        this.m_maxNesting = Integer.max(this.m_maxNesting, this.m_currentNesting);
        --this.m_currentNesting;
        return null;
    }

    @Override
    public Void visitCatchBlock(KotlinParser.CatchBlockContext ctx) {
        ++this.m_currentNesting;
        this.visitChildren((RuleNode)ctx);
        this.m_maxNesting = Integer.max(this.m_maxNesting, this.m_currentNesting);
        --this.m_currentNesting;
        return null;
    }

    @Override
    public Void visitFinallyBlock(KotlinParser.FinallyBlockContext ctx) {
        ++this.m_currentNesting;
        this.visitChildren((RuleNode)ctx);
        this.m_maxNesting = Integer.max(this.m_maxNesting, this.m_currentNesting);
        --this.m_currentNesting;
        return null;
    }

    @Override
    public Void visitLoopStatement(KotlinParser.LoopStatementContext ctx) {
        if (this.m_currentMethod != null) {
            this.m_currentMethod.incrementCyclomaticComplexity();
            this.m_currentMethod.incrementModifiedCyclomaticComplexity();
        }
        this.visitChildren((RuleNode)ctx);
        return null;
    }

    @Override
    public Void visitIfExpression(KotlinParser.IfExpressionContext ctx) {
        if (this.m_currentMethod != null) {
            this.m_currentMethod.incrementCyclomaticComplexity();
            this.m_currentMethod.incrementModifiedCyclomaticComplexity();
        }
        this.visitChildren((RuleNode)ctx);
        return null;
    }

    @Override
    public Void visitWhenExpression(KotlinParser.WhenExpressionContext ctx) {
        if (this.m_currentMethod != null) {
            this.m_currentMethod.incrementModifiedCyclomaticComplexity();
        }
        this.visitChildren((RuleNode)ctx);
        return null;
    }

    @Override
    public Void visitWhenEntry(KotlinParser.WhenEntryContext ctx) {
        if (this.m_currentMethod != null) {
            this.m_currentMethod.incrementCyclomaticComplexity();
        }
        this.visitChildren((RuleNode)ctx);
        return null;
    }

    @Override
    public Void visitDisjunction(KotlinParser.DisjunctionContext ctx) {
        if (this.m_currentMethod != null) {
            for (TerminalNode terminal : ctx.DISJ()) {
                this.m_currentMethod.incrementNumberOfLogicalOperations();
            }
        }
        this.visitChildren((RuleNode)ctx);
        return null;
    }

    @Override
    public Void visitConjunction(KotlinParser.ConjunctionContext ctx) {
        if (this.m_currentMethod != null) {
            for (TerminalNode terminal : ctx.CONJ()) {
                this.m_currentMethod.incrementNumberOfLogicalOperations();
            }
        }
        this.visitChildren((RuleNode)ctx);
        return null;
    }

    private Void handleLambdasAndAnonymousFunctions(ParserRuleContext ctx) {
        JavaMethod method;
        JavaType anonymousType = this.m_isScopeFunction ? null : this.getAnonymousType(this.getCurrentType(false), ctx);
        boolean foundMethod = false;
        if (anonymousType != null && (method = (JavaMethod)anonymousType.getChildren(JavaNonInitializer.class).stream().filter(m -> !m.hasFlag(JavaElementFlag.BRIDGE)).findFirst().orElse(null)) != null) {
            method.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            method.setLineNumber(ctx.start.getLine());
            this.m_elementStack.push(anonymousType);
            this.m_elementStack.push(method);
            this.visitChildren((RuleNode)ctx);
            this.m_elementStack.pop();
            this.m_elementStack.pop();
            foundMethod = true;
        }
        if (!foundMethod) {
            ++this.m_currentNesting;
            this.m_maxNesting = Integer.max(this.m_currentNesting, this.m_maxNesting);
            this.visitChildren((RuleNode)ctx);
            --this.m_currentNesting;
        }
        return null;
    }

    @Override
    public Void visitAnnotatedLambda(KotlinParser.AnnotatedLambdaContext ctx) {
        return this.handleLambdasAndAnonymousFunctions(ctx);
    }

    @Override
    public Void visitFunctionLiteral(KotlinParser.FunctionLiteralContext ctx) {
        return this.handleLambdasAndAnonymousFunctions(ctx);
    }

    private static /* synthetic */ boolean lambda$28(String string, JavaType t) {
        return t.getName().startsWith(string);
    }
}

