/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile;

import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.JavaPackageNameExtractor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.Lexer;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class JavaFilePackageNameExtractor
extends JavaPackageNameExtractor {
    private static final Lexer LEXER = new Lexer();

    private JavaFilePackageNameExtractor() {
    }

    private static String scanPackageName() throws IOException {
        StringBuffer result = new StringBuffer(80);
        int token = LEXER.nextToken();
        while (token != 122 && token != 0) {
            result.append(LEXER.getLexeme());
            token = LEXER.nextToken();
        }
        if (token == 122) {
            String packageName = result.toString();
            if (packageName.indexOf(36) != -1) {
                packageName = null;
            }
            return packageName;
        }
        return null;
    }

    public static String extractPackageName(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'extractPackageName' must not be null";
        assert (JavaFileType.determine(file.getName()) == JavaFileType.JAVA_FILE) : "Not a Java file: " + file.getAbsolutePath();
        String packageName = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream sourceFileStream = new BufferedInputStream((InputStream)new TFileInputStream((File)file));){
                LEXER.init();
                LEXER.assignInput(sourceFileStream, file.getAbsolutePath());
                do {
                    int token;
                    if ((token = LEXER.nextToken()) == 114) {
                        packageName = JavaFilePackageNameExtractor.scanPackageName();
                        break;
                    }
                    switch (token) {
                        case 0: 
                        case 41: 
                        case 43: 
                        case 112: 
                        case 113: 
                        case 120: {
                            packageName = "";
                        }
                    }
                } while (packageName == null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return packageName;
    }
}

