/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaTypeRegistry;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.JavaIssueId;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaInternalCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;

final class JavaTypeVisitor
extends NamedElementVisitor
implements JavaModule.IVisitor,
JavaSourceFile.IVisitor,
JavaType.IVisitor,
JavaMethod.IVisitor,
JavaField.IVisitor {
    private final JavaTypeRegistry m_typeRegistry;
    private JavaModule m_currentModule;
    private JavaType m_currentType;

    JavaTypeVisitor(JavaTypeRegistry typeRegistry) {
        assert (typeRegistry != null) : "Parameter 'typeRegistry' of method 'JavaTypeVisitor' must not be null";
        this.m_typeRegistry = typeRegistry;
    }

    @Override
    public void visitJavaModule(JavaModule element) {
        assert (element != null) : "Parameter 'element' of method 'visitJavaModule' must not be null";
        this.m_currentModule = element;
        this.visitChildrenOf((NamedElement)element);
        this.m_currentModule = null;
    }

    @Override
    public void visitJavaSourceFile(JavaSourceFile element) {
        assert (element != null) : "Parameter 'element' of method 'visitJavaSourceFile' must not be null";
        if (this.m_currentModule != null && element.hasIssues(new IIssueId[0])) {
            this.m_typeRegistry.addFileToReparse(this.m_currentModule, element);
        }
    }

    @Override
    public void visitJavaType(JavaType element) {
        assert (element != null) : "Parameter 'element' of method 'visitJavaType' must not be null";
        JavaType lastType = this.m_currentType;
        this.m_currentType = element;
        this.m_typeRegistry.addType(this.m_currentModule, element);
        if (this.m_currentModule != null) {
            JavaInternalCompilationUnit compilationUnit;
            if (element.hasIssues(new IIssueId[]{JavaIssueId.UNRESOLVED_AMBIGUOUS_TARGET_TYPE})) {
                JavaClassFile nextClassFile = (JavaClassFile)((Object)this.m_currentType.getFirstChild(JavaClassFile.class));
                assert (nextClassFile != null) : "'nextClassFile' of method 'visitJavaType' must not be null";
                this.m_typeRegistry.addFileToReparse(this.m_currentModule, nextClassFile);
            }
            if (element.hasIssues(new IIssueId[]{JavaIssueId.GROOVY_FILE_CORRESPONDING_CLASS_FILE_MISSING, JavaIssueId.ASPECTJ_FILE_CORRESPONDING_CLASS_FILE_MISSING, JavaIssueId.SCALA_FILE_CORRESPONDING_CLASS_FILE_MISSING}) && (compilationUnit = (JavaInternalCompilationUnit)((Object)element.getParent(JavaInternalCompilationUnit.class, new Class[0]))) != null) {
                for (JavaFile nextFile : compilationUnit.getChildrenRecursively(JavaFile.class, new Class[0])) {
                    this.m_typeRegistry.addFileToReparse(this.m_currentModule, nextFile);
                }
            }
        }
        this.visitChildrenOf((NamedElement)element);
        this.m_currentType = lastType;
    }

    @Override
    public void visitJavaMethod(JavaMethod element) {
        assert (element != null) : "Parameter 'element' of method 'visitJavaMethod' must not be null";
        if (this.m_currentModule != null && element.hasIssues(new IIssueId[]{JavaIssueId.UNRESOLVED_AMBIGUOUS_TARGET_TYPE})) {
            assert (this.m_currentType != null) : "'m_currentType' of method 'visitJavaMethod' must not be null";
            JavaClassFile nextClassFile = (JavaClassFile)((Object)this.m_currentType.getFirstChild(JavaClassFile.class));
            assert (nextClassFile != null) : "'nextClassFile' of method 'visitJavaMethod' must not be null";
            this.m_typeRegistry.addFileToReparse(this.m_currentModule, nextClassFile);
        }
        this.visitChildrenOf((NamedElement)element);
    }

    @Override
    public void visitJavaField(JavaField element) {
        assert (element != null) : "Parameter 'element' of method 'visitJavaField' must not be null";
        if (this.m_currentModule != null) {
            if (element.hasFlag(JavaElementFlag.INLINEABLE)) {
                this.m_typeRegistry.addPotentialInlineField(element);
            }
            if (element.hasIssues(new IIssueId[]{JavaIssueId.UNRESOLVED_AMBIGUOUS_TARGET_TYPE})) {
                assert (this.m_currentType != null) : "'m_currentType' of method 'visitJavaField' must not be null";
                JavaClassFile nextClassFile = (JavaClassFile)((Object)this.m_currentType.getFirstChild(JavaClassFile.class));
                assert (nextClassFile != null) : "'nextClassFile' of method 'visitJavaField' must not be null";
                this.m_typeRegistry.addFileToReparse(this.m_currentModule, nextClassFile);
            }
        }
        this.visitChildrenOf((NamedElement)element);
    }
}

