/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaGlobalModelHelper;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaModelProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaTypeRegistry;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaElementAccessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaGlobalModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.JavaTypeInfo;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaNameUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.IJavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.IJavaMember;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaConstructor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaExternalCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMember;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaStaticBlock;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ExternalTypeProcessor
extends JavaModelProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalTypeProcessor.class);
    private final IJavaGlobalModel m_globalModel;
    private final JavaTypeRegistry m_registry;

    ExternalTypeProcessor(IJavaElementAccessor elementAccessor, JavaGlobalModelHelper helper, IWorkerContext workerContext, IJavaGlobalModel globalModel, JavaTypeRegistry registry) {
        super(elementAccessor, helper, workerContext);
        assert (globalModel != null) : "Parameter 'globalModel' of method 'ExternalTypeProcessor' must not be null";
        assert (registry != null) : "Parameter 'registry' of method 'ExternalTypeProcessor' must not be null";
        this.m_globalModel = globalModel;
        this.m_registry = registry;
    }

    private void addTypeToExternalCompilationUnit(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'assignTypeToExternalCompilationUnit' must not be null";
        NamedElement parentOfExternalClassFile = null;
        Object relPath = "./";
        String packageName = JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(type.getFqName());
        if (packageName.length() > 0) {
            parentOfExternalClassFile = NamespaceFragment.getNamespaceFragmentOrSpecifiedParent((IModelServiceProvider)this.m_globalModel.getModelServiceProvider(), (NamedElement)this.m_globalModel.getUnknownJar(), (String)packageName, (NamespaceFragment.INamespaceFragmentCreator)this.m_globalModel.getNamespaceFragmentCreator());
            relPath = (String)relPath + parentOfExternalClassFile.getName().replace('.', '/') + "/";
        } else {
            parentOfExternalClassFile = this.m_globalModel.getUnknownJar();
        }
        String sourceName = JavaNameUtility.getMainTypeName(type.getFqName());
        relPath = (String)relPath + sourceName;
        List javaFiles = parentOfExternalClassFile.getChildren((NamedElement.IFilter)new ShortNameFilter(sourceName), JavaExternalCompilationUnit.class);
        JavaExternalCompilationUnit javaExternalCompilationUnit = null;
        if (javaFiles.size() > 0) {
            assert (javaFiles.size() == 1) : "More than one java file found";
            javaExternalCompilationUnit = (JavaExternalCompilationUnit)((Object)javaFiles.get(0));
        } else {
            javaExternalCompilationUnit = new JavaExternalCompilationUnit(this.m_globalModel.getModelServiceProvider(), parentOfExternalClassFile, (String)relPath);
            parentOfExternalClassFile.addChild((NamedElement)javaExternalCompilationUnit);
        }
        NamedElement currentParent = type.getParent();
        if (currentParent != javaExternalCompilationUnit) {
            if (currentParent != null) {
                currentParent.removeChild((NamedElement)type);
            }
            type.setParent((NamedElement)javaExternalCompilationUnit);
            javaExternalCompilationUnit.addChild((NamedElement)type);
        }
    }

    boolean isExternalWithoutChildrenAndIncomingDependencies(IJavaElement element) {
        assert (element != null) : "Parameter 'element' of method 'deleteExternalType' must not be null";
        if (!element.hasFlag(JavaElementFlag.EXTERNAL)) {
            return false;
        }
        if (element.hasChildren(false, JavaType.class)) {
            return false;
        }
        if (element.hasIncomingDependencies()) {
            for (ParserDependency nextIncomingDependency : element.getIncomingDependencies(new IStandardEnumeration[0])) {
                if (nextIncomingDependency.getOriginalFrom() == element) continue;
                boolean dependencyFromOuterClassOrMember = false;
                ArrayList<IJavaElement> outerTypesAndDirectMembers = new ArrayList<IJavaElement>();
                for (JavaType nextOuterType : element.getParents(JavaType.class, new Class[0])) {
                    if (!nextOuterType.hasFlag(JavaElementFlag.EXTERNAL)) continue;
                    outerTypesAndDirectMembers.add(nextOuterType);
                    for (IJavaMember nextJavaMember : nextOuterType.getChildren(IJavaMember.class)) {
                        outerTypesAndDirectMembers.add(nextJavaMember);
                    }
                }
                for (IJavaMember nextMember : element.getChildren(IJavaMember.class)) {
                    assert (nextMember.hasFlag(JavaElementFlag.EXTERNAL)) : "Not external: " + String.valueOf(nextMember);
                    outerTypesAndDirectMembers.add(nextMember);
                }
                for (IJavaElement nextPotentialFromType : outerTypesAndDirectMembers) {
                    if (nextPotentialFromType != nextIncomingDependency.getOriginalFrom()) continue;
                    dependencyFromOuterClassOrMember = true;
                    break;
                }
                if (dependencyFromOuterClassOrMember) continue;
                return false;
            }
        }
        return true;
    }

    private boolean deleteExternalTypeIfPossible(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'deleteExternalTypeIfPossible' must not be null";
        assert (type.hasFlag(JavaElementFlag.EXTERNAL)) : "Not an external type: " + String.valueOf(type);
        LOGGER.debug("Check if external type '" + type.getFqName() + "' can be deleted");
        boolean allMembersDeleted = true;
        for (IJavaMember nextMember : type.getChildren(IJavaMember.class)) {
            if (!this.isExternalWithoutChildrenAndIncomingDependencies(nextMember)) {
                allMembersDeleted = false;
                continue;
            }
            nextMember.remove();
        }
        boolean delete = false;
        if (allMembersDeleted && this.isExternalWithoutChildrenAndIncomingDependencies(type)) {
            this.m_registry.removeType(type);
            type.remove();
            delete = true;
        }
        LOGGER.debug("Check if external type '" + type.getFqName() + "' can be deleted - done " + (delete ? "=> delete" : "=> do not delete"));
        return delete;
    }

    private JavaMember matchMember(JavaMember toMatch, List<JavaMember> in) {
        assert (toMatch != null) : "Parameter 'toMatch' of method 'matchMember' must not be null";
        assert (in != null) : "Parameter 'in' of method 'matchMember' must not be null";
        String toMatchShortName = toMatch.getShortName();
        Iterator<JavaMember> iterator = in.iterator();
        while (iterator.hasNext()) {
            JavaMember nextToMatch = iterator.next();
            if (!nextToMatch.getClass().equals(toMatch.getClass()) || !nextToMatch.getShortName().equals(toMatchShortName)) continue;
            if (nextToMatch instanceof JavaMethod) {
                if (!((JavaMethod)toMatch).getDescriptor().equals(((JavaMethod)nextToMatch).getDescriptor())) continue;
                iterator.remove();
                return nextToMatch;
            }
            assert (nextToMatch instanceof JavaField) : "Unexpected class: " + String.valueOf(nextToMatch.getClass());
            iterator.remove();
            return nextToMatch;
        }
        return null;
    }

    void transferIncomingDependenciesOfExternalTypeToInternalTypes(JavaType externalType, List<JavaTypeInfo> internalTypes) {
        assert (externalType != null) : "Parameter 'externalType' of method 'transferIncomingDependenciesOfExternalTypeToInternalTypes' must not be null";
        assert (externalType.isExternal()) : "Not external: " + String.valueOf(externalType);
        assert (internalTypes != null && !internalTypes.isEmpty()) : "Parameter 'internalTypes' of method 'transferIncomingDependenciesOfExternalTypeToInternalTypes' must not be empty";
        if (internalTypes.size() > 1) {
            JavaType transferToInternalType = null;
            String toFqName = externalType.getName();
            for (ParserDependency nextIncomingDependency : externalType.getIncomingDependencies(new IStandardEnumeration[0])) {
                JavaType nextTransferToInternalType;
                assert (nextIncomingDependency instanceof JavaDependency) : "Unexpected class in method 'transferIncomingDependenciesOfExternalTypeToExistingInternalType': " + String.valueOf(nextIncomingDependency);
                JavaDependency nextIncomingJavaDependency = (JavaDependency)nextIncomingDependency;
                ProgrammingElement nextFrom = nextIncomingJavaDependency.getOriginalFrom();
                if (nextFrom.isExternal() || (nextTransferToInternalType = DependencyProcessor.getAmbiguousToType(this.getElementAccessor(), internalTypes, (JavaModule)((Object)nextFrom.getParent(JavaModule.class, new Class[0])), (JavaElement)nextFrom, toFqName, nextIncomingJavaDependency.getLineNumber())) == null) continue;
                if (transferToInternalType == null) {
                    transferToInternalType = nextTransferToInternalType;
                } else assert (transferToInternalType == nextTransferToInternalType) : "Different 'transferToInternalType'/'nextTransferToInternalType': " + String.valueOf(transferToInternalType) + "/" + String.valueOf(nextTransferToInternalType);
                DependencyProcessor.addDependency((JavaElement)nextFrom, nextTransferToInternalType, nextIncomingJavaDependency.getLineNumber(), nextIncomingJavaDependency.getDependencyContext(), (JavaDependencyType)nextIncomingJavaDependency.getDependencyType());
            }
            transferToInternalType = null;
            for (JavaMember nextExternalMember : externalType.getChildren(JavaMember.class)) {
                for (ParserDependency nextIncomingDependency : nextExternalMember.getIncomingDependencies(new IStandardEnumeration[0])) {
                    JavaType nextTransferToInternalType;
                    assert (nextIncomingDependency instanceof JavaDependency) : "Unexpected class in method 'transferIncomingDependenciesOfExternalTypeToExistingInternalType': " + String.valueOf(nextIncomingDependency);
                    JavaDependency nextIncomingJavaDependency = (JavaDependency)nextIncomingDependency;
                    ProgrammingElement nextFrom = nextIncomingJavaDependency.getOriginalFrom();
                    if (nextFrom.isExternal() || (nextTransferToInternalType = DependencyProcessor.getAmbiguousToType(this.getElementAccessor(), internalTypes, (JavaModule)((Object)nextFrom.getParent(JavaModule.class, new Class[0])), (JavaElement)nextFrom, toFqName, nextIncomingJavaDependency.getLineNumber())) == null) continue;
                    if (transferToInternalType == null) {
                        transferToInternalType = nextTransferToInternalType;
                        continue;
                    }
                    assert (transferToInternalType == nextTransferToInternalType) : "Different 'transferToInternalType'/'nextTransferToInternalType': " + String.valueOf(transferToInternalType) + "/" + String.valueOf(nextTransferToInternalType);
                    List internalMembers = nextTransferToInternalType.getChildren(JavaMember.class);
                    JavaMember nextMatchingInternalMember = this.matchMember(nextExternalMember, internalMembers);
                    if (nextMatchingInternalMember == null) continue;
                    DependencyProcessor.addDependency((JavaElement)nextFrom, nextMatchingInternalMember, nextIncomingJavaDependency.getLineNumber(), nextIncomingJavaDependency.getDependencyContext(), (JavaDependencyType)nextIncomingJavaDependency.getDependencyType());
                }
            }
        } else {
            JavaType transferToInternalType = internalTypes.get(0).getType();
            assert (externalType != transferToInternalType) : "External/internal refer to same instance: " + String.valueOf(externalType);
            assert (!transferToInternalType.isExternal()) : "Not internal: " + String.valueOf(transferToInternalType);
            for (ParserDependency nextIncomingDependency : externalType.getIncomingDependencies(new IStandardEnumeration[0])) {
                assert (nextIncomingDependency instanceof JavaDependency) : "Unexpected class in method 'transferIncomingDependenciesOfExternalTypeToExistingInternalType': " + String.valueOf(nextIncomingDependency);
                JavaDependency nextIncomingJavaDependency = (JavaDependency)nextIncomingDependency;
                ProgrammingElement nextFrom = nextIncomingJavaDependency.getOriginalFrom();
                if (nextFrom.isExternal()) continue;
                DependencyProcessor.addDependency((JavaElement)nextFrom, transferToInternalType, nextIncomingJavaDependency.getLineNumber(), nextIncomingJavaDependency.getDependencyContext(), (JavaDependencyType)nextIncomingJavaDependency.getDependencyType());
            }
            List internalMembers = transferToInternalType.getChildren(JavaMember.class);
            for (Object nextExternalMember : externalType.getChildren(JavaMember.class)) {
                JavaMember nextMatchingInternalMember = this.matchMember((JavaMember)nextExternalMember, internalMembers);
                if (nextMatchingInternalMember == null) continue;
                for (ParserDependency nextIncomingDependency : nextExternalMember.getIncomingDependencies(new IStandardEnumeration[0])) {
                    assert (nextIncomingDependency instanceof JavaDependency) : "Unexpected class in method 'transferIncomingDependenciesOfExternalTypeToExistingInternalType': " + String.valueOf(nextIncomingDependency);
                    JavaDependency nextIncomingJavaDependency = (JavaDependency)nextIncomingDependency;
                    ProgrammingElement nextFrom = nextIncomingJavaDependency.getOriginalFrom();
                    if (nextFrom.isExternal()) continue;
                    DependencyProcessor.addDependency((JavaElement)nextFrom, nextMatchingInternalMember, nextIncomingJavaDependency.getLineNumber(), nextIncomingJavaDependency.getDependencyContext(), (JavaDependencyType)nextIncomingJavaDependency.getDependencyType());
                }
            }
        }
    }

    private String getMethodName(JavaMethod method) {
        assert (method != null) : "Parameter 'method' of method 'getMethodName' must not be null";
        if (method instanceof JavaConstructor) {
            return "<init>";
        }
        if (method instanceof JavaStaticBlock) {
            return "<clinit>";
        }
        return method.getShortName();
    }

    private void transferIncomingDependencies(JavaType fromExternalType, JavaType toExternalType) {
        assert (fromExternalType != null) : "Parameter 'fromExternalType' of method 'transferIncomingDependencies' must not be null";
        assert (toExternalType != null) : "Parameter 'toExternalType' of method 'transferIncomingDependencies' must not be null";
        assert (fromExternalType != toExternalType) : "Sames instances";
        assert (fromExternalType.isExternal()) : "Not external: " + String.valueOf(fromExternalType);
        assert (toExternalType.isExternal()) : "Not external: " + String.valueOf(toExternalType);
        LOGGER.debug("Merge external type");
        for (ParserDependency nextIncomingDependency : fromExternalType.getIncomingDependencies(new IStandardEnumeration[0])) {
            assert (nextIncomingDependency != null && nextIncomingDependency instanceof JavaDependency) : "Unexpected class in method 'transferIncomingDependencies': " + String.valueOf(nextIncomingDependency);
            JavaDependency nextIncomingJavaDependency = (JavaDependency)nextIncomingDependency;
            ProgrammingElement nextFrom = nextIncomingJavaDependency.getOriginalFrom();
            if (nextFrom.isExternal()) continue;
            DependencyProcessor.addDependency((JavaElement)nextFrom, toExternalType, nextIncomingJavaDependency.getLineNumber(), nextIncomingJavaDependency.getDependencyContext(), (JavaDependencyType)nextIncomingJavaDependency.getDependencyType());
        }
        for (JavaMember nextExternalMember : fromExternalType.getChildren(JavaMember.class)) {
            for (ParserDependency nextIncomingDependency : nextExternalMember.getIncomingDependencies(new IStandardEnumeration[0])) {
                JavaMember toElement;
                assert (nextIncomingDependency instanceof JavaDependency) : "Unexpected class in method 'transferIncomingDependencies': " + String.valueOf(nextIncomingDependency);
                JavaDependency nextIncomingJavaDependency = (JavaDependency)nextIncomingDependency;
                ProgrammingElement nextFrom = nextIncomingJavaDependency.getOriginalFrom();
                if (nextFrom.isExternal()) continue;
                if (nextExternalMember instanceof JavaField) {
                    toElement = this.getElementAccessor().getField(toExternalType, nextExternalMember.getShortName());
                } else {
                    assert (nextExternalMember instanceof JavaMethod) : "Unexpected class in method 'transferIncomingDependencies': " + String.valueOf(nextExternalMember);
                    toElement = this.getElementAccessor().getMethod(toExternalType, this.getMethodName((JavaMethod)nextExternalMember), ((JavaMethod)nextExternalMember).getDescriptor(), false, null);
                }
                toElement.removeFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE);
                DependencyProcessor.addDependency((JavaElement)nextFrom, toElement, nextIncomingJavaDependency.getLineNumber(), nextIncomingJavaDependency.getDependencyContext(), (JavaDependencyType)nextIncomingJavaDependency.getDependencyType());
            }
        }
        LOGGER.debug("Merge external type - done");
    }

    private void mergeExternalTypesWithMatchingFqNames(List<JavaType> externalTypes) {
        assert (externalTypes != null && !externalTypes.isEmpty()) : "Parameter 'externalTypes' of method 'mergeExternalTypesWithMatchingFqNames' must not be empty";
        LOGGER.debug("Merge external types with matching fq names");
        THashMap fqNameToExternalType = new THashMap();
        Iterator<JavaType> iter = externalTypes.iterator();
        while (iter.hasNext()) {
            JavaType nextExternalType = iter.next();
            String nextFqName = nextExternalType.getFqName();
            LOGGER.debug("Process external type: " + nextFqName);
            this.m_registry.removeType(nextExternalType);
            JavaType nextAlreadyAdded = (JavaType)fqNameToExternalType.get(nextFqName);
            if (nextAlreadyAdded == null) {
                fqNameToExternalType.put(nextFqName, nextExternalType);
                this.m_registry.addType(null, nextExternalType);
            } else {
                this.transferIncomingDependencies(nextExternalType, nextAlreadyAdded);
                nextExternalType.remove();
                iter.remove();
            }
            LOGGER.debug("Process external type '" + nextFqName + "' - done");
        }
        LOGGER.debug("Merge external types with matching fq names - done");
    }

    void processModifiedTypes(List<JavaType> externalTypes) {
        assert (externalTypes != null) : "Parameter 'externalTypes' of method 'processModifiedTypes' must not be null";
        if (!externalTypes.isEmpty()) {
            this.getWorkerContext().working("Finish modified external types", false);
            LOGGER.debug("Finish modified external types");
            this.mergeExternalTypesWithMatchingFqNames(externalTypes);
            Collections.sort(externalTypes, JavaModelProcessor.DEEPER_FIRST);
            for (JavaType nextExternalType : externalTypes) {
                if (this.getWorkerContext().hasBeenCanceled()) break;
                String nextFqName = nextExternalType.getFqName();
                LOGGER.debug("Process external type: " + nextFqName);
                List<JavaTypeInfo> nextTypeInfos = this.m_registry.getTypes(nextFqName);
                if (nextTypeInfos.size() == 1) {
                    boolean addToExternalCompilationUnit;
                    assert (nextTypeInfos.get(0).getType() == nextExternalType) : "External type expected: " + String.valueOf(nextTypeInfos.get(0).getType());
                    if (this.deleteExternalTypeIfPossible(nextExternalType)) continue;
                    NamedElement currentParentOfNextExternalType = nextExternalType.getParent();
                    boolean bl = addToExternalCompilationUnit = !(currentParentOfNextExternalType instanceof JavaExternalCompilationUnit);
                    if (!(currentParentOfNextExternalType instanceof JavaType)) {
                        String nextExternalParentFqTypeName;
                        JavaType nextCandidateExternalParentType;
                        String nextExternalFqTypeName = nextFqName;
                        if (JavaNameUtility.isPotentialNestedType(nextExternalFqTypeName) && (nextCandidateExternalParentType = this.m_globalModel.getType(null, nextExternalParentFqTypeName = JavaNameUtility.getNameOfEnclosingTypeOfPotentialNestedType(nextExternalFqTypeName))) != null) {
                            NamedElement currentParent = nextExternalType.getParent();
                            if (currentParent != null) {
                                currentParent.removeChild((NamedElement)nextExternalType);
                            }
                            nextExternalType.setParent((NamedElement)nextCandidateExternalParentType);
                            nextCandidateExternalParentType.addChild((NamedElement)nextExternalType);
                            addToExternalCompilationUnit = false;
                            nextExternalType.addFlag(JavaElementFlag.NESTED);
                        }
                    } else {
                        addToExternalCompilationUnit = false;
                    }
                    if (addToExternalCompilationUnit) {
                        this.addTypeToExternalCompilationUnit(nextExternalType);
                    }
                    if (nextExternalType.hasFlag(JavaElementFlag.ANNOTATION)) {
                        nextExternalType.removeFlag(JavaElementFlag.CLASS);
                    } else {
                        Iterator iterator = nextExternalType.getDependencyIterator();
                        while (iterator.hasNext()) {
                            ParserDependency nextDependency = (ParserDependency)iterator.next();
                            IParserDependencyType nextDependencyType = nextDependency.getDependencyType();
                            if (nextDependency.getOriginalTo() != nextExternalType) continue;
                            if (nextDependencyType == JavaDependencyType.EXTENDS) {
                                JavaType from = (JavaType)nextDependency.getOriginalFrom();
                                if (!from.hasFlag(JavaElementFlag.INTERFACE) && !from.hasFlag(JavaElementFlag.ANNOTATION)) break;
                                nextExternalType.addFlag(JavaElementFlag.INTERFACE);
                                nextExternalType.addFlag(JavaElementFlag.ABSTRACT);
                                nextExternalType.removeFlag(JavaElementFlag.CLASS);
                                break;
                            }
                            if (nextDependencyType != JavaDependencyType.IMPLEMENTS) continue;
                            nextExternalType.addFlag(JavaElementFlag.INTERFACE);
                            nextExternalType.addFlag(JavaElementFlag.ABSTRACT);
                            nextExternalType.removeFlag(JavaElementFlag.CLASS);
                            break;
                        }
                    }
                    for (JavaMember next : nextExternalType.getChildren(JavaMember.class)) {
                        next.removeFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE);
                    }
                    continue;
                }
                LOGGER.debug("External type needs conversion '" + nextFqName + "'");
                ArrayList<JavaTypeInfo> toInternalTypes = new ArrayList<JavaTypeInfo>(nextTypeInfos.size() - 1);
                boolean nextExternalTypeFound = false;
                for (JavaTypeInfo nextTypeInfo : nextTypeInfos) {
                    LOGGER.debug("Available type info: " + String.valueOf(nextTypeInfo));
                    if (nextTypeInfo.getType() != nextExternalType) {
                        toInternalTypes.add(nextTypeInfo);
                        continue;
                    }
                    assert (!nextExternalTypeFound) : "External type already found in type info";
                    nextExternalTypeFound = true;
                }
                assert (nextExternalTypeFound) : "External type not found in type info: " + nextFqName;
                this.transferIncomingDependenciesOfExternalTypeToInternalTypes(nextExternalType, toInternalTypes);
                this.m_registry.removeType(nextExternalType);
                nextExternalType.remove();
            }
            LOGGER.debug("Finish modified external types - done");
        }
    }
}

