/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaGlobalModelHelper;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaModelProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaElementAccessor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.CastInfo;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class CastInfoProcessor
extends JavaModelProcessor {
    private final Map<JavaElement, Set<CastInfo>> m_elementToCastInfo = new THashMap();

    CastInfoProcessor(IJavaElementAccessor elementAccessor, JavaGlobalModelHelper globalModelHelper, IWorkerContext workerContext) {
        super(elementAccessor, globalModelHelper, workerContext);
    }

    void addCastInfo(JavaElement element, CastInfo castInfo) {
        assert (element != null) : "Parameter 'fromElement' of method 'addCast' must not be null";
        assert (castInfo != null) : "Parameter 'castInfo' of method 'addCast' must not be null";
        THashSet castInfos = this.m_elementToCastInfo.get(element);
        if (castInfos == null) {
            castInfos = new THashSet(2);
            this.m_elementToCastInfo.put(element, (Set<CastInfo>)castInfos);
        }
        castInfos.add((CastInfo)castInfo);
    }

    void transferInfo(JavaElement from, JavaElement to) {
        assert (from != null) : "Parameter 'from' of method 'transferInfo' must not be null";
        assert (to != null) : "Parameter 'to' of method 'transferInfo' must not be null";
        assert (from != to) : "Same instances: " + String.valueOf(from);
        Set<CastInfo> infoToTransfer = this.m_elementToCastInfo.get(from);
        if (infoToTransfer != null) {
            Set<CastInfo> existingInfo = this.m_elementToCastInfo.get(to);
            if (existingInfo == null) {
                this.m_elementToCastInfo.put(to, infoToTransfer);
            } else {
                existingInfo.addAll(infoToTransfer);
            }
        }
    }

    void clear(JavaElement element) {
        assert (element != null) : "Parameter 'element' of method 'clear' must not be null";
        this.m_elementToCastInfo.remove(element);
    }

    void process() {
        if (!this.m_elementToCastInfo.isEmpty()) {
            IWorkerContext workerContext = this.getWorkerContext();
            for (Map.Entry<JavaElement, Set<CastInfo>> nextEntry : this.m_elementToCastInfo.entrySet()) {
                if (workerContext.hasBeenCanceled()) break;
                JavaElement nextFromElement = nextEntry.getKey();
                for (CastInfo nextCastInfo : nextEntry.getValue()) {
                    ParserDependency convertToCastDependency = null;
                    ProgrammingElement determinedToElement = null;
                    Iterator nextIterator = nextFromElement.getDependencyIterator();
                    while (nextIterator.hasNext()) {
                        JavaType determinedToType;
                        ParserDependency nextParserDependency = (ParserDependency)nextIterator.next();
                        if (nextParserDependency.getOriginalFrom() != nextFromElement || nextParserDependency.getDependencyType() != JavaDependencyType.USES || nextParserDependency.getLineNumber() != nextCastInfo.getLine() || !((determinedToElement = nextParserDependency.getOriginalTo()) instanceof JavaType) || !(determinedToType = (JavaType)determinedToElement).getShortName().equals(nextCastInfo.getTypeName()) && !determinedToType.getFqName().equals(nextCastInfo.getTypeName())) continue;
                        convertToCastDependency = nextParserDependency;
                        break;
                    }
                    if (convertToCastDependency == null) continue;
                    assert (determinedToElement != null && determinedToElement instanceof JavaElement) : "Unexpected class in method 'process': " + String.valueOf(determinedToElement);
                    this.getModelHelper().addDependency(nextFromElement, (JavaElement)determinedToElement, nextCastInfo.getLine(), null, JavaDependencyType.CAST);
                    nextFromElement.removeDependency(convertToCastDependency);
                }
            }
        }
    }
}

