/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.java.command.system.JavaCommandId;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture.SpringModulithExtension;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;

public final class CreateSpringModulithArchitectureCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public CreateSpringModulithArchitectureCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, (ICommandInteraction)interaction);
    }

    public ICommandId getId() {
        return JavaCommandId.CREATE_MODULITH_ARCHITECTURE;
    }

    protected void internalRun(IWorkerContext workerContext) {
        CommandData data = new CommandData();
        if (!((IInteraction)this.getInteraction()).collectData(data)) {
            return;
        }
        Architecture architectureNode = ((Files)this.getSoftwareSystem().getUniqueExistingChild(Files.class)).getArchitecture();
        TFile archDir = architectureNode.getDirectoryFile();
        TFile targetFile = new TFile((File)archDir, data.getArchitectureFileName() + CoreFileType.ARCHITECTURE.getDefaultExtension());
        if (targetFile.exists() && !((IInteraction)this.getInteraction()).overwriteFile()) {
            return;
        }
        SpringModulithExtension extension = (SpringModulithExtension)this.getSoftwareSystem().getExtension(SpringModulithExtension.class);
        OperationResultWithOutcome<ArchitectureFile> result = extension.generateSpringModulithArchitecture(workerContext, data.getSelectedFile(), data.getArchitectureFileName(), data.isAddLayers(), targetFile, data.isAddToArchitectureCheck());
        ((IInteraction)this.getInteraction()).processResult((OperationResult)result);
    }

    public static class CommandData {
        private TFile m_selectedFile;
        private String m_architectureFileName;
        private boolean m_addLayers = false;
        private boolean m_addToArchitectureCheck = false;

        public TFile getSelectedFile() {
            return this.m_selectedFile;
        }

        public void setSelectedFile(TFile selectedFile) {
            this.m_selectedFile = selectedFile;
        }

        public String getArchitectureFileName() {
            return this.m_architectureFileName;
        }

        public void setArchitectureFileName(String architectureFileName) {
            this.m_architectureFileName = architectureFileName;
        }

        public boolean isAddLayers() {
            return this.m_addLayers;
        }

        public void setAddLayers(boolean addLayers) {
            this.m_addLayers = addLayers;
        }

        public boolean isAddToArchitectureCheck() {
            return this.m_addToArchitectureCheck;
        }

        public void setAddToArchitectureCheck(boolean addToArchitectureCheck) {
            this.m_addToArchitectureCheck = addToArchitectureCheck;
        }
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collectData(CommandData var1);

        public void processResult(OperationResult var1);

        public boolean overwriteFile();
    }
}

