/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import java.net.MalformedURLException;
import java.net.URL;

public final class URLUtility {
    private URLUtility() {
    }

    public static boolean containsPortNumber(String urlString) {
        assert (urlString != null) : "Parameter 'urlString' of method 'containsPortNumber' must not be null";
        try {
            URL url = new URL(urlString);
            return url.getPort() != -1;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static URL removeDefaultPort(URL url) {
        assert (url != null) : "Parameter 'url' of method 'removeDefaultPort' must not be null";
        if (url.getPort() == url.getDefaultPort()) {
            try {
                return new URL(url.getProtocol(), url.getHost(), -1, url.getFile());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static URL toURL(String urlString, int port) throws MalformedURLException {
        assert (urlString != null) : "Parameter 'urlString' of method 'toURL' must not be null";
        URL url = new URL(urlString);
        URL result = new URL(url.getProtocol(), url.getHost(), port, url.getFile());
        return URLUtility.removeDefaultPort(result);
    }

    public static URL appendPath(URL url, String path) throws MalformedURLException {
        assert (url != null) : "Parameter 'url' of method 'appendPath' must not be null";
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'appendPath' must not be empty";
        String query = url.getQuery();
        Object queryString = "";
        if (query != null) {
            queryString = "?" + (String)queryString;
        }
        return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath() + "/" + path + (String)queryString);
    }

    public static URL addTimeParameter(URL url, String timeValue) throws MalformedURLException {
        assert (url != null) : "Parameter 'url' of method 'addTimeParameter' must not be null";
        assert (timeValue != null && timeValue.length() > 0) : "Parameter 'timeValue' of method 'addTimeParameter' must not be empty";
        String timeParameter = "time=" + timeValue;
        String query = url.getQuery();
        String separator = "?";
        if (query != null && query.length() > 0) {
            separator = "&";
        }
        return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + separator + timeParameter);
    }

    public static URL addTimeParameter(URL url) throws MalformedURLException {
        assert (url != null) : "Parameter 'url' of method 'addTimeParameter' must not be null";
        String timeValue = "" + System.currentTimeMillis();
        return URLUtility.addTimeParameter(url, timeValue);
    }
}

