/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public final class StringUtility {
    public static final char DEFAULT_LINE_SEPARATOR_CHAR = '\n';
    public static final char NON_BREAKABLE_SPACE = '\u00a0';
    public static final String DEFAULT_LINE_SEPARATOR = Character.toString('\n');
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String EMPTY_STRING = "";
    public static final String TAB_STRING = "\t";
    public static final String EQUALS = "=";
    public static final String NOT_AVAILABLE = "n/a";
    public static final String BLANK = " ";
    public static final String CRLF_LINE_BREAK = "\r\n";
    public static final String LF_LINE_BREAK = "\n";
    public static final String CR_LINE_BREAK = "\r";

    private StringUtility() {
    }

    public static boolean isWhitespace(char c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == '\ufeff';
    }

    public static boolean isWhitespace(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279;
    }

    public static String capitalize(String text) {
        assert (text != null) : "Parameter 'text' of method 'capitalize' must not be null";
        if (text.length() > 0) {
            return Character.toUpperCase(text.charAt(0)) + text.substring(1);
        }
        return text;
    }

    public static String pluralize(String s, int count) {
        assert (s != null) : "Parameter 's' of method 'pluralize' must not be null";
        return String.format("%s%s", s, count == 1 ? EMPTY_STRING : "s");
    }

    public static String firstCharacterCase(String input, boolean lower) {
        assert (input != null) : "Parameter 'input' of method 'firstCharacterLowerCase' must not be null";
        if (input.isEmpty()) {
            return input;
        }
        if (input.length() == 1) {
            return lower ? input.toLowerCase() : input.toUpperCase();
        }
        return (lower ? Character.toLowerCase(input.charAt(0)) : Character.toUpperCase(input.charAt(0))) + input.substring(1);
    }

    public static String toLowerCase(String input, boolean firstLower) {
        assert (input != null) : "Parameter 'input' of method 'firstCharacterLowerCase' must not be null";
        if (input.isEmpty()) {
            return input;
        }
        if (input.length() == 1) {
            return firstLower ? input.toLowerCase() : input.toUpperCase();
        }
        input = input.toLowerCase();
        return firstLower ? input : Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }

    public static int countString(String string, String inString) {
        assert (string != null) : "Parameter 'string' of method 'countString' must not be null";
        assert (inString != null) : "Parameter 'inString' of method 'countString' must not be null";
        int count = 0;
        int lastIndex = 0;
        while ((lastIndex = inString.indexOf(string, lastIndex)) != -1) {
            lastIndex += string.length();
            ++count;
        }
        return count;
    }

    public static int countChar(char count, String inString) {
        assert (inString != null) : "Parameter 'inString' of method 'countChar' must not be null";
        int fromIndex = -1;
        int occurrences = 0;
        while ((fromIndex = inString.indexOf(count, fromIndex + 1)) != -1) {
            ++occurrences;
        }
        return occurrences;
    }

    public static String concat(Collection<String> strings, String delimiter) {
        assert (strings != null) : "Parameter 'strings' of method 'concat' must not be null";
        assert (delimiter != null) : "Parameter 'delimiter' of method 'concat' must not be null";
        StringBuilder sb = new StringBuilder(EMPTY_STRING);
        boolean first = true;
        for (String next : strings) {
            if (!first) {
                sb.append(delimiter);
            }
            sb.append(next);
            first = false;
        }
        return sb.toString();
    }

    public static String wrapString(String text, int lineLengthStartingAtWhichToCheckForPossibleLineBreaks, char ... lineBreakCharacters) {
        assert (text != null) : "'text' must not be null";
        assert (text.length() > 0) : "'text' must not be empty";
        assert (lineLengthStartingAtWhichToCheckForPossibleLineBreaks > 0) : "'lineLengthStartingAtWhichToCheckForPossibleLineBreaks' must be greater than 0";
        assert (lineBreakCharacters != null) : "'lineBreakCharacters' must not be null";
        assert (lineBreakCharacters.length > 0) : "'lineBreakCharacters' must not be empty";
        StringTokenizer tokenizer = new StringTokenizer(text, LINE_SEPARATOR);
        if (text.length() <= lineLengthStartingAtWhichToCheckForPossibleLineBreaks) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String nextLine = tokenizer.nextToken();
            int i = 0;
            int currentCharsInNewLine = 0;
            while (i < nextLine.length()) {
                char nextChar = nextLine.charAt(i);
                builder.append(nextChar);
                if (currentCharsInNewLine >= lineLengthStartingAtWhichToCheckForPossibleLineBreaks) {
                    int j = 0;
                    while (j < lineBreakCharacters.length) {
                        if (lineBreakCharacters[j] == nextChar) {
                            builder.append(LINE_SEPARATOR);
                            builder.append(BLANK);
                            currentCharsInNewLine = 1;
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
                ++currentCharsInNewLine;
            }
            builder.append(LINE_SEPARATOR);
        }
        return builder.toString();
    }

    public static String wrap(String text, int lineLengthStartingAtWhichToCheckForPossibleLineBreaks, String separators) {
        assert (text != null) : "'text' must not be null";
        assert (text.length() > 0) : "'text' must not be empty";
        assert (lineLengthStartingAtWhichToCheckForPossibleLineBreaks > 0) : "'lineLengthStartingAtWhichToCheckForPossibleLineBreaks' must be greater than 0";
        assert (separators != null && separators.length() > 0) : "Parameter 'separators' of method 'wrap' must not be empty";
        if (text.length() <= lineLengthStartingAtWhichToCheckForPossibleLineBreaks) {
            return text;
        }
        StringBuilder wrappedText = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(text, separators, true);
        int currentCharCount = 0;
        int removeTrailing = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextPart = tokenizer.nextToken();
            if (removeTrailing != 0 && nextPart.equals(BLANK)) {
                removeTrailing = 0;
                continue;
            }
            wrappedText.append(nextPart);
            if ((currentCharCount += nextPart.length()) > lineLengthStartingAtWhichToCheckForPossibleLineBreaks) {
                if (nextPart.equals(BLANK)) {
                    wrappedText.deleteCharAt(wrappedText.length() - 1);
                }
                wrappedText.append(LINE_SEPARATOR);
                removeTrailing += LINE_SEPARATOR.length();
                wrappedText.append(BLANK);
                removeTrailing += BLANK.length();
                currentCharCount = 0;
                continue;
            }
            removeTrailing = 0;
        }
        if (removeTrailing > 0) {
            wrappedText.delete(wrappedText.length() - removeTrailing, wrappedText.length());
        }
        return wrappedText.toString();
    }

    public static List<String> multiLineStringToList(String string) {
        return StringUtility.multiLineStringToList(string, true);
    }

    public static List<String> multiLineStringToList(String string, boolean trim) {
        if (string == null || string.trim().length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = string.split("\r\n|\n|\r");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (trim) {
                line = line.trim();
            }
            if (!line.isEmpty()) {
                result.add(line);
            }
            ++n2;
        }
        return result;
    }

    public static List<String> toList(String input) {
        assert (input != null) : "Parameter 'input' of method 'toList' must not be null";
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(input, DEFAULT_LINE_SEPARATOR, true);
        String previousLine = null;
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            if (previousLine == null && next.equals(DEFAULT_LINE_SEPARATOR)) {
                lines.add(EMPTY_STRING);
                continue;
            }
            if (previousLine != null && next.equals(DEFAULT_LINE_SEPARATOR)) {
                if (previousLine.equals(DEFAULT_LINE_SEPARATOR)) {
                    lines.add(EMPTY_STRING);
                } else {
                    lines.add(previousLine);
                }
            }
            previousLine = next;
        }
        if (previousLine != null) {
            if (previousLine.equals(DEFAULT_LINE_SEPARATOR)) {
                lines.add(EMPTY_STRING);
            } else {
                lines.add(previousLine);
            }
        }
        return lines;
    }

    public static int countLines(String input) {
        assert (input != null) : "Parameter 'input' of method 'countLines' must not be null";
        if (input.isEmpty()) {
            return 0;
        }
        int lineCount = 0;
        StringTokenizer tokenizer = new StringTokenizer(input, DEFAULT_LINE_SEPARATOR, true);
        String previousLine = null;
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            if (next.equals(DEFAULT_LINE_SEPARATOR)) {
                ++lineCount;
            }
            previousLine = next;
        }
        if (previousLine != null) {
            ++lineCount;
        }
        return lineCount;
    }

    public static List<String> splitAndTrim(String string, String separator) {
        assert (string != null) : "Parameter 'string' of method 'split' must not be null";
        assert (separator != null && !separator.isEmpty()) : "Parameter 'separators' of method 'split' must not be empty";
        String trimmedString = string.trim();
        if (trimmedString.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(trimmedString, separator);
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken().trim();
            result.add(line);
        }
        return result;
    }

    public static String harmonizeNewLineBreaks(String text) {
        if (text.length() == 0) {
            return text;
        }
        if (text.length() == 1) {
            return text.charAt(0) != '\r' ? text : DEFAULT_LINE_SEPARATOR;
        }
        StringBuilder content = new StringBuilder(text.length());
        int i = 0;
        while (i < text.length()) {
            char ch;
            if ((ch = text.charAt(i++)) == '\n') {
                content.append(ch);
                continue;
            }
            if (ch == '\r') {
                content.append('\n');
                ch = text.charAt(i++);
                if (ch == '\n') continue;
                content.append(ch);
                continue;
            }
            content.append(ch);
        }
        return content.toString();
    }

    public static boolean areEqual(String string1, String string2) {
        if (string1 == null && string2 == null) {
            return true;
        }
        if (string1 != null && string2 != null) {
            return string1.equals(string2);
        }
        return false;
    }

    public static String convertConstantNameToMixedCaseString(String input, boolean capitalizeFirstLetter, boolean insertSpace) {
        assert (input != null) : "'input' must not be null";
        assert (input.length() > 0) : "'input' must not be empty";
        StringBuilder builder = new StringBuilder();
        boolean previousWasUnderscore = capitalizeFirstLetter;
        int i = 0;
        while (i < input.length()) {
            boolean currentIsUnderscore;
            char nextChar = input.charAt(i);
            boolean bl = currentIsUnderscore = nextChar == '_';
            if (!currentIsUnderscore) {
                if (previousWasUnderscore) {
                    if (insertSpace && builder.length() > 0) {
                        builder.append(' ');
                    }
                    builder.append(Character.toUpperCase(nextChar));
                } else {
                    builder.append(Character.toLowerCase(nextChar));
                }
            }
            previousWasUnderscore = currentIsUnderscore;
            ++i;
        }
        return builder.toString();
    }

    public static String convertConstantNameToStandardName(String input) {
        return StringUtility.convertConstantNameToMixedCaseString(input, true, false);
    }

    public static String convertConstantNameToPresentationName(String input, boolean subsequentWordsUpperCase) {
        assert (input != null) : "'input' must not be null";
        assert (input.length() > 0) : "'input' must not be empty";
        StringBuilder builder = new StringBuilder();
        boolean previousWasUnderscore = true;
        int i = 0;
        while (i < input.length()) {
            boolean currentIsUnderscore;
            char nextChar = input.charAt(i);
            boolean bl = currentIsUnderscore = nextChar == '_';
            if (!currentIsUnderscore) {
                if (previousWasUnderscore) {
                    if (builder.length() > 0) {
                        builder.append(' ');
                        builder.append(subsequentWordsUpperCase ? Character.toUpperCase(nextChar) : Character.toLowerCase(nextChar));
                    } else {
                        builder.append(Character.toUpperCase(nextChar));
                    }
                } else {
                    builder.append(Character.toLowerCase(nextChar));
                }
            }
            previousWasUnderscore = currentIsUnderscore;
            ++i;
        }
        return builder.toString();
    }

    public static String convertConstantNameToPresentationName(String input) {
        return StringUtility.convertConstantNameToPresentationName(input, true);
    }

    public static String convertStandardNameToConstantName(String input) {
        assert (input != null) : "'input' must not be null";
        assert (input.length() > 0) : "'input' must not be empty";
        StringBuilder builder = new StringBuilder();
        char previousChar = input.charAt(0);
        builder.append(Character.toUpperCase(previousChar));
        int i = 1;
        while (i < input.length()) {
            char nextChar = input.charAt(i);
            if (Character.isUpperCase(nextChar) || Character.isDigit(nextChar) && !Character.isDigit(previousChar)) {
                builder.append('_');
            }
            builder.append(Character.toUpperCase(nextChar));
            previousChar = nextChar;
            ++i;
        }
        return builder.toString();
    }

    public static String convertMixedCaseToHumanizedString(String input) {
        assert (input != null) : "'input' must not be null";
        if (input.isEmpty()) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        char previousChar = input.charAt(0);
        builder.append(Character.toUpperCase(previousChar));
        int i = 1;
        while (i < input.length()) {
            char nextChar = input.charAt(i);
            if (Character.isUpperCase(nextChar) || Character.isDigit(nextChar) && !Character.isDigit(previousChar) || Character.isDigit(previousChar) && !Character.isDigit(nextChar)) {
                if (!Character.isUpperCase(previousChar)) {
                    builder.append(' ');
                }
                builder.append(Character.toUpperCase(nextChar));
            } else {
                builder.append(nextChar);
            }
            previousChar = nextChar;
            ++i;
        }
        return builder.toString();
    }

    public static String getDateTimeStringFromLocale(Date date) {
        return DateFormat.getDateTimeInstance(2, 2, Locale.getDefault()).format(date);
    }

    public static String getTimeDateStringFromLocale(Date date) {
        String time = DateFormat.getTimeInstance(2).format(date);
        String dateString = DateFormat.getDateInstance(3).format(date);
        return time + ", " + dateString;
    }

    public static String createTimebasedId(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createId' must not be empty";
        String nameTimestampIdentifier = name + ":" + System.currentTimeMillis();
        return HashSupport.MD5.getHexString(nameTimestampIdentifier);
    }

    public static String concat(char delimiter, String ... input) {
        assert (input != null) : "Parameter 'input' of method 'concat' must not be null";
        if (input.length == 0) {
            return EMPTY_STRING;
        }
        StringBuilder builder = new StringBuilder();
        String[] stringArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            if (next != null && !next.isEmpty()) {
                builder.append(next);
                builder.append(delimiter);
                builder.append(BLANK);
            }
            ++n2;
        }
        if (builder.length() > 0) {
            builder.delete(builder.length() - 1 - BLANK.length(), builder.length());
        }
        return builder.toString();
    }

    public static String toUnixSpecificText(String text) {
        assert (text != null) : "Parameter 'text' of method 'toUnixSpecificText' must not be null";
        if (text.length() == 0) {
            return text;
        }
        String harmonizedText = StringUtility.harmonizeNewLineBreaks(text);
        return harmonizedText;
    }

    public static String findLongestCommonPrefix(String[] strs) {
        if (strs == null || strs.length == 0) {
            return EMPTY_STRING;
        }
        int minLen = Integer.MAX_VALUE;
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (minLen > str.length()) {
                minLen = str.length();
            }
            ++n2;
        }
        if (minLen == 0) {
            return EMPTY_STRING;
        }
        int j = 0;
        while (j < minLen) {
            char prev = '0';
            int i = 0;
            while (i < strs.length) {
                if (i == 0) {
                    prev = strs[i].charAt(j);
                } else if (strs[i].charAt(j) != prev) {
                    return strs[i].substring(0, j);
                }
                ++i;
            }
            ++j;
        }
        return strs[0].substring(0, minLen);
    }

    public static String concat(String s, int times) {
        assert (s != null) : "Parameter 's' of method 'concat' must not be null";
        assert (times > 0) : "Parameter 'times' of method 'concat' must be greater 0";
        return String.join((CharSequence)EMPTY_STRING, Collections.nCopies(times, s));
    }

    public static List<String> parseQuotedLineIntoWords(String line) {
        assert (line != null) : "Parameter 'line' of method 'parseQuotedLineIntoWords' must not be null";
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder word = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (StringReader reader = new StringReader(line);){
                int c;
                while ((c = reader.read()) > 0) {
                    if (c == 39) {
                        while ((c = reader.read()) > 0 && c != 39) {
                            word.append((char)c);
                        }
                        if (c == 39) continue;
                        break;
                    }
                    if (c == 34) {
                        while ((c = reader.read()) > 0 && c != 34) {
                            word.append((char)c);
                        }
                        if (c == 34) continue;
                        break;
                    }
                    if (c == 32) {
                        if (word.length() <= 0) continue;
                        result.add(word.toString().replace('\\', '/'));
                        word.setLength(0);
                        continue;
                    }
                    word.append((char)c);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (word.length() > 0) {
            result.add(word.toString().replace('\\', '/'));
        }
        return result;
    }

    public static String showWhitespace(String text) {
        assert (text != null) : "Parameter 'text' of method 'showWhitespace' must not be null";
        String MAGIC_TEMPROARY_REPLACEMENT = "MAGIC_TEMPROARY_REPLACEMENT";
        String result = text.replace(CRLF_LINE_BREAK, "MAGIC_TEMPROARY_REPLACEMENT");
        result = result.replace(CR_LINE_BREAK, "\\r\r");
        result = result.replace(LF_LINE_BREAK, "\\n\n");
        result = result.replace("MAGIC_TEMPROARY_REPLACEMENT", "\\r\\n\r\n");
        result = result.replace(TAB_STRING, "\\t\t");
        return result;
    }

    public static String removeFirstAndLastChar(String s) {
        assert (s != null && s.length() >= 2);
        return s.substring(1, s.length() - 1);
    }

    public static String decodeStringLiteral(String lit) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < lit.length()) {
            char c = lit.charAt(i);
            if (c == '\\') {
                if (++i >= lit.length()) break;
                switch (lit.charAt(i)) {
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case '0': {
                        sb.append('\u0000');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String removeTrailingNonDigitsAndUnderscores(String s) {
        assert (s != null && s.length() > 0) : "Parameter 's' of method 'removeTrailingCharacters' must not be empty";
        String result = EMPTY_STRING;
        int i = s.length() - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            if (Character.isDigit(c) || "abcdefABCDEF".indexOf(c) >= 0) {
                result = s.substring(0, i + 1);
                break;
            }
            --i;
        }
        result = result.replace("_", EMPTY_STRING);
        return result;
    }

    public static String removeTrailingChar(String input, char c) {
        assert (input != null) : "Parameter 'input' of method 'removeTrailingChar' must not be null";
        if (input.isEmpty()) {
            return input;
        }
        String result = input;
        boolean cont = false;
        do {
            if (result.length() > 0 && result.charAt(result.length() - 1) == c) {
                result = result.substring(0, result.length() - 1);
                cont = true;
                continue;
            }
            cont = false;
        } while (cont);
        return result;
    }
}

