/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionConsumer;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionResult;
import com.hello2morrow.sonargraph.foundation.utilities.IConnectionConsumer;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.URIUtility;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.client5.http.fluent.Response;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpConnectionCheck {
    public static final Map<String, String> NO_HEADERS = Collections.emptyMap();
    public static final ProxySettings NO_PROXY = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConnectionCheck.class);
    private static final String HTTPS = "https://";
    private static final String HTTP = "http://";
    private static final int POLL_DELAY = 250;
    private static final int CONNECT_TIMEOUT_MS = 7000;
    private static final int REQUEST_TIMEOUT_MS = 7000;

    private HttpConnectionCheck() {
    }

    private static Request createHttpRequest(String url, HttpHost proxy, Map<String, String> requestHeaders, int timeoutMillis) {
        assert (url != null && url.length() > 0) : "Parameter 'url' of method 'createHttpRequest' must not be empty";
        assert (requestHeaders != null) : "Parameter 'requestHeaders' of method 'createHttpRequest' must not be null";
        assert (timeoutMillis > 0) : "Parameter 'timeoutMillis' of method 'createHttpRequest' must be positive";
        Request request = Request.get((String)url).viaProxy(proxy).connectTimeout(Timeout.ofMilliseconds((long)7000L)).responseTimeout(Timeout.ofMilliseconds((long)timeoutMillis));
        for (String key : requestHeaders.keySet()) {
            request.addHeader(key, requestHeaders.get(key));
        }
        return request;
    }

    public static boolean canConnect(String url, String expectedResponse, ProxySettings proxySettings) {
        String body;
        block7: {
            Response response;
            block6: {
                assert (url != null && !url.isEmpty()) : "Parameter 'url' of method 'canConnect' must not be empty";
                Executor executor = HttpConnectionCheck.createHttpExecutor(proxySettings);
                HttpHost proxy = HttpConnectionCheck.getProxyHttpHost(proxySettings);
                Request request = HttpConnectionCheck.createHttpRequest(url, proxy, NO_HEADERS, 7000);
                response = executor.execute(request);
                if (expectedResponse != null) break block6;
                int responseCode = response.returnResponse().getCode();
                if (responseCode == 200 || responseCode == 202) {
                    LOGGER.debug("successfully connected to {} via proxy {}", (Object)url, (Object)proxySettings);
                    return true;
                }
            }
            body = response.returnContent().asString();
            if (!expectedResponse.equals(body)) break block7;
            LOGGER.debug("successfully connected to {} via proxy {}, got expected result", (Object)url, (Object)proxySettings);
            return true;
        }
        try {
            LOGGER.warn("Expected response: '{}', actual response: '{}'", (Object)expectedResponse, (Object)body);
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to connect to {}: {}", (Object)url, (Object)e.getMessage());
        }
        return false;
    }

    private static HttpHost getProxyHttpHost(ProxySettings proxySettings) {
        return proxySettings != null ? new HttpHost(proxySettings.getHost(), proxySettings.getPort()) : null;
    }

    public static boolean canConnect(List<String> urls, String expectedResponse, ProxySettings proxySettings) {
        HttpConnectionConsumer consumer = new HttpConnectionConsumer();
        HttpConnectionCheck.canConnect(consumer, urls, NO_HEADERS, expectedResponse, proxySettings);
        return HttpConnectionResult.SUCCESS == consumer.getResult();
    }

    /*
     * Exception decompiling
     */
    public static void canConnect(IConnectionConsumer consumer, List<String> urls, Map<String, String> requestHeaders, String expectedResponse, ProxySettings proxySettings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 2[TRYBLOCK]], but top level block is 11[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Pair<String, ProxySettings> getReachableHostWithProxySettings(List<String> hosts, String path, String expectedResponse, ProxySettings proxySettings) {
        assert (hosts != null && !hosts.isEmpty()) : "Parameter 'hosts' of method 'getReachableHostWithProxySettings' must not be empty";
        assert (path != null) : "Parameter 'path' of method 'getReachableHostWithProxySettings' must not be null";
        String host = HttpConnectionCheck.canConnectToHost(hosts, path, expectedResponse, proxySettings);
        if (host != null) {
            return new Pair<String, ProxySettings>(host, proxySettings);
        }
        if (proxySettings != null && !LOGGER.isTraceEnabled()) {
            LOGGER.debug("Failure to determine reachable host with proxy (" + String.valueOf(proxySettings) + ") trying without proxy...");
            String directHost = HttpConnectionCheck.canConnectToHost(hosts, path, expectedResponse, NO_PROXY);
            if (directHost != null) {
                LOGGER.debug("Successfully connected without proxy to: {}", (Object)directHost);
                return new Pair<String, ProxySettings>(directHost, NO_PROXY);
            }
        }
        return new Pair<Object, Object>(null, null);
    }

    public static String getContent(String url, ProxySettings proxySettings) {
        assert (url != null && url.length() > 0) : "Parameter 'url' of method 'getContent' must not be empty";
        return HttpConnectionCheck.internGetContent(url, NO_HEADERS, proxySettings, null);
    }

    public static String getContent(String url, Map<String, String> requestHeaders, ProxySettings proxySettings, IConnectionConsumer connectionConsumer) {
        assert (url != null && url.length() > 0) : "Parameter 'url' of method 'getContent' must not be empty";
        assert (requestHeaders != null) : "Parameter 'requestHeaders' of method 'getContent' must not be null";
        assert (connectionConsumer != null) : "Parameter 'connectionConsumer' of method 'getContent' must not be null";
        return HttpConnectionCheck.internGetContent(url, requestHeaders, proxySettings, connectionConsumer);
    }

    public static TFile getFileContent(String url, Map<String, String> requestHeaders, ProxySettings proxySettings, TFile targetFile) {
        assert (url != null && url.length() > 0) : "Parameter 'url' of method 'getFileContent' must not be empty";
        assert (requestHeaders != null) : "Parameter 'requestHeaders' of method 'getFileContent' must not be null";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'getFileContent' must not be null";
        try {
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdir(true);
            }
            Executor httpClient = HttpConnectionCheck.createHttpExecutor(proxySettings);
            Request request = HttpConnectionCheck.createHttpRequest(url, HttpConnectionCheck.getProxyHttpHost(proxySettings), requestHeaders, 7000);
            httpClient.execute(request).saveContent((File)targetFile);
            return targetFile;
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to get file from {}: {}", (Object)url, (Object)e.getMessage());
            return null;
        }
    }

    private static String canConnectToHost(List<String> hosts, String path, String expectedResponse, ProxySettings proxySettings) {
        assert (hosts != null && hosts.size() > 0) : "Parameter 'hosts' of method 'canConnectToHost' must not be empty";
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'canConnectToHost' must not be empty";
        ArrayList<String> urls = new ArrayList<String>(hosts.size());
        for (String nextHost : hosts) {
            urls.add(nextHost + path);
        }
        HttpConnectionConsumer consumer = new HttpConnectionConsumer();
        HttpConnectionCheck.canConnect(consumer, urls, NO_HEADERS, expectedResponse, proxySettings);
        if (consumer.getResult() == HttpConnectionResult.SUCCESS) {
            assert (consumer.getURI() != null) : "Consumer URI must be set when result is SUCCESS";
            try {
                URI uri = new URI(consumer.getURI());
                return URIUtility.getProtocolHostAndPort(uri);
            }
            catch (URISyntaxException e) {
                LOGGER.warn("Cannot get URI from Url {}", (Object)consumer.getURI());
            }
        }
        return null;
    }

    private static String internGetContent(String url, Map<String, String> requestHeaders, ProxySettings proxySettings, IConnectionConsumer connectionConsumer) {
        assert (url != null && url.length() > 0) : "Parameter 'url' of method 'getContent' must not be empty";
        assert (requestHeaders != null) : "Parameter 'requestHeaders' of method 'internGetContent' must not be null";
        connectionConsumer = connectionConsumer != null ? connectionConsumer : new HttpConnectionConsumer(){

            @Override
            public void working(String message) {
                super.working(message);
                LOGGER.debug(message);
            }
        };
        HttpConnectionCheck.canConnect(connectionConsumer, Collections.singletonList(url), requestHeaders, null, proxySettings);
        if (connectionConsumer.getContent() == null && proxySettings != null && !LOGGER.isTraceEnabled()) {
            LOGGER.debug("Failure to retrieve content with proxy (" + String.valueOf(proxySettings) + ") trying without proxy...");
            HttpConnectionCheck.canConnect(connectionConsumer, Collections.singletonList(url), requestHeaders, null, null);
            if (connectionConsumer.getContent() != null) {
                LOGGER.debug("Successfully retrieved content without proxy");
            }
        }
        return HttpConnectionResult.SUCCESS == connectionConsumer.getResult() ? connectionConsumer.getContent() : "";
    }

    public static String isValidUrl(String url) {
        String hostOrIP;
        if (url == null || url.isEmpty()) {
            return "URL must not be empty";
        }
        if (url.startsWith(HTTP)) {
            hostOrIP = url.substring(HTTP.length());
        } else if (url.startsWith(HTTPS)) {
            hostOrIP = url.substring(HTTPS.length());
        } else {
            return "URL must start with 'http://' or 'https://'";
        }
        if (hostOrIP.startsWith("/")) {
            return "URL must start with 'http://' or 'https://'";
        }
        if (hostOrIP.isEmpty()) {
            return "Not a valid URL";
        }
        try {
            new URI(url).toURL();
            Request.get((String)url);
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
        return null;
    }

    private static Executor createHttpExecutor(ProxySettings proxySettings) {
        CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().useSystemProperties().setMaxConnPerRoute(100).setMaxConnTotal(200).setValidateAfterInactivity(TimeValue.ofSeconds((long)10L)).build()).useSystemProperties().evictExpiredConnections().evictIdleConnections(TimeValue.ofMinutes((long)1L)).build();
        Executor executor = Executor.newInstance((CloseableHttpClient)client);
        if (proxySettings != null && proxySettings.hasCredentials()) {
            HttpHost proxy = new HttpHost(proxySettings.getHost(), proxySettings.getPort());
            executor.auth(proxy, proxySettings.getUserName(), proxySettings.getPassword().toCharArray());
        }
        return executor;
    }

    private static final class ResultData {
        private final String m_uri;
        private final HttpConnectionResult m_result;
        private final String m_content;

        public ResultData(HttpConnectionResult result, String content, String uri) {
            this.m_result = result;
            this.m_content = content;
            this.m_uri = uri;
        }

        public String getUri() {
            return this.m_uri;
        }

        public HttpConnectionResult getResult() {
            return this.m_result;
        }

        public String getContent() {
            return this.m_content;
        }
    }
}

