/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.persistence;

import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.ObjectPersistence;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectReader
extends ObjectPersistence
implements IObjectReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectReader.class);
    private ReadableByteChannel m_dataChannel;
    private final ByteBuffer m_dataBuffer;
    private DelayedRefResolver[] m_delayedRefs;
    private short m_version;
    private final List<IPersistable> m_objects = new ArrayList<IPersistable>();
    private final List<String> m_stringTable = new ArrayList<String>();
    private final Deque<IPersistable> m_parentStack = new ArrayDeque<IPersistable>();
    private Map<String, Object> m_attrMap;
    private final Map<String, IFactory> m_factoryMap = new HashMap<String, IFactory>();
    private final Map<String, Object> m_variables = new HashMap<String, Object>();
    private final ClassLoader m_classLoader;

    public ObjectReader(ClassLoader classLoader) {
        assert (classLoader != null) : "Parameter 'classLoader' of method 'ObjectReader' must not be null";
        this.m_dataBuffer = ByteBuffer.allocateDirect(65536);
        this.m_classLoader = classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<? extends IPersistable> retrieve(TFile file) throws IOException, RestoreException {
        int magic;
        ReadableByteChannel dataChannel;
        TFileInputStream dataStream;
        Object var4_7;
        Throwable throwable;
        ArrayList<IPersistable> result;
        block42: {
            block41: {
                assert (file != null) : "Parameter 'file' of method 'retrieve' must not be null";
                result = new ArrayList<IPersistable>();
                try {
                    try {
                        throwable = null;
                        var4_7 = null;
                        try {
                            dataStream = new TFileInputStream((File)new TFile((File)file, "reftable.dat"));
                            try {
                                dataChannel = Channels.newChannel((InputStream)dataStream);
                                try {
                                    this.m_dataChannel = dataChannel;
                                    this.m_dataChannel.read(this.m_dataBuffer);
                                    this.m_dataBuffer.flip();
                                    this.ensureAvailable(8);
                                    magic = this.m_dataBuffer.getInt();
                                    if (magic != 538970372) {
                                        throw new IOException("Unexpected file content");
                                    }
                                    int size = this.m_dataBuffer.getInt();
                                    assert (size > 0);
                                    this.ensureAvailable(size * 4);
                                    this.m_delayedRefs = new DelayedRefResolver[size];
                                    int i = 0;
                                    while (i < size) {
                                        int refIndex = this.m_dataBuffer.getInt();
                                        this.m_delayedRefs[i] = new DelayedRefResolver(refIndex);
                                        ++i;
                                    }
                                }
                                finally {
                                    if (dataChannel != null) {
                                        dataChannel.close();
                                    }
                                }
                                if (dataStream == null) break block41;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (dataStream == null) throw throwable;
                                dataStream.close();
                                throw throwable;
                            }
                            dataStream.close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.m_dataChannel = null;
                        break block42;
                    }
                }
                catch (Throwable throwable4) {
                    this.m_dataChannel = null;
                    throw throwable4;
                }
            }
            this.m_dataChannel = null;
        }
        try {
            throwable = null;
            var4_7 = null;
            try {
                dataStream = new TFileInputStream((File)new TFile((File)file, "model.dat"));
                try {
                    dataChannel = Channels.newChannel((InputStream)dataStream);
                    try {
                        this.m_dataChannel = dataChannel;
                        this.m_dataBuffer.clear();
                        this.m_dataChannel.read(this.m_dataBuffer);
                        this.m_dataBuffer.flip();
                        this.ensureAvailable(6);
                        magic = this.m_dataBuffer.getInt();
                        if (magic != 538970372) {
                            throw new IOException("Unexpected file content");
                        }
                        this.m_version = this.m_dataBuffer.getShort();
                        while (true) {
                            if (!this.ensureAvailable(1, false)) {
                                if (this.m_delayedRefs != null) {
                                    Arrays.stream(this.m_delayedRefs).forEach(dr -> dr.resolve());
                                }
                                break;
                            }
                            byte tag = this.m_dataBuffer.get();
                            if (tag != 111) {
                                throw new RestoreException("Unexpected file content");
                            }
                            boolean stackWasEmpty = this.m_parentStack.isEmpty();
                            IPersistable obj = this.readObject();
                            if (!stackWasEmpty) continue;
                            result.add(obj);
                        }
                    }
                    finally {
                        if (dataChannel != null) {
                            dataChannel.close();
                        }
                    }
                    if (dataStream == null) return result;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    if (dataStream == null) throw throwable;
                    dataStream.close();
                    throw throwable;
                }
                dataStream.close();
                return result;
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                }
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
                throw throwable;
            }
        }
        finally {
            this.m_dataChannel = null;
        }
    }

    public <T extends IPersistable> T retrieve(TFile file, Class<T> cls) throws IOException, RestoreException {
        List<? extends IPersistable> objects = this.retrieve(file);
        if (objects.size() != 1) {
            throw new RestoreException("Unexpected file content: " + objects.size() + " root objects found");
        }
        return (T)objects.get(0);
    }

    protected void pushParent(IPersistable parent) {
        assert (parent != null) : "Parameter 'parent' of method 'pushParent' must not be null";
        this.m_parentStack.push(parent);
    }

    @Override
    public <T extends IPersistable> T getCurrentParent(Class<T> cls) {
        return (T)this.m_parentStack.peek();
    }

    protected String kindToClassName(String kind) {
        assert (kind != null) : "Parameter 'kind' of method 'kindToClassName' must not be null";
        return kind;
    }

    protected IFactory createFactory(Class<? extends IPersistable> cls) throws RestoreException {
        return new DefaultConstructorFactory(cls);
    }

    protected IPersistable createObject(String kind) throws RestoreException {
        assert (kind != null) : "Parameter 'kind' of method 'createObject' must not be null";
        String clsName = this.kindToClassName(kind);
        IFactory factory = this.m_factoryMap.get(clsName);
        if (factory == null) {
            Class<? extends IPersistable> cls = this.resolveClass(clsName);
            factory = this.createFactory(cls);
            this.m_factoryMap.put(clsName, factory);
        }
        IPersistable result = factory.createObject(this);
        IPersistable parent = this.getCurrentParent(IPersistable.class);
        if (parent != null) {
            result.linkParent(parent);
        }
        return result;
    }

    private IPersistable readObject() throws IOException, RestoreException {
        String kind = this.readString();
        IPersistable newObject = this.createObject(kind);
        ArrayList<Object> attributes = new ArrayList<Object>();
        this.m_objects.add(newObject);
        while (true) {
            this.ensureAvailable(1);
            byte tag = this.m_dataBuffer.get();
            if (tag == 36) break;
            attributes.add(this.readAttribute(tag));
        }
        String attrList = this.readString();
        String[] attrs = attrList.split(":");
        this.m_attrMap = new HashMap<String, Object>();
        int i = 0;
        while (i < attributes.size()) {
            this.m_attrMap.put(attrs[i], attributes.get(i));
            ++i;
        }
        newObject.readAttributes(this);
        if (this.ensureAvailable(1, false)) {
            byte tag = this.m_dataBuffer.get();
            if (tag == 40) {
                this.m_parentStack.push(newObject);
            } else if (tag == 41) {
                do {
                    this.m_parentStack.pop();
                } while ((tag = this.ensureAvailable(1, false) ? this.m_dataBuffer.get() : (byte)0) == 41);
                if (tag != 0) {
                    this.m_dataBuffer.position(this.m_dataBuffer.position() - 1);
                }
            } else {
                this.m_dataBuffer.position(this.m_dataBuffer.position() - 1);
            }
        }
        this.objectRead(newObject);
        return newObject;
    }

    protected void objectRead(IPersistable obj) {
        assert (obj != null) : "Parameter 'obj' of method 'objectRead' must not be null";
    }

    private Object readAttribute(byte tag) throws IOException, RestoreException {
        switch (tag) {
            case 48: {
                return null;
            }
            case 98: {
                this.ensureAvailable(1);
                return this.m_dataBuffer.get();
            }
            case 104: {
                this.ensureAvailable(2);
                return this.m_dataBuffer.getShort();
            }
            case 105: {
                this.ensureAvailable(4);
                return this.m_dataBuffer.getInt();
            }
            case 108: {
                this.ensureAvailable(8);
                return this.m_dataBuffer.getLong();
            }
            case 102: {
                this.ensureAvailable(4);
                return Float.valueOf(this.m_dataBuffer.getFloat());
            }
            case 100: {
                this.ensureAvailable(8);
                return this.m_dataBuffer.getDouble();
            }
            case 84: {
                return Boolean.TRUE;
            }
            case 70: {
                return Boolean.FALSE;
            }
            case 101: {
                return "";
            }
            case 115: {
                this.ensureAvailable(1);
                byte size = this.m_dataBuffer.get();
                return this.readString(size);
            }
            case 83: {
                this.ensureAvailable(2);
                short size = this.m_dataBuffer.getShort();
                return this.readString(size);
            }
            case 76: {
                this.ensureAvailable(4);
                int size = this.m_dataBuffer.getInt();
                return this.readString(size);
            }
            case 109: {
                this.ensureAvailable(4);
                int index = this.m_dataBuffer.getInt();
                return this.m_stringTable.get(index);
            }
            case 69: {
                String cls = this.readString();
                String name = this.readString();
                Class<? extends IPersistable> enumClass = this.resolveClass(cls);
                return this.getEnumFromString(enumClass, name);
            }
            case 114: {
                this.ensureAvailable(4);
                int index = this.m_dataBuffer.getInt();
                return this.m_objects.get(index);
            }
            case 82: {
                this.ensureAvailable(4);
                int index = this.m_dataBuffer.getInt();
                return this.m_delayedRefs[index];
            }
            case 111: {
                return this.readObject();
            }
            case 91: {
                this.ensureAvailable(1);
                tag = this.m_dataBuffer.get();
                ArrayList<Object> array = new ArrayList<Object>();
                while (tag != 93) {
                    array.add(this.readAttribute(tag));
                    this.ensureAvailable(1);
                    tag = this.m_dataBuffer.get();
                }
                return array;
            }
            case 73: {
                this.ensureAvailable(4);
                int size = this.m_dataBuffer.getInt();
                int[] intArray = new int[size];
                this.ensureAvailable(size * 4);
                int i = 0;
                while (i < size) {
                    intArray[i] = this.m_dataBuffer.getInt();
                    ++i;
                }
                return intArray;
            }
        }
        throw new RestoreException("Unexpected tag: " + (char)tag);
    }

    private <T extends Enum<T>> T getEnumFromString(Class<T> c, String name) throws RestoreException {
        assert (c != null) : "Parameter 'c' of method 'getEnumFromString' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getEnumFromString' must not be empty";
        try {
            return Enum.valueOf(c, name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.resolveMissingEnumConstant(c, name);
        }
    }

    protected <T extends Enum<T>> T resolveMissingEnumConstant(Class<T> enumClass, String name) throws RestoreException {
        assert (enumClass != null) : "Parameter 'enumClass' of method 'resolveMissingEnumConstant' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'resolveMissingEnumConstant' must not be empty";
        throw new RestoreException("Cannot resolve enum value " + name + " in class " + enumClass.getName());
    }

    protected Class<? extends IPersistable> resolveMissingClass(String clsName) throws RestoreException {
        assert (clsName != null && clsName.length() > 0) : "Parameter 'clsName' of method 'resolveMissingClass' must not be empty";
        throw new RestoreException("Cannot resolve class: " + clsName);
    }

    protected Class<? extends IPersistable> resolveClass(String clsName) throws RestoreException {
        assert (clsName != null && clsName.length() > 0) : "Parameter 'clsName' of method 'resolveClass' must not be empty";
        try {
            return this.m_classLoader.loadClass(clsName);
        }
        catch (ClassNotFoundException e) {
            return this.resolveMissingClass(clsName);
        }
    }

    private String readString(int size) throws IOException {
        this.ensureAvailable(size);
        byte[] bytes = new byte[size];
        this.m_dataBuffer.get(bytes);
        String result = new String(bytes, UTF8);
        this.m_stringTable.add(result);
        return result;
    }

    private boolean ensureAvailable(int bytes) throws IOException {
        return this.ensureAvailable(bytes, true);
    }

    private boolean ensureAvailable(int bytes, boolean throwException) throws IOException {
        if (this.m_dataBuffer.remaining() < bytes) {
            if (this.m_dataBuffer.remaining() > 0) {
                byte[] rest = new byte[this.m_dataBuffer.remaining()];
                this.m_dataBuffer.get(rest);
                this.m_dataBuffer.clear();
                this.m_dataBuffer.put(rest);
            } else {
                this.m_dataBuffer.clear();
            }
            this.m_dataChannel.read(this.m_dataBuffer);
            this.m_dataBuffer.flip();
        }
        if (this.m_dataBuffer.remaining() < bytes) {
            if (throwException) {
                throw new IOException("Premature end of file");
            }
            return false;
        }
        return true;
    }

    private String readString() throws IOException {
        this.ensureAvailable(1);
        byte tag = this.m_dataBuffer.get();
        int size = -1;
        switch (tag) {
            case 48: {
                return null;
            }
            case 101: {
                return "";
            }
            case 109: {
                this.ensureAvailable(4);
                int index = this.m_dataBuffer.getInt();
                return this.m_stringTable.get(index);
            }
            case 115: {
                this.ensureAvailable(1);
                size = this.m_dataBuffer.get();
                break;
            }
            case 83: {
                this.ensureAvailable(2);
                size = this.m_dataBuffer.getShort();
                break;
            }
            case 76: {
                this.ensureAvailable(4);
                size = this.m_dataBuffer.getInt();
            }
        }
        assert (size > 0);
        this.ensureAvailable(size);
        byte[] bytes = new byte[size];
        this.m_dataBuffer.get(bytes);
        String result = new String(bytes, UTF8);
        this.m_stringTable.add(result);
        return result;
    }

    @Override
    public short getVersion() {
        return this.m_version;
    }

    @Override
    public Boolean readBoolean(String attributeName) {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        Object value = this.m_attrMap.get(attributeName);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    @Override
    public Integer readInt(String attributeName) {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        Object value = this.m_attrMap.get(attributeName);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    @Override
    public Short readShort(String attributeName) {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        Object value = this.m_attrMap.get(attributeName);
        if (value instanceof Short) {
            return (Short)value;
        }
        return null;
    }

    @Override
    public Long readLong(String attributeName) {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        Object value = this.m_attrMap.get(attributeName);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return null;
    }

    @Override
    public Float readFloat(String attributeName) {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        Object value = this.m_attrMap.get(attributeName);
        if (value instanceof Float) {
            return (Float)value;
        }
        return null;
    }

    @Override
    public String readString(String attributeName) {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        Object value = this.m_attrMap.get(attributeName);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    public String[] readStringArray(String attributeName) {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        Object value = this.m_attrMap.get(attributeName);
        if (value instanceof List) {
            List list = (List)value;
            String[] result = new String[list.size()];
            int i = 0;
            for (Object obj : list) {
                result[i++] = (String)obj;
            }
            return result;
        }
        return null;
    }

    @Override
    public <T extends IPersistable> T[] readOwnedObjects(String attributeName, Class<T> elementClass) {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        Object value = this.m_attrMap.get(attributeName);
        if (value instanceof List) {
            List list = (List)value;
            IPersistable[] result = (IPersistable[])Array.newInstance(elementClass, list.size());
            int i = 0;
            for (Object obj : list) {
                result[i++] = (IPersistable)obj;
            }
            return result;
        }
        return null;
    }

    @Override
    public <T extends IPersistable> void readObjectReference(String attributeName, Class<T> expectedClass, Consumer<T> consumer) throws RestoreException {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        assert (expectedClass != null) : "Parameter 'expectedClass' of method 'readObjectReference' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'readObjectReference' must not be null";
        Object value = this.m_attrMap.get(attributeName);
        if (value == null) {
            consumer.accept(null);
            return;
        }
        if (value instanceof DelayedRefResolver) {
            DelayedRefResolver dr = (DelayedRefResolver)value;
            dr.addConsumer(p -> {
                if (p != null && expectedClass.isAssignableFrom(p.getClass())) {
                    consumer.accept(p);
                } else {
                    if (p != null) {
                        LOGGER.error(String.format("Unexpected type when resolving reference. Expected: %s. Actual: %s", expectedClass.getName(), p.getClass().getName()), (Throwable)new IllegalArgumentException());
                    }
                    consumer.accept(null);
                }
            });
        } else if (expectedClass.isAssignableFrom(value.getClass())) {
            consumer.accept((IPersistable)value);
        } else {
            LOGGER.error(String.format("Unexpected type when resolving reference. Expected: %s. Actual: %s", expectedClass.getName(), value.getClass().getName()), (Throwable)new IllegalArgumentException());
            consumer.accept(null);
        }
    }

    @Override
    public <T extends IPersistable> T[] readObjectReferenceArray(String attributeName, Class<T> expectedClass) throws RestoreException {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        assert (expectedClass != null) : "Parameter 'expectedClass' of method 'readObjectReference' must not be null";
        Object obj = this.m_attrMap.get(attributeName);
        if (obj instanceof List) {
            List list = (List)obj;
            IPersistable[] result = (IPersistable[])Array.newInstance(expectedClass, list.size());
            int i = 0;
            for (Object item : list) {
                if (item == null) {
                    result[i] = null;
                } else if (expectedClass.isAssignableFrom(item.getClass())) {
                    result[i] = (IPersistable)item;
                } else if (item instanceof DelayedRefResolver) {
                    DelayedRefResolver dr = (DelayedRefResolver)item;
                    int index = i;
                    dr.addConsumer(p -> {
                        iPersistableArray[n] = p != null && expectedClass.isAssignableFrom(p.getClass()) ? p : null;
                    });
                } else {
                    result[i] = this.resolveUnexpectedItem(item, expectedClass);
                }
                ++i;
            }
            return result;
        }
        return null;
    }

    protected <T extends IPersistable> T resolveUnexpectedItem(Object descriptor, Class<T> expectedClass) throws RestoreException {
        throw new RestoreException("Unexpected element: " + String.valueOf(descriptor));
    }

    @Override
    public <T> void readOther(String attributeName, Class<T> expectedClass, Consumer<T> consumer) throws RestoreException {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        assert (expectedClass != null) : "Parameter 'expectedClass' of method 'readObjectReference' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'readObjectReference' must not be null";
        Object val = this.m_attrMap.get(attributeName);
        if (val != null && expectedClass.isAssignableFrom(val.getClass())) {
            Object result = val;
            consumer.accept(result);
        } else {
            if (val != null) {
                throw new RestoreException("Cannot assign " + val.getClass().getName() + " to " + expectedClass.getName());
            }
            consumer.accept(null);
        }
    }

    @Override
    public <T extends Enum<?>> T readEnumConstant(String attributeName, Class<T> cls) {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        assert (cls != null) : "Parameter 'cls' of method 'readEnumConstant' must not be null";
        Object obj = this.m_attrMap.get(attributeName);
        if (obj == null) {
            return null;
        }
        if (cls.isAssignableFrom(obj.getClass())) {
            return (T)((Enum)obj);
        }
        return null;
    }

    public void defineVariable(String name, Object value) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'defineVariable' must not be empty";
        assert (value != null) : "Parameter 'value' of method 'defineVariable' must not be null";
        this.m_variables.put(name, value);
    }

    @Override
    public <T> T getVariable(String varName, Class<T> cls) throws RestoreException {
        assert (varName != null && varName.length() > 0) : "Parameter 'varName' of method 'getVariable' must not be empty";
        Object result = this.m_variables.get(varName);
        if (result == null) {
            throw new RestoreException("Unknown variable " + varName);
        }
        return (T)result;
    }

    @Override
    public int[] readIntArray(String attributeName) {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        Object value = this.m_attrMap.get(attributeName);
        if (value instanceof int[]) {
            return (int[])value;
        }
        return null;
    }

    private static class DefaultConstructorFactory
    implements IFactory {
        private final Class<? extends IPersistable> m_class;

        private DefaultConstructorFactory(Class<? extends IPersistable> cls) {
            assert (cls != null) : "Parameter 'cls' of method 'DefaultConstructorFactory' must not be null";
            this.m_class = cls;
        }

        @Override
        public IPersistable createObject(IObjectReader reader) throws RestoreException {
            try {
                return this.m_class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RestoreException("Cannot instantiate " + this.m_class.getName(), e);
            }
        }
    }

    private class DelayedRefResolver {
        private final int m_index;
        private final List<Consumer<IPersistable>> m_consumers = new ArrayList<Consumer<IPersistable>>();

        private DelayedRefResolver(int index) {
            this.m_index = index;
        }

        private void addConsumer(Consumer<IPersistable> consumer) {
            assert (consumer != null) : "Parameter 'consumer' of method 'addConsumer' must not be null";
            this.m_consumers.add(consumer);
        }

        private void resolve() {
            IPersistable resolved = ObjectReader.this.m_objects.get(this.m_index);
            this.m_consumers.forEach(c -> c.accept(resolved));
        }
    }

    protected static interface IFactory {
        public IPersistable createObject(IObjectReader var1) throws RestoreException;
    }
}

