/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.file;

import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistentLocations {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistentLocations.class);
    private final String m_path;
    private final Map<String, String> m_topicToLocation;

    /*
     * Loose catch block
     */
    private static Map<String, String> read(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'read' must not be empty";
        TFile file = new TFile(path);
        if (file.exists()) {
            assert (file.isFile()) : "Not a file path: " + path;
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    Map map;
                    XMLDecoder decoder;
                    BufferedInputStream in;
                    block21: {
                        in = new BufferedInputStream((InputStream)new TFileInputStream((File)file));
                        decoder = new XMLDecoder(in);
                        map = (Map)decoder.readObject();
                        if (decoder != null) {
                            decoder.close();
                        }
                        if (in == null) break block21;
                        in.close();
                    }
                    return map;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (decoder != null) {
                                    decoder.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (in != null) {
                                    in.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                LOGGER.warn("Unable to decode: " + file.getNormalizedPath() + " - " + ExceptionUtility.collectAll(throwable));
            }
        }
        return new HashMap<String, String>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void save(String path, Map<String, String> toBeSaved) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'save' must not be empty";
        assert (toBeSaved != null) : "Parameter 'toBeSaved' of method 'save' must not be null";
        TFile file = new TFile(path);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                BufferedOutputStream out = new BufferedOutputStream((OutputStream)new TFileOutputStream((File)file));
                try {
                    try (XMLEncoder encoder = new XMLEncoder(out);){
                        encoder.writeObject(toBeSaved);
                    }
                    if (out == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                out.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to save file '" + file.getNormalizedPath() + "' - " + ExceptionUtility.collectAll(e));
        }
    }

    public PersistentLocations(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'PersistentLocations' must not be empty";
        this.m_path = path;
        this.m_topicToLocation = PersistentLocations.read(this.m_path);
        Iterator<Map.Entry<String, String>> iter = this.m_topicToLocation.entrySet().iterator();
        while (iter.hasNext()) {
            if (!Files.notExists(Path.of(iter.next().getValue(), new String[0]), new LinkOption[0])) continue;
            iter.remove();
        }
    }

    public String getPath() {
        return this.m_path;
    }

    public int size() {
        return this.m_topicToLocation.size();
    }

    public String getLocation(String topic) {
        assert (topic != null && topic.length() > 0) : "Parameter 'topic' of method 'getLocation' must not be empty";
        return this.m_topicToLocation.get(topic);
    }

    public void setLocation(String topic, String location) {
        assert (topic != null && topic.length() > 0) : "Parameter 'topic' of method 'setLocation' must not be empty";
        boolean save = false;
        if (location == null || location.isEmpty()) {
            String previousLocation = this.m_topicToLocation.remove(topic);
            if (previousLocation != null) {
                save = true;
            }
        } else {
            String previousLocation = this.m_topicToLocation.put(topic, location);
            if (previousLocation == null || !previousLocation.equals(location)) {
                save = true;
            }
        }
        if (save) {
            PersistentLocations.save(this.m_path, this.m_topicToLocation);
        }
    }

    public void clear() {
        if (!this.m_topicToLocation.isEmpty()) {
            this.m_topicToLocation.clear();
            PersistentLocations.save(this.m_path, this.m_topicToLocation);
        }
    }

    public void deleteFile() throws IOException {
        new TFile(this.m_path).rm();
    }

    public String toString() {
        return this.m_topicToLocation.toString();
    }
}

