/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.IMethod;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.utilities.Joiner;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpMember;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpMethodType;
import java.io.IOException;
import java.util.List;

public class CSharpMethod
extends CSharpMember
implements IMethod {
    private static String[] emptyArray = new String[0];
    private CSharpMethodType m_kind;
    private String[] m_typeParameters;

    public CSharpMethod(NamedElement parent) {
        super(parent);
    }

    public CSharpMethod(IModelServiceProvider msp, NamedElement parent, String name, CSharpMethodType kind, String[] typeParameters) {
        super(msp, parent, name);
        assert (kind != null) : "Parameter 'kind' of method 'CSharpRoslynMethod' must not be null";
        this.m_kind = kind;
        this.m_typeParameters = typeParameters == null ? emptyArray : typeParameters;
    }

    public String[] getTypeParameters() {
        return this.m_typeParameters;
    }

    public String getFullyQualifiedNamePart() {
        Object result = super.getShortName();
        if (this.m_typeParameters.length > 0) {
            result = (String)result + "<" + Joiner.join((Object[])this.m_typeParameters) + ">";
        }
        List<String> sigList = this.parseSignature();
        result = (String)result + "(" + Joiner.join(sigList.subList(1, sigList.size())) + ")";
        return result;
    }

    @Override
    public String getPresentationName(boolean shortName) {
        if (shortName) {
            return this.getFullyQualifiedNamePart();
        }
        return this.getParent().getName() + "." + this.getFullyQualifiedNamePart();
    }

    @IntProperty
    public int getNumberOfGenericTypeParameters() {
        return this.m_typeParameters.length;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeByte((byte)this.m_kind.ordinal());
        writer.writeByte((byte)this.m_typeParameters.length);
        String[] stringArray = this.m_typeParameters;
        int n = this.m_typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            writer.writeString(p);
            ++n2;
        }
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_kind = CSharpMethodType.values()[reader.readByte()];
        int length = reader.readByte();
        this.m_typeParameters = length == 0 ? emptyArray : new String[length];
        int i = 0;
        while (i < length) {
            this.m_typeParameters[i] = reader.readString();
            ++i;
        }
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCSharpMethod(this);
        } else {
            super.accept(visitor);
        }
    }

    @IntProperty
    public int getNumberOfParameters() {
        return this.parseSignature().size() - 1;
    }

    @IntProperty
    public int getNumberOfStatements() {
        return -1;
    }

    @IntProperty
    public int getCyclomaticComplexity() {
        return -1;
    }

    @IntProperty
    public int getExtendedCyclomaticComplexity() {
        return -1;
    }

    @IntProperty
    public int getModifiedExtendedCyclomaticComplexity() {
        return -1;
    }

    @IntProperty
    public int getModifiedCyclomaticComplexity() {
        return -1;
    }

    @IntProperty
    public int getMaxNesting() {
        return -1;
    }

    public List<String> getArgumentTypes() {
        List<String> sigList = this.parseSignature();
        return this.parseSignature().subList(1, sigList.size());
    }

    public CSharpMethodType getKind() {
        return this.m_kind;
    }

    public String getReturnType() {
        return this.parseSignature().get(0);
    }

    public boolean isInitializer() {
        return this.m_kind == CSharpMethodType.Constructor || this.m_kind == CSharpMethodType.StaticConstructor;
    }

    public boolean isDestructor() {
        return this.m_kind == CSharpMethodType.Destructor;
    }

    public boolean isOverriding() {
        return this.isOverride();
    }

    public static interface IVisitor {
        public void visitCSharpMethod(CSharpMethod var1);
    }
}

