/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.csharp.command.system.CSharpCommandId;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.parser.roslyn.RoslynDaemon;
import com.hello2morrow.sonargraph.languageprovider.csharp.foundation.common.CSharpCauses;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.ProjectInfo;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.TaskMonitor;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.TaskState;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;

public final class ImportCSharpSolutionFileCommand
extends SonargraphCommand {
    private static final int EXPECTED_DURATION_SECONDS = 8;
    private final IInteraction m_interaction;

    public ImportCSharpSolutionFileCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'ImportCSharpSolutionFileCommand' must not be null";
        this.m_interaction = interaction;
    }

    public final ICommandId getId() {
        return CSharpCommandId.IMPORT_SOLUTION_FILE;
    }

    protected boolean isUndoable() {
        return false;
    }

    protected void internalRun(IWorkerContext workerContext) {
        SolutionFileData importData = new SolutionFileData();
        OperationResultWithOutcome result = new OperationResultWithOutcome("Retrieving list of modules");
        if (!this.m_interaction.collectSolutionFile(importData)) {
            return;
        }
        RoslynDaemon daemon = new RoslynDaemon((OperationResult)result);
        if (result.isSuccess()) {
            if (!daemon.start()) {
                result.addError((OperationResult.IMessageCause)CSharpCauses.DAEMON_ERROR, "Roslyn daemon failed to start: " + daemon.getStartupErrorMessage(), new Object[0]);
            } else {
                workerContext.working("Reading module list from solution...", true);
                workerContext.beginBlockOfWork(80);
                TaskMonitor<List<ProjectInfo>> tm = daemon.openSolution(importData.getSolutionFile().getNormalizedAbsolutePath());
                boolean cancellationAccepted = false;
                TaskState state = TaskState.Running;
                int i = 0;
                while (state == TaskState.Running) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (workerContext.hasBeenCanceled() && !cancellationAccepted) {
                        daemon.cancel();
                        cancellationAccepted = true;
                    }
                    state = tm.getState();
                    if (i < 79) {
                        workerContext.workItemCompleted();
                    }
                    ++i;
                }
                switch (state) {
                    case Finished: {
                        result.setOutcome(tm.getResult());
                        while (i < 80) {
                            workerContext.workItemCompleted();
                            ++i;
                        }
                        break;
                    }
                    case Cancelled: {
                        result.addError((OperationResult.IMessageCause)CSharpCauses.DAEMON_ERROR, "Operation cancelled", new Object[0]);
                        break;
                    }
                    case Error: {
                        result.addError((OperationResult.IMessageCause)CSharpCauses.DAEMON_ERROR, tm.getErrorMessage(), new Object[0]);
                        break;
                    }
                    case Dead: {
                        result.addError((OperationResult.IMessageCause)CSharpCauses.DAEMON_ERROR, "Roslyn daemom died unexpectedly", new Object[0]);
                        break;
                    }
                }
            }
            daemon.stop();
        }
        this.m_interaction.processResult((OperationResultWithOutcome<List<ProjectInfo>>)result);
    }

    public ActivityMode getActivityMode() {
        return ActivityMode.NONE;
    }

    public boolean providesProgress() {
        return true;
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collectSolutionFile(SolutionFileData var1);

        public void processResult(OperationResultWithOutcome<List<ProjectInfo>> var1);
    }

    public static class SolutionFileData
    implements ICommandInteractionData {
        private TFile m_solutionFile;

        public TFile getSolutionFile() {
            return this.m_solutionFile;
        }

        public void setSolutionFile(TFile solutionFile) {
            this.m_solutionFile = solutionFile;
        }
    }
}

