/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeletingFileVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletingFileVisitor.class);

    DeletingFileVisitor() {
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
        if (attributes.isRegularFile()) {
            LOGGER.debug("Deleting Regular File {}", (Object)file.getFileName());
            Files.delete(file);
        } else if (attributes.isSymbolicLink()) {
            LOGGER.debug("Deleting Symbolic Link {}", (Object)file.getFileName());
            Files.delete(file);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path directory, IOException ioe) throws IOException {
        LOGGER.debug("Deleting Directory {}", (Object)directory.getFileName());
        Files.delete(directory);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException ioe) throws IOException {
        LOGGER.debug("Something went wrong while working on {}", (Object)file.getFileName());
        ioe.printStackTrace();
        return FileVisitResult.CONTINUE;
    }
}

