/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.export;

import com.hello2morrow.sonargraph.foundation.export.Column;
import com.hello2morrow.sonargraph.foundation.export.ColumnDatatype;
import com.hello2morrow.sonargraph.foundation.export.Sort;
import java.util.Comparator;
import java.util.List;

final class RowComparator
implements Comparator<List<Object>> {
    private final List<Column> m_columns;
    private final int m_sortColumnIndex;

    public RowComparator(List<Column> columns, int sortColumnIndex) {
        assert (columns != null) : "Parameter 'columns' of method 'RowComparator' must not be null";
        assert (sortColumnIndex >= 0 && sortColumnIndex < columns.size());
        this.m_columns = columns;
        this.m_sortColumnIndex = sortColumnIndex;
    }

    public RowComparator(List<Column> columns) {
        this(columns, 0);
    }

    @Override
    public int compare(List<Object> o1, List<Object> o2) {
        assert (o1 != null) : "Parameter 'o1' of method 'compare' must not be null";
        assert (o2 != null) : "Parameter 'o2' of method 'compare' must not be null";
        assert (o1.size() == o2.size()) : "cannot compare rows of different size";
        assert (o1.size() == this.m_columns.size()) : "wrong number of columns";
        return this.compare(o1, o2, this.m_sortColumnIndex);
    }

    private int compare(List<Object> o1, List<Object> o2, int index) {
        assert (index >= 0 && index <= o1.size()) : "illegal index";
        if (index == o1.size()) {
            return 0;
        }
        ColumnDatatype type = this.m_columns.get(index).getType();
        Sort sort = this.m_columns.get(index).getSort();
        switch (sort) {
            case ASCENDING: {
                int ascendingSort = type.compareTo(o1.get(index), o2.get(index));
                if (ascendingSort == 0) break;
                return ascendingSort;
            }
            case DESCENDING: {
                int descendingSort = type.compareTo(o2.get(index), o1.get(index));
                if (descendingSort == 0) break;
                return descendingSort;
            }
        }
        return this.compare(o1, o2, ++index);
    }
}

