/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.httpclient.controller;

import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionCheck;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.httpclient.model.HttpClientInfo;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public abstract class HttpClientWrapper {
    protected static final String OK_RESPONSE = "OK";
    private static final int CONNECTION_TIMEOUT = 7000;
    private static final int SOCKET_TIMEOUT = 10000;
    private final List<String> m_hosts;
    private final ProxySettings m_proxySettings;

    protected HttpClientWrapper(List<String> hosts, ProxySettings proxySettings) {
        assert (hosts != null && !hosts.isEmpty()) : "Parameter 'hosts' of method 'request' must not be empty";
        assert (proxySettings == null || proxySettings.isValid()) : "'proxySettings' of method 'request' must be valid : " + String.valueOf(proxySettings);
        this.m_hosts = hosts;
        this.m_proxySettings = proxySettings;
    }

    protected Pair<String, ProxySettings> getHostAndProxySettings() {
        return HttpConnectionCheck.getReachableHostWithProxySettings(this.m_hosts, (String)"/license_contracts/test_connection", (String)"OK\n", (ProxySettings)this.m_proxySettings);
    }

    public static HttpClient createHttpClient(ProxySettings proxySettings, int timeoutMultiplier) {
        DefaultHttpClient client = new DefaultHttpClient();
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)(timeoutMultiplier * 7000));
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)(timeoutMultiplier * 10000));
        if (proxySettings != null) {
            HttpHost proxy = new HttpHost(proxySettings.getHost(), proxySettings.getPort());
            ConnRouteParams.setDefaultProxy((HttpParams)params, (HttpHost)proxy);
            if (proxySettings.hasCredentials()) {
                UsernamePasswordCredentials cred = new UsernamePasswordCredentials(proxySettings.getUserName(), proxySettings.getPassword());
                client.getCredentialsProvider().setCredentials(new AuthScope(proxySettings.getHost(), proxySettings.getPort()), (Credentials)cred);
            }
        }
        client.setParams((HttpParams)params);
        return client;
    }

    protected final HttpClientInfo getAvailableHost() {
        Pair<String, ProxySettings> hostAndProxySettings = this.getHostAndProxySettings();
        assert (hostAndProxySettings != null) : "'hostAndProxySettings' of method 'getAvailableHost' must not be null";
        String host = (String)hostAndProxySettings.getFirst();
        if (host != null) {
            assert (host.length() > 0) : "'host' of method 'getAvailableHost' must not be empty";
            ProxySettings proxySettings = (ProxySettings)hostAndProxySettings.getSecond();
            return new HttpClientInfo(host, proxySettings);
        }
        return null;
    }
}

