/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.controller;

import com.hello2morrow.sonargraph.integration.access.controller.IModuleInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyIssue;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.ILogicalElement;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.IMetricValue;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.INamedElementIssue;
import com.hello2morrow.sonargraph.integration.access.model.IPhysicalRecursiveElement;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.integration.access.model.IRootDirectory;
import com.hello2morrow.sonargraph.integration.access.model.ISourceFile;
import com.hello2morrow.sonargraph.integration.access.model.IThresholdViolationIssue;
import com.hello2morrow.sonargraph.integration.access.model.internal.ModuleImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class ModuleInfoProcessorImpl
implements IModuleInfoProcessor {
    private final ModuleImpl module;
    private final ISystemInfoProcessor systemInfoProcessor;

    public ModuleInfoProcessorImpl(ISystemInfoProcessor systemInfoProcessor, ModuleImpl module) {
        assert (systemInfoProcessor != null) : "Parameter 'systemInfoProcessor' of method 'ModuleInfoProcessorImpl' must not be null";
        assert (module != null) : "Parameter 'module' of method 'ModuleInfoProcessorImpl' must not be null";
        this.systemInfoProcessor = systemInfoProcessor;
        this.module = module;
    }

    @Override
    public String getBaseDirectory() {
        return this.systemInfoProcessor.getBaseDirectory();
    }

    @Override
    public List<IIssue> getIssues(Predicate<IIssue> filter) {
        List<IIssue> systemIssues = this.systemInfoProcessor.getIssues(filter);
        return Collections.unmodifiableList(systemIssues.stream().filter(this::isModuleElementOriginOfIssue).collect(Collectors.toList()));
    }

    @Override
    public List<IIssue> getIssues(Set<IIssue> issuesToSelectFrom, Predicate<IIssue> filter) {
        List<IIssue> systemIssues = this.systemInfoProcessor.getIssues(issuesToSelectFrom, filter);
        return Collections.unmodifiableList(systemIssues.stream().filter(this::isModuleElementOriginOfIssue).collect(Collectors.toList()));
    }

    @Override
    public List<IThresholdViolationIssue> getThresholdViolationIssues(Predicate<IThresholdViolationIssue> filter) {
        List<IThresholdViolationIssue> systemIssues = this.systemInfoProcessor.getThresholdViolationIssues(filter);
        return Collections.unmodifiableList(systemIssues.stream().filter(this::isModuleElementOriginOfIssue).collect(Collectors.toList()));
    }

    private boolean isModuleElementOriginOfIssue(IIssue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'isModuleElementInvolved' must not be null";
        if (issue instanceof INamedElementIssue) {
            List<INamedElement> element = ((INamedElementIssue)issue).getAffectedNamedElements();
            return element.stream().anyMatch(this::isElementContainedInModule);
        }
        if (issue instanceof IDependencyIssue) {
            IDependencyIssue dependencyIssue = (IDependencyIssue)issue;
            return this.isElementContainedInModule(dependencyIssue.getFrom());
        }
        return true;
    }

    @Override
    public boolean isElementContainedInModule(INamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'isElementContainedInModule' must not be null";
        Optional<? extends INamedElement> namedElementOpt = element.getOriginalLocation();
        if (namedElementOpt.isPresent()) {
            return this.module.hasElement(namedElementOpt.get());
        }
        return this.module.hasElement(element);
    }

    private INamedElement getElementContainedInModule(INamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getElementContainedInModule' must not be null";
        Optional<? extends INamedElement> namedElementOpt = element.getOriginalLocation();
        if (namedElementOpt.isPresent() && this.module.hasElement(namedElementOpt.get())) {
            return namedElementOpt.get();
        }
        if (this.module.hasElement(element)) {
            return element;
        }
        return null;
    }

    @Override
    public List<IResolution> getResolutions(Predicate<IResolution> filter) {
        List<IResolution> systemResolutions = this.systemInfoProcessor.getResolutions(filter);
        ArrayList<IResolution> moduleResolutions = new ArrayList<IResolution>();
        for (IResolution next : systemResolutions) {
            if (!next.getIssues().stream().filter(this::isModuleElementOriginOfIssue).findAny().isPresent()) continue;
            moduleResolutions.add(next);
        }
        return Collections.unmodifiableList(moduleResolutions);
    }

    @Override
    public <T extends IResolution> List<T> getResolutions(Predicate<T> filter, Class<T> resolutionClass) {
        List<T> systemResolutions = this.systemInfoProcessor.getResolutions(filter, resolutionClass);
        ArrayList<IResolution> moduleResolutions = new ArrayList<IResolution>();
        for (IResolution next : systemResolutions) {
            if (!next.getIssues().stream().filter(this::isModuleElementOriginOfIssue).findAny().isPresent()) continue;
            moduleResolutions.add(next);
        }
        return Collections.unmodifiableList(moduleResolutions);
    }

    @Override
    public IResolution getResolution(IIssue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getResolution' must not be null";
        return this.systemInfoProcessor.getResolution(issue);
    }

    @Override
    public Optional<IMetricId> getMetricId(IMetricLevel level, String metricId) {
        return this.module.getMetricIdsForLevel(level).stream().filter(id -> id.getName().equals(metricId)).findAny();
    }

    @Override
    public Optional<IMetricValue> getMetricValueForElement(IMetricId metricId, IMetricLevel level, String fqName) {
        return this.module.getMetricValueForElement(metricId, level, fqName);
    }

    @Override
    public List<IMetricId> getMetricIdsForLevel(IMetricLevel level) {
        assert (level != null) : "Parameter 'level' of method 'getMetricIdsForLevel' must not be null";
        return this.module.getMetricIdsForLevel(level);
    }

    @Override
    public Map<ISourceFile, Map<IResolution, List<IIssue>>> getIssuesForResolutionsForSourceFiles(Predicate<IResolution> filter) {
        HashMap<ISourceFile, Map<IResolution, List<IIssue>>> sourceFileToResolutionMap = new HashMap<ISourceFile, Map<IResolution, List<IIssue>>>();
        for (IResolution resolution : this.systemInfoProcessor.getResolutions(filter)) {
            Map<ISourceFile, List<IIssue>> issuesToSourceFiles = this.mapIssuesToSourceFiles(resolution.getIssues());
            for (Map.Entry<ISourceFile, List<IIssue>> next : issuesToSourceFiles.entrySet()) {
                ISourceFile sourceFile = next.getKey();
                HashMap<IResolution, List<IIssue>> resolutionToIssues = (HashMap<IResolution, List<IIssue>>)sourceFileToResolutionMap.get(sourceFile);
                if (resolutionToIssues == null) {
                    resolutionToIssues = new HashMap<IResolution, List<IIssue>>();
                    sourceFileToResolutionMap.put(sourceFile, resolutionToIssues);
                }
                resolutionToIssues.put(resolution, next.getValue());
            }
        }
        return sourceFileToResolutionMap;
    }

    @Override
    public Map<ISourceFile, List<IIssue>> getIssuesForSourceFiles(Predicate<IIssue> filter) {
        return this.mapIssuesToSourceFiles(this.systemInfoProcessor.getIssues(filter));
    }

    private void addSourceForIssue(Map<ISourceFile, List<IIssue>> resultMap, IIssue issue, INamedElement element) {
        Optional<ISourceFile> source;
        assert (resultMap != null) : "Parameter 'resultMap' of method 'addSourceForIssue' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'addSourceForIssue' must not be null";
        assert (element != null) : "Parameter 'element' of method 'addSourceForIssue' must not be null";
        if (this.isElementContainedInModule(element) && (source = this.module.getSourceForElement(element)).isPresent()) {
            ISourceFile sourceFile = source.get();
            List<IIssue> issues = resultMap.get(sourceFile);
            if (issues == null) {
                issues = new ArrayList<IIssue>();
                resultMap.put(sourceFile, issues);
            }
            issues.add(issue);
        }
    }

    private Map<ISourceFile, List<IIssue>> mapIssuesToSourceFiles(List<IIssue> systemIssues) {
        assert (systemIssues != null) : "Parameter 'systemIssues' of method 'mapIssuesToSourceFiles' must not be null";
        HashMap<ISourceFile, List<IIssue>> resultMap = new HashMap<ISourceFile, List<IIssue>>();
        for (IIssue issue : systemIssues) {
            if (issue instanceof INamedElementIssue) {
                List<INamedElement> elements = ((INamedElementIssue)issue).getAffectedNamedElements();
                for (INamedElement next : elements) {
                    this.addSourceForIssue(resultMap, issue, next);
                }
            }
            if (!(issue instanceof IDependencyIssue)) continue;
            IDependencyIssue dependencyIssue = (IDependencyIssue)issue;
            this.addSourceForIssue(resultMap, issue, dependencyIssue.getFrom());
        }
        return Collections.unmodifiableMap(resultMap);
    }

    private void addDirectoryIssue(String directory, IIssue issue, Map<String, List<IIssue>> resultMap) {
        assert (directory != null && directory.length() > 0) : "Parameter 'directory' of method 'addDirectoryIssue' must not be empty";
        assert (issue != null) : "Parameter 'issue' of method 'addDirectoryIssue' must not be null";
        assert (resultMap != null) : "Parameter 'resultMap' of method 'addDirectoryIssue' must not be null";
        List<IIssue> issues = resultMap.get(directory);
        if (issues == null) {
            issues = new ArrayList<IIssue>();
            resultMap.put(directory, issues);
        }
        issues.add(issue);
    }

    private String concatenate(String relativeRootDirectory, String relativeDirectory) {
        assert (relativeRootDirectory != null && relativeRootDirectory.length() > 0) : "Parameter 'relativeRootDirectory' of method 'concatenate' must not be empty";
        assert (relativeDirectory != null && relativeDirectory.length() > 0) : "Parameter 'relativeDirectory' of method 'concatenate' must not be empty";
        Object directory = relativeRootDirectory;
        directory = relativeDirectory.startsWith("./") ? (String)directory + relativeDirectory.substring(1) : (relativeDirectory.startsWith(".") ? (String)directory + relativeDirectory.substring(2) : (String)directory + relativeDirectory);
        return directory;
    }

    private List<INamedElement> getOrigins(INamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getOrigins' must not be null";
        if (namedElement instanceof ILogicalElement) {
            ArrayList<INamedElement> origins = new ArrayList<INamedElement>();
            for (INamedElement nextDerivedFrom : ((ILogicalElement)namedElement).getDerivedFrom()) {
                origins.add(nextDerivedFrom);
            }
            return origins;
        }
        return Collections.singletonList(namedElement);
    }

    private void addDirectoryIssues(IIssue issue, INamedElement namedElement, Map<String, List<IIssue>> resultMap) {
        assert (issue != null) : "Parameter 'issue' of method 'addDirectoryIssues' must not be null";
        assert (namedElement != null) : "Parameter 'namedElement' of method 'addDirectoryIssues' must not be null";
        assert (resultMap != null) : "Parameter 'resultMap' of method 'addDirectoryIssues' must not be null";
        for (INamedElement nextOrigin : this.getOrigins(namedElement)) {
            INamedElement contained = this.getElementContainedInModule(nextOrigin);
            if (contained == null) continue;
            if (contained instanceof IRootDirectory) {
                this.addDirectoryIssue(((IRootDirectory)contained).getRelativePath(), issue, resultMap);
                continue;
            }
            if (!(contained instanceof IPhysicalRecursiveElement)) continue;
            IPhysicalRecursiveElement nextPhysicalRecursiveElement = (IPhysicalRecursiveElement)contained;
            Optional<String> relRootDirOpt = nextPhysicalRecursiveElement.getRelativeRootDirectory();
            Optional<String> relDirOpt = nextPhysicalRecursiveElement.getRelativeDirectory();
            if (!relRootDirOpt.isPresent() || !relDirOpt.isPresent()) continue;
            String directory = this.concatenate(relRootDirOpt.get(), relDirOpt.get());
            this.addDirectoryIssue(directory, issue, resultMap);
        }
    }

    @Override
    public Map<String, List<IIssue>> getIssuesForDirectories(Predicate<IIssue> filter) {
        HashMap<String, List<IIssue>> resultMap = new HashMap<String, List<IIssue>>();
        for (IIssue nextIssue : this.systemInfoProcessor.getIssues(filter)) {
            if (nextIssue instanceof INamedElementIssue) {
                List<INamedElement> elements = ((INamedElementIssue)nextIssue).getAffectedNamedElements();
                for (INamedElement next : elements) {
                    this.addDirectoryIssues(nextIssue, next, resultMap);
                }
            }
            if (!(nextIssue instanceof IDependencyIssue)) continue;
            INamedElement from = ((IDependencyIssue)nextIssue).getFrom();
            this.addDirectoryIssues(nextIssue, from, resultMap);
        }
        return Collections.unmodifiableMap(resultMap);
    }

    @Override
    public Map<INamedElement, IMetricValue> getMetricValues(String levelName, String metricIdName) {
        return this.module.getMetricValues(levelName, metricIdName);
    }

    @Override
    public List<IMetricLevel> getMetricLevels() {
        return Collections.unmodifiableList(new ArrayList<IMetricLevel>(this.module.getMetricLevels().values()));
    }

    @Override
    public Optional<IMetricLevel> getMetricLevel(String level) {
        assert (level != null && level.length() > 0) : "Parameter 'level' of method 'getMetricLevel' must not be empty";
        return Optional.ofNullable(this.module.getMetricLevels().get(level));
    }

    @Override
    public Optional<IMetricValue> getMetricValue(String metricName) {
        return Optional.ofNullable(this.module.getMetricValues("Module", metricName).get(this.module));
    }
}

