/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.foundation.common;

import com.hello2morrow.sonargraph.build.api.ProgressInfo;
import com.hello2morrow.sonargraph.foundation.activity.Activity;
import com.hello2morrow.sonargraph.foundation.activity.WorkerContext;

public final class DotProgressConsoleWorkerContext
extends WorkerContext {
    private static final int PERCENTAGE_INFO_INTERVAL = 10;
    private int m_currentProgress = 0;
    private final ProgressInfo m_progressInfo;

    public DotProgressConsoleWorkerContext(ProgressInfo info) {
        assert (info != null) : "Parameter 'info' of method 'DotProgressConsoleWorkerContext' must not be null";
        this.m_progressInfo = info;
    }

    protected void activityUpdated(Activity activity) {
        if (activity.isRunning()) {
            if (activity.providesProgress()) {
                int progress = activity.getWorkedInPercent();
                if (progress > this.m_currentProgress) {
                    this.printDots(progress - this.m_currentProgress);
                    this.m_currentProgress = progress;
                }
            } else if (activity.isMainStep()) {
                this.printDots(1);
            }
        } else {
            if (activity.providesProgress() && this.m_currentProgress < 100) {
                this.printDots(100 - this.m_currentProgress);
            }
            System.out.print("\n");
            System.out.flush();
        }
    }

    private void printDots(int count) {
        int progress = this.m_currentProgress;
        int i = 0;
        while (i < count) {
            System.out.print('.');
            boolean appendPercentageInfo = this.appendPercentageInfo(++progress);
            if (this.m_progressInfo == ProgressInfo.BASIC_FLUSH_EVERY_10_PERCENT) {
                if (appendPercentageInfo) {
                    System.out.flush();
                }
            } else {
                System.out.flush();
            }
            ++i;
        }
    }

    private boolean appendPercentageInfo(int progress) {
        if (progress % 10 == 0) {
            System.out.println("[" + progress + "%]");
            return true;
        }
        return false;
    }
}

