/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.model.programming;

import com.hello2morrow.sonargraph.core.model.element.GenericStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElementWithChildren;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import java.io.IOException;

public final class TypescriptTypeAlias
extends ProgrammingElementWithChildren {
    private String m_typeParameters;

    public TypescriptTypeAlias(NamedElement parent) {
        super(parent);
    }

    public TypescriptTypeAlias(IModelServiceProvider msp, NamedElement parent, String shortName, int lineNumber) {
        super(msp, parent, shortName, lineNumber);
    }

    public IStructureItem getStructureItem() {
        return GenericStructureItem.PROGRAMMING_ELEMENT;
    }

    public String getFullyQualifiedNamePart() {
        return super.getFullyQualifiedNamePart() + "-" + Integer.toString(this.getLineNumber());
    }

    public boolean isMember() {
        return false;
    }

    public void setTypeParameters(String typeParameters) {
        this.m_typeParameters = typeParameters;
    }

    public String getShortName() {
        StringBuilder sb = new StringBuilder(super.getShortName());
        if (this.m_typeParameters.length() > 0) {
            sb.append('<').append(this.m_typeParameters.replace(";", ", ")).append('>');
        }
        return sb.toString();
    }

    public String getName() {
        NamedElement parent = this.getParent();
        if (parent instanceof SourceFile) {
            return this.getShortName();
        }
        return parent.getName() + "." + this.getShortName();
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_typeParameters);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_typeParameters = reader.readString();
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitTypescriptTypeAlias(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitTypescriptTypeAlias(TypescriptTypeAlias var1);
    }
}

