/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MacFrameworkAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacFrameworkAccessor.class);
    private static final String CONFIG_FILE = "config.properties";
    private static MacFrameworkAccessor s_instance;
    private final TFile m_workingDirectory;
    private final Properties m_settings = new Properties();

    private MacFrameworkAccessor(TFile dir) {
        assert (dir != null) : "Parameter 'dir' of method 'MacFrameworkExtension' must not be null";
        this.m_workingDirectory = new TFile((File)dir, "MacFrameworkExtension");
        if (!this.m_workingDirectory.exists()) {
            this.m_workingDirectory.mkdir();
        } else {
            assert (this.m_workingDirectory.isDirectory()) : this.m_workingDirectory.getPath() + " must be a directory";
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (FileInputStream inp = new FileInputStream((File)new TFile((File)this.m_workingDirectory, CONFIG_FILE));){
                    this.m_settings.load(inp);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException exc) {
                LOGGER.error("Cannot read MacFramework extension settings file", (Throwable)exc);
            }
        }
    }

    public static MacFrameworkAccessor createInstance(TFile directory) {
        assert (Platform.isMac()) : "Not the Mac platform";
        s_instance = new MacFrameworkAccessor(directory);
        return s_instance;
    }

    static MacFrameworkAccessor getInstance() {
        assert (s_instance != null) : "'s_instance' of method 'getInstance' must not be null";
        return s_instance;
    }

    private List<String> getFrameworkDirectoryNames(String frameworkDirectory) {
        TFile[] frameworkFiles;
        ArrayList<String> result = new ArrayList<String>();
        TFile dir = new TFile(frameworkDirectory);
        if (!dir.isDirectory()) {
            LOGGER.error(dir.getPath() + " is not a directory (-Fdir option)");
            return null;
        }
        TFile[] tFileArray = frameworkFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                if (!path.isDirectory() || !path.getName().endsWith(".framework")) {
                    return false;
                }
                TFile headerDir = new TFile(path, "Headers");
                return headerDir.isDirectory();
            }
        });
        int n = frameworkFiles.length;
        int n2 = 0;
        while (n2 < n) {
            TFile file = tFileArray[n2];
            result.add(file.getName());
            ++n2;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private boolean createSymbolicLink(String linkDir, String targetDir, String fwName) {
        Path link = Paths.get(linkDir, fwName);
        Path target = Paths.get(targetDir, fwName + ".framework", "Headers");
        try {
            Files.createSymbolicLink(link, target, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            return true;
        }
        catch (IOException e) {
            LOGGER.warn("Cannot create symbolic link " + link.toString(), (Throwable)e);
            return false;
        }
        return true;
    }

    String getSymbolicFrameworkDirectory(String frameworkDirectory) {
        Object params;
        String settings = this.m_settings.getProperty(frameworkDirectory);
        List<String> frameworkDirs = this.getFrameworkDirectoryNames(frameworkDirectory);
        boolean settingsChanged = false;
        String result = null;
        if (frameworkDirs == null) {
            return null;
        }
        if (settings == null) {
            String dirName = String.format("Links-%03d", this.m_settings.size() + 1);
            TFile frameworkDir = new TFile((File)this.m_workingDirectory, dirName);
            StringBuilder configDef = new StringBuilder();
            int counter = 0;
            frameworkDir.mkdir();
            configDef.append(frameworkDir.getPath());
            for (String fwDirName : frameworkDirs) {
                String fwName = fwDirName.substring(0, fwDirName.length() - 10);
                if (!this.createSymbolicLink(frameworkDir.getPath(), frameworkDirectory, fwName)) continue;
                configDef.append(',').append(fwName);
                ++counter;
            }
            if (counter > 0) {
                this.m_settings.put(frameworkDirectory, configDef.toString());
                settingsChanged = true;
                result = frameworkDir.getPath();
            }
        } else {
            params = settings.split(",");
            ArrayList<String> preparedFrameworks = new ArrayList<String>();
            String linkDir = params[0];
            StringBuilder configDef = new StringBuilder(linkDir);
            int i = 1;
            while (i < ((String[])params).length) {
                preparedFrameworks.add(params[i]);
                ++i;
            }
            for (String fwDirName : frameworkDirs) {
                String fwName = fwDirName.substring(0, fwDirName.length() - 10);
                if (!preparedFrameworks.remove(fwName)) {
                    if (!this.createSymbolicLink(linkDir, frameworkDirectory, fwName)) continue;
                    settingsChanged = true;
                    configDef.append(',').append(fwName);
                    continue;
                }
                configDef.append(',').append(fwName);
            }
            for (String removedFramework : preparedFrameworks) {
                TFile linkToRemove = new TFile(linkDir, removedFramework);
                try {
                    linkToRemove.rm();
                    settingsChanged = true;
                }
                catch (IOException e) {
                    LOGGER.warn(String.format("Cannot remove link '%s'", linkToRemove.getPath()), (Throwable)e);
                }
            }
            result = linkDir;
            if (settingsChanged) {
                this.m_settings.put(frameworkDirectory, configDef.toString());
            }
        }
        if (settingsChanged) {
            try {
                params = null;
                Object var7_9 = null;
                try (FileOutputStream out = new FileOutputStream((File)new TFile((File)this.m_workingDirectory, CONFIG_FILE));){
                    this.m_settings.store(out, "registry for symbolic links created to access framework header files");
                }
                catch (Throwable throwable) {
                    if (params == null) {
                        params = throwable;
                    } else if (params != throwable) {
                        ((Throwable)params).addSuppressed(throwable);
                    }
                    throw params;
                }
            }
            catch (IOException e) {
                LOGGER.error("Cannot write MacFramework extension settings file", (Throwable)e);
            }
        }
        return result;
    }
}

