/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IncludeOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.SystemNonExistingIncludeIssue;

public class ExternalOptionsValidator {
    private final CompilerOptions m_options;

    public ExternalOptionsValidator(CompilerOptions optionsToValidate) {
        assert (optionsToValidate != null) : "Parameter 'optionsToValidate' of method 'ExternalOptionsValidator' must not be null";
        this.m_options = optionsToValidate;
    }

    public Result validateExternalOptions(boolean addIssues) {
        if (addIssues) {
            this.m_options.removeIssues();
        }
        StringBuilder errorMessage = new StringBuilder();
        for (ICompilerOption option : this.m_options.getChildren(ICompilerOption.class)) {
            Result optionResult;
            if (!(option instanceof IncludeOption) || !(optionResult = option.validate()).isFailure()) continue;
            if (addIssues) {
                this.m_options.addIssue((Issue)new SystemNonExistingIncludeIssue((NamedElement)this.m_options, optionResult.getErrorMessage()));
            }
            errorMessage.append(optionResult.getErrorMessage()).append(StringUtility.LINE_SEPARATOR);
        }
        Result result = new Result();
        if (errorMessage.length() > 0) {
            result.addErrorMessage(errorMessage.toString());
        }
        return result;
    }
}

