/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppRoutine;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppNamespaceComponent;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import java.io.IOException;

public abstract class CppRoutineDefinition
extends CppRoutine
implements ICppNamespaceComponent {
    private int m_numberOfStatements;
    private int m_cyclomaticComplexity;
    private int m_modifiedCyclomaticComplexity;
    private short m_numberOfLogicalOperations;
    private short m_maxNesting;

    protected CppRoutineDefinition(NamedElement parent) {
        super(parent);
    }

    protected CppRoutineDefinition(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, short noTemplateArgs) {
        super(msp, parent, name, lineNumber, noTemplateArgs);
    }

    public String getInformation() {
        return "Definition";
    }

    @Override
    public boolean isDefinition() {
        return true;
    }

    public boolean hasMultipleDefinitions() {
        ParserDependency dep = this.getIncomingDependencies(new IStandardEnumeration[]{CppDependencyType.DECLARES}).stream().findFirst().orElse(null);
        if (dep == null) {
            return false;
        }
        return ((CppRoutine)dep.getFrom()).hasMultipleDefinitions();
    }

    @Override
    @IntProperty
    public int getNumberOfStatements() {
        return this.m_numberOfStatements;
    }

    public void setNumberOfStatements(int numberOfStatements) {
        this.m_numberOfStatements = numberOfStatements;
    }

    public void setCyclomaticComplexity(int cyclomaticComplexity) {
        this.m_cyclomaticComplexity = cyclomaticComplexity;
    }

    public void setModifiedCyclomaticComplexity(int modifiedCyclomaticComplexity) {
        this.m_modifiedCyclomaticComplexity = modifiedCyclomaticComplexity;
    }

    public void setNumberOfLogicalOperations(int numberOfLogicalOperations) {
        this.m_numberOfLogicalOperations = (short)numberOfLogicalOperations;
    }

    @Override
    @IntProperty
    public int getMaxNesting() {
        return this.m_maxNesting;
    }

    public void setMaxNesting(int maxNesting) {
        this.m_maxNesting = (short)maxNesting;
    }

    @Override
    @IntProperty
    public int getCyclomaticComplexity() {
        return this.m_cyclomaticComplexity;
    }

    @Override
    @IntProperty
    public int getExtendedCyclomaticComplexity() {
        return this.m_cyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    @Override
    @IntProperty
    public int getModifiedExtendedCyclomaticComplexity() {
        return this.m_modifiedCyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    @Override
    @IntProperty
    public int getModifiedCyclomaticComplexity() {
        return this.m_modifiedCyclomaticComplexity;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeInt(this.m_numberOfStatements);
        writer.writeInt(this.m_cyclomaticComplexity);
        writer.writeInt(this.m_modifiedCyclomaticComplexity);
        writer.writeInt((int)this.m_numberOfLogicalOperations);
        writer.writeShort(this.m_maxNesting);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_numberOfStatements = reader.readInt();
        this.m_cyclomaticComplexity = reader.readInt();
        this.m_modifiedCyclomaticComplexity = reader.readInt();
        this.m_numberOfLogicalOperations = (short)reader.readInt();
        this.m_maxNesting = reader.getVersion() >= 12 ? reader.readShort() : (short)-1;
    }

    public final int getSourceElementCount() {
        if (!this.isDefinedInEnclosingElement() || this.isExternal()) {
            return -1;
        }
        return 1 + this.m_numberOfStatements;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppRoutineDefinition(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppRoutineDefinition(CppRoutineDefinition var1);
    }
}

