/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser;

import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElement;
import java.io.IOException;

public class CppSourceFileElement
extends CppElement {
    private static final String IS_CPP = "isCpp";
    private static final String IS_EXTERNAL = "isExternal";
    private boolean m_isExternal;
    private boolean m_isCpp = false;

    public CppSourceFileElement() {
    }

    public CppSourceFileElement(CppElement parent, String fileName, boolean isExternal) {
        super(parent, fileName);
        this.m_isExternal = isExternal;
    }

    @Override
    public boolean isExternal() {
        return this.m_isExternal;
    }

    @Override
    public CppElement getSource() {
        return this;
    }

    @Override
    public String getKey() {
        assert (false) : "getKey() should never be called on CppSourceFileElement";
        return null;
    }

    public void markAsCpp() {
        this.m_isCpp = true;
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeBoolean(IS_EXTERNAL, this.m_isExternal);
        writer.writeBoolean(IS_CPP, this.m_isCpp);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        this.m_isExternal = reader.readBoolean(IS_EXTERNAL);
        this.m_isCpp = reader.readBoolean(IS_CPP);
    }

    @Override
    public void accept(CppElement.Visitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)((Object)visitor)).visitCppSourceFileElement(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitCppSourceFileElement(CppSourceFileElement var1);
    }
}

