/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.DeltaDetector;
import com.hello2morrow.sonargraph.core.controller.system.IKeywordProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringAdapter;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceModification;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IMetricAwareLanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controller.system.base.RelativeCyclicityMetricIds;
import com.hello2morrow.sonargraph.core.controller.system.parser.ISourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.parser.SourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.script.CoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.script.internal.ScriptApi;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceLinesScanner;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.ISourceFileRegionVisitor;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.ExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceScope;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.programming.PhysicalElementBasedExternalLogicalRoot;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.refactoring.AssignableToArtifactRefactoringDescriptor;
import com.hello2morrow.sonargraph.core.model.script.IMetricIdProvider;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SignatureElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettingsSignature;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettingsSignatureWithTimestamp;
import com.hello2morrow.sonargraph.core.model.system.settings.RootDirectorySettings;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.base.IAdditionalFileInfoProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.ComponentAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.ComponentAssignmentExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CPlusPlusInstallationExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CPlusPlusParserConfigurationExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CPlusPlusSoftwareSystemSettingsExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CaptureExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CppExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CppImportExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.SaveAsVisitor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.VisualStudioInstallationsExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusAverageComplexityCalculator;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusCCSpyDeltaDetector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusCMakeDeltaDetector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusDeltaDetector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusExportExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusRefactoringAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusRefactoringDescriptorProvider;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusSourceNodeDeltaDetector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusVisualStudioExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusVisualStudioSolutionFileImportExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusVsProjectFileBasedModuleDeltaDetector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusWorkspaceExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CppFieldCategoryAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CppHeaderFileCategoryAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CppMemberFunctionCategoryAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.PrepareRefreshWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.PrepareRefreshWorkspaceFilter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.RefreshJob;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.RefreshMessageCause;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.analysis.CPLusPlusNamespaceCyclesInModuleMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.analysis.CPlusPlusDirectoryCyclesInModulesAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.analysis.CPlusPlusDirectoryCyclesInModulesMetricAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.analysis.CPlusPlusDirectoryCyclesInSystemAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.analysis.CPlusPlusDirectoryCyclesInSystemMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.analysis.CPlusPlusNamespaceCyclesInModuleAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.analysis.CPlusPlusNamespaceCyclesInSystemAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.analysis.CPlusPlusNamespaceCyclesInSystemMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.architecture.CppExtendsClassRetriever;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.architecture.CppHeaderPathRetriever;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.DiagnosticMode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.plugin.PluginCppAccess;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.script.CppAccess;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.settings.ICPlusPlusInstallationExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.system.ICPlusPlusParserConfigurationExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.system.ICPlusPlusWorkspaceExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusLanguage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.analysis.CPlusPlusAnalyzerId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusIssueId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusProviderId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusStructureItem;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CompilationUnitFragment;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppExternalHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppParserLogSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CPlusPlusLogicalModuleNamespace;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CPlusPlusLogicalSystemNamespace;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CPlusPlusMetricLevel;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CPlusPlusWorkspaceDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClass;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnion;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnionNamespace;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppComponent;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppEnumeration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppField;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppFunction;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppFunctionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMacro;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMacroInvocation;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMemberFunction;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMemberFunctionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppStruct;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppStructDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppTypedef;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppUnion;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppUnionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppVariable;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ActiveDefinitionSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CCSpyDirectory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CommandFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerDefinitionSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.MacFrameworkAccessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SettingsBuilder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusCMakeJsonModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusCaptureModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusExternal;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusInternalHeaders;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusManualModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusMetricId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModuleType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusParserLogSourceRoot;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusRefreshOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusUnboundComponents;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusVsProjectFileBasedModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICPlusPlusParserConfigurationProvider;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICPlusPlusSoftwareSystemSettingsProvider;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICppImportExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.CPlusPlusPersistenceProvider;
import com.hello2morrow.sonargraph.plugin.cplusplus.IPluginCppAccess;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CPlusPlusLanguageProvider
extends LanguageProvider
implements IKeywordProvider,
CPlusPlusRefactoringAdapter.IRefactoringDescriptorProvider,
CPlusPlusSoftwareSystemSettingsExtension.IListener {
    public static final String PARAM_COMPILER_DEFINITION_PATH = "compilerDefinitionPath";
    public static final String PARAM_NUMBER_OF_DAEMONS = "numberOfDaemons";
    public static final String PARAM_DAEMON_STACK_SIZE = "daemonStackSize";
    public static final String FOLDER_NAME = "cplusplus";
    public static final String SONARGRAPH_CPP_HOME = String.valueOf(CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir()) + System.getProperty("file.separator") + "cplusplus";
    public static final String[] IMPORT_START_TOKENS = new String[]{"#include"};
    private static final Logger LOGGER = LoggerFactory.getLogger(CPlusPlusLanguageProvider.class);
    private static final String DIAGNOSTICS_FOLDER_NAME = "diagnostics";
    private static final long MILLIS_PER_WEEK = 604800000L;
    private static final String COMPILER_DEF_PROPERTY = "cpp.usedCompilerDefinition";
    private static final String[] CPP_KEYWORDS = new String[]{"alignas", "alignof", "and", "and_eq", "asm", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "char16_t", "char32_t", "class", "compl", "const", "constexpr", "const_cast", "continue", "decltype", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "long", "mutable", "namespace", "new", "noexcept", "not", "not_eq", "nullptr", "operator", "or", "or_eq", "private", "protected", "public", "register", "reinterpret_cast", "return", "short", "signed", "sizeof", "static", "static_assert", "static_cast", "struct", "switch", "template", "this", "thread_local", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq"};
    private static final String[] C_KEYWORDS = new String[]{"auto", "break", "case", "char", "const", "continue", "default", "do", "double", "else", "enum", "extern", "float", "for", "goto", "if", "int", "long", "register", "return", "short", "signed", "sizeof", "static", "struct", "switch", "typedef", "union", "unsigned", "void", "volatile", "while"};
    private static final String[] PREPROCESSOR_DIRECTIVES = new String[]{"define", "elif", "else", "endif", "error", "if", "ifdef", "ifndef", "include", "line", "pragma", "undef"};
    private final CPlusPlusRefactoringAdapter m_refactoringAdapter = new CPlusPlusRefactoringAdapter(this, this);
    private final TFile m_cppHomeDir;
    private final TFile m_diagnosticsDir;
    private final String m_generatedCompilerDefinitionPath;
    private RefreshJob m_currentRefreshJob;
    private Installation m_installation;
    private long m_parsingTime;
    private long m_backendTime;
    private boolean m_recreateComponents;
    private DirectoryBean m_ccspyBean;
    private boolean m_ccspyInitialized;
    private List<DirectoryBean> m_roots;
    private CommandFile m_commandFile;

    public CPlusPlusLanguageProvider(String cppHomeDirectory, String generatedCompilerDefinitionPath, DiagnosticMode mode) {
        super((Language)CPlusPlusLanguage.INSTANCE);
        assert (cppHomeDirectory != null) : "Parameter 'cppHomeDirectory' of method 'CPlusPlusLanguageProvider' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'CPlusPlusLanguageProvider' must not be null";
        this.m_cppHomeDir = new TFile(cppHomeDirectory);
        if (!this.m_cppHomeDir.exists()) {
            this.m_cppHomeDir.mkdirs();
        } else assert (this.m_cppHomeDir.isDirectory());
        this.m_diagnosticsDir = new TFile((File)this.m_cppHomeDir, DIAGNOSTICS_FOLDER_NAME);
        if (!this.m_diagnosticsDir.exists() || !this.m_diagnosticsDir.isDirectory()) {
            this.m_diagnosticsDir.mkdir();
        }
        this.m_generatedCompilerDefinitionPath = generatedCompilerDefinitionPath;
        if (Platform.isMac()) {
            MacFrameworkAccessor.createInstance(this.m_cppHomeDir);
        }
    }

    public CPlusPlusLanguageProvider() {
        this(SONARGRAPH_CPP_HOME, null, DiagnosticMode.INTERNAL_ERRORS);
    }

    public CPlusPlusLanguageProvider(String cppHomeDirectory, String generatedCompilerDefinitionPath) {
        this(cppHomeDirectory, generatedCompilerDefinitionPath, DiagnosticMode.INTERNAL_ERRORS);
    }

    public Set<String> getKeywords(IFileType fileType) {
        assert (fileType != null) : "Parameter 'fileType' of method 'getKeywords' must not be null";
        HashSet<String> keyWords = new HashSet<String>(Arrays.asList(CPP_KEYWORDS));
        keyWords.addAll(Arrays.asList(C_KEYWORDS));
        return keyWords;
    }

    public String getExternalElementContainerName(NamedElement parent, NamedElement proxied) {
        assert (proxied != null) : "Parameter 'proxied' of method 'getExternalElementContainerName' must not be null";
        String name = proxied.getName();
        if (name.startsWith("./")) {
            name = name.substring("./".length());
        }
        return name;
    }

    public void workspaceFilterApplied(IWorkerContext workerContext, SoftwareSystem softwareSystem) {
        super.workspaceFilterApplied(workerContext, softwareSystem);
    }

    private DeltaDetector createManualDeltaDetector(IWorkerContext workerContext, IWorkspaceFilter filter, Module module, boolean firstModificationOnly) {
        this.initCCSpyDir(module);
        if (this.m_ccspyBean == null) {
            return new CPlusPlusDeltaDetector(workerContext, (ILanguageProvider)this, filter, module, LanguageProvider.getIgnoreDirectories(), firstModificationOnly);
        }
        return new CPlusPlusCCSpyDeltaDetector(workerContext, (ILanguageProvider)this, filter, module, this.m_ccspyBean, (ICPlusPlusSoftwareSystemSettingsProvider)((SoftwareSystem)module.getParent(SoftwareSystem.class, new Class[0])).getExtension(ICPlusPlusSoftwareSystemSettingsProvider.class), firstModificationOnly);
    }

    private DeltaDetector createDeltaDetector(IWorkerContext workerContext, IWorkspaceFilter filter, Module module, PrepareRefreshResult result, boolean firstModificationOnly) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createDeltaDetector' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'createDeltaDetector' must not be null";
        assert (module != null && module instanceof CPlusPlusModule) : "Unexpected class in method 'createDeltaDetector': " + String.valueOf(module);
        DeltaDetector deltaDetector = null;
        switch (((CPlusPlusModule)module).getType()) {
            case MANUAL: {
                deltaDetector = this.createManualDeltaDetector(workerContext, filter, module, firstModificationOnly);
                break;
            }
            case VISUAL_STUDIO_PROJECT_FILE_IMPORT: {
                deltaDetector = new CPlusPlusVsProjectFileBasedModuleDeltaDetector(workerContext, (ILanguageProvider)this, filter, module, firstModificationOnly);
                break;
            }
            case CAPTURE: {
                if (this.m_roots == null) {
                    deltaDetector = new CPlusPlusSourceNodeDeltaDetector(workerContext, (ILanguageProvider)this, filter, module, firstModificationOnly);
                    break;
                }
            }
            case CMAKE_JSON: {
                if (this.m_commandFile == null) {
                    SoftwareSystem system = (SoftwareSystem)module.getParent(SoftwareSystem.class, new Class[0]);
                    Installation installation = ((ISoftwareSystemProvider)system.getExtension(ISoftwareSystemProvider.class)).getInstallation();
                    this.readCommandFile(installation, system);
                }
                if (this.m_roots == null) {
                    result.addError((OperationResult.IMessageCause)CppCauses.CMAKE_COMMAND_FILE_MISSING, "Cannot open or read " + this.m_commandFile.getFile().getNormalizedAbsolutePath(), new Object[0]);
                    result.setParserRefreshPossible(this.getLanguage(), false);
                    return null;
                }
                ICPlusPlusSoftwareSystemSettingsProvider sp = (ICPlusPlusSoftwareSystemSettingsProvider)((SoftwareSystem)module.getParent(SoftwareSystem.class, new Class[0])).getExtension(ICPlusPlusSoftwareSystemSettingsProvider.class);
                deltaDetector = new CPlusPlusCMakeDeltaDetector(workerContext, (ILanguageProvider)this, filter, module, firstModificationOnly, this.m_roots, sp);
                break;
            }
            case UNBOUND: {
                return null;
            }
        }
        assert (deltaDetector != null);
        return deltaDetector;
    }

    private void readCommandFile(Installation installation, SoftwareSystem softwareSystem) {
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        CPlusPlusSystemSettings settings = (CPlusPlusSystemSettings)((Object)workspace.getUniqueExistingChild(CPlusPlusSystemSettings.class));
        this.m_commandFile = (CommandFile)((Object)settings.getUniqueChild(CommandFile.class));
        if (this.m_commandFile != null && this.m_commandFile.getFile().canRead()) {
            ICppImportExtension importer = (ICppImportExtension)installation.getExtension(ICppImportExtension.class);
            this.m_roots = importer.importCommandFile(this.m_commandFile.getFile());
            if (this.m_roots != null) {
                this.m_commandFile.setTimestamp(this.m_commandFile.getFile().lastModified());
            }
        }
    }

    public DeltaDetector createDeltaDetector(IWorkerContext workerContext, IWorkspaceFilter filter, Module module, PrepareRefreshResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createDeltaDetector' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'createDeltaDetector' must not be null";
        assert (module != null && module instanceof CPlusPlusModule) : "Unexpected class in method 'createDeltaDetector': " + String.valueOf(module);
        assert (result != null) : "Parameter 'result' of method 'createDeltaDetector' must not be null";
        return this.createDeltaDetector(workerContext, filter, module, result, false);
    }

    private void initCCSpyDir(Module module) {
        assert (module != null);
        if (!this.m_ccspyInitialized) {
            List<DirectoryBean> dirBeans;
            CCSpyDirectory ccspyDir = (CCSpyDirectory)((Object)((CPlusPlusSystemSettings)((Object)((Workspace)module.getParent(Workspace.class, new Class[0])).getFirstChild(CPlusPlusSystemSettings.class))).getFirstChild(CCSpyDirectory.class));
            this.m_ccspyBean = null;
            if (ccspyDir != null && !(dirBeans = ((ICppImportExtension)this.m_installation.getExtension(ICppImportExtension.class)).readCCSpyDirectory(ccspyDir.getFile(), true)).isEmpty()) {
                this.m_ccspyBean = dirBeans.get(0);
            }
            this.m_ccspyInitialized = true;
        }
    }

    public void aboutToRefreshModules(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result, Set<ISoftwareSystemProvider.IRefreshOption> refreshOptions, List<ModuleDelta> moduleDeltas, IFilePathListener listener) {
        super.aboutToRefreshModules(workerContext, softwareSystem, result, refreshOptions, moduleDeltas, listener);
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToRefreshModules' must not be null";
        assert (this.m_currentRefreshJob == null);
        assert (result != null);
        this.m_currentRefreshJob = new RefreshJob(softwareSystem, this, (ICPlusPlusParserConfigurationProvider)this.m_installation.getExtension(ICPlusPlusParserConfigurationProvider.class), result, moduleDeltas, this.m_diagnosticsDir, refreshOptions.contains((Object)CPlusPlusRefreshOption.EXECUTE_PREPROCESSOR_ONLY));
        this.m_ccspyBean = null;
        this.m_ccspyInitialized = false;
    }

    public boolean finishRefresh(IWorkerContext workerContext, SoftwareSystem system, OperationResult result, boolean systemWillBeCleared) {
        if (this.m_currentRefreshJob != null) {
            if (!systemWillBeCleared) {
                workerContext.setNumberOfSteps(2, new int[]{98, 2});
                workerContext.beginSubTask("Parsing");
                if (!this.m_currentRefreshJob.retrieveParsingResultsAndCreateModel(workerContext, result)) {
                    systemWillBeCleared = true;
                }
                workerContext.endStep();
                workerContext.beginSubTask("Finishing parsing");
                SignatureElement signature = this.getActiveCompilerDefinitionSignature();
                assert (signature != null) : "Signature of active compiler definition must not be null";
                Workspace workspace = (Workspace)system.getUniqueExistingChild(Workspace.class);
                workspace.removeChildren(new Class[]{ActiveDefinitionSignature.class});
                workspace.addChild((NamedElement)new ActiveDefinitionSignature((NamedElement)workspace, signature.getName(), signature.getSignedElementName()));
                Installation installation = ((ISoftwareSystemProvider)system.getExtension(ISoftwareSystemProvider.class)).getInstallation();
                for (CPlusPlusModule module : workspace.getChildren(CPlusPlusModule.class)) {
                    ModuleSettings settings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
                    settings.removeChildren(new Class[]{ModuleSettingsSignature.class});
                    switch (module.getType()) {
                        case VISUAL_STUDIO_PROJECT_FILE_IMPORT: {
                            settings.addChild((NamedElement)CPlusPlusVisualStudioExtension.createSignatureElement((CPlusPlusVsProjectFileBasedModule)module));
                            break;
                        }
                        case CMAKE_JSON: 
                        case CAPTURE: {
                            settings.addChild((NamedElement)CppExtension.createSimpleSignatureElement(installation, module));
                            break;
                        }
                        case MANUAL: {
                            settings.addChild((NamedElement)CPlusPlusWorkspaceExtension.createSignatureElement(installation, module));
                            break;
                        }
                    }
                }
                this.persistActiveCompilerDefinition(system, signature.getSignedElementName());
                workerContext.endSubTask();
            }
            this.m_currentRefreshJob.finishRefresh(workerContext, system, systemWillBeCleared);
            this.m_recreateComponents = false;
            this.m_currentRefreshJob = null;
        }
        return super.finishRefresh(workerContext, system, result, systemWillBeCleared);
    }

    private void persistActiveCompilerDefinition(SoftwareSystem system, String definitionId) {
        assert (system != null) : "Parameter 'system' of method 'persistActiveCompilerDefinition' must not be null";
        assert (definitionId != null && definitionId.length() > 0) : "Parameter 'definitionId' of method 'persistActiveCompilerDefinition' must not be empty";
        system.setSystemProperty(COMPILER_DEF_PROPERTY, definitionId);
    }

    protected void aboutToLoadSoftwareSystem(Properties systemProperties, OperationResult result) {
        OperationResult innerResult;
        String compilerDefId;
        super.aboutToLoadSoftwareSystem(systemProperties, result);
        ICPlusPlusInstallationExtension installationExtension = this.getInstallationExtension();
        if (installationExtension.useCompilerDefintionProperty() && (compilerDefId = systemProperties.getProperty(COMPILER_DEF_PROPERTY)) != null && (innerResult = installationExtension.setActiveCompilerDefinitionId(compilerDefId)).isFailure()) {
            result.addWarning((OperationResult.IMessageCause)CppCauses.COULD_NOT_SWITCH_TO_COMPILER_DEFINITION, String.format("Could not switch to compiler definition '%s'. Active definition is unchanged.", compilerDefId), new Object[0]);
        }
    }

    public long getParsingTime() {
        return this.m_parsingTime;
    }

    public long getBackendTime() {
        return this.m_backendTime;
    }

    private void addParserArtefacts(CategoryProvider categoryProvider) {
        assert (categoryProvider != null) : "Parameter 'categoryProvider' of method 'addParserArtefacts' must not be null";
        categoryProvider.setCategory(CppMacro.class, 7);
        categoryProvider.setCategory(CppMacroInvocation.class, 7);
        categoryProvider.addCategoryAdapter(CppHeaderFile.class, (CategoryProvider.ICategoryAdapter)new CppHeaderFileCategoryAdapter(8));
        categoryProvider.setCategory(CppExternalHeaderFile.class, 8);
        categoryProvider.setCategory(CppSourceFile.class, 10);
        categoryProvider.setCategory(CppClassStructUnionNamespace.class, 11);
        categoryProvider.setCategory(CompilationUnitFragment.class, 12);
        categoryProvider.setCategory(CppClass.class, 13);
        categoryProvider.setCategory(CppClassDeclaration.class, 13);
        categoryProvider.setCategory(CppVariable.class, 14);
        categoryProvider.setCategory(CppFunction.class, 15);
        categoryProvider.setCategory(CppFunctionDeclaration.class, 15);
        categoryProvider.addCategoryAdapter(CppField.class, (CategoryProvider.ICategoryAdapter)new CppFieldCategoryAdapter(16));
        CppMemberFunctionCategoryAdapter cppMemberFunctionCategoryAdapter = new CppMemberFunctionCategoryAdapter(19);
        categoryProvider.addCategoryAdapter(CppMemberFunction.class, (CategoryProvider.ICategoryAdapter)cppMemberFunctionCategoryAdapter);
        categoryProvider.addCategoryAdapter(CppMemberFunctionDeclaration.class, (CategoryProvider.ICategoryAdapter)cppMemberFunctionCategoryAdapter);
        categoryProvider.setCategory(CppEnumeration.class, 22);
        categoryProvider.setCategory(CppUnion.class, 23);
        categoryProvider.setCategory(CppUnionDeclaration.class, 23);
        categoryProvider.setCategory(CppTypedef.class, 24);
        categoryProvider.setCategory(CppStruct.class, 26);
        categoryProvider.setCategory(CppStructDeclaration.class, 26);
    }

    public CategoryProvider getPhysicalCategoryProvider() {
        CategoryProvider categoryProvider = new CategoryProvider();
        categoryProvider.setCategory(CPlusPlusManualModule.class, 1);
        categoryProvider.setCategory(DirectoryPath.class, 2);
        categoryProvider.setCategory(CppComponent.class, 3);
        this.addParserArtefacts(categoryProvider);
        categoryProvider.setCategory(CPlusPlusUnboundComponents.class, 900);
        categoryProvider.setCategory(CPlusPlusExternal.class, 1000);
        return categoryProvider;
    }

    public CategoryProvider getLogicalCategoryProvider() {
        CategoryProvider categoryProvider = new CategoryProvider();
        categoryProvider.setCategory(CppExternalLogicalNamespaceRoot.class, 1000);
        categoryProvider.setCategory(PhysicalElementBasedExternalLogicalRoot.class, 1000);
        categoryProvider.setCategory(CPlusPlusExternal.class, 1000);
        categoryProvider.setCategory(CPlusPlusLogicalModuleNamespace.class, 2);
        categoryProvider.setCategory(CPlusPlusLogicalSystemNamespace.class, 2);
        this.addParserArtefacts(categoryProvider);
        return categoryProvider;
    }

    private InstCompilerDefinition getActiveCompilerDefinition() {
        ICPlusPlusInstallationExtension instProvider = this.getInstallationExtension();
        return instProvider.getActiveCompilerDefinition();
    }

    private SignatureElement getActiveCompilerDefinitionSignature() {
        InstCompilerDefinition activeDef = this.getActiveCompilerDefinition();
        if (activeDef == null) {
            return null;
        }
        SignatureElement signature = (SignatureElement)activeDef.getUniqueChild(CompilerDefinitionSignature.class);
        return signature;
    }

    public void clearSystem(SoftwareSystem softwareSystem, boolean onRefresh) {
        CPlusPlusParserLogSourceRoot root;
        CPlusPlusUnboundComponents unbound;
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'clearSystem' must not be null";
        this.m_recreateComponents = false;
        Workspace ws = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        CPlusPlusInternalHeaders headerRoot = (CPlusPlusInternalHeaders)((Object)ws.getUniqueChild(CPlusPlusInternalHeaders.class));
        if (headerRoot != null) {
            headerRoot.remove();
        }
        if ((unbound = (CPlusPlusUnboundComponents)((Object)ws.getUniqueChild(CPlusPlusUnboundComponents.class))) != null) {
            unbound.remove();
        }
        this.m_currentRefreshJob = null;
        if (!onRefresh && (root = (CPlusPlusParserLogSourceRoot)((Object)ws.getUniqueChild(CPlusPlusParserLogSourceRoot.class))) != null) {
            root.remove();
        }
        super.clearSystem(softwareSystem, onRefresh);
    }

    protected void clearModules(SoftwareSystem softwareSystem, boolean onRefresh) {
        super.clearModules(softwareSystem, onRefresh);
        for (CPlusPlusVsProjectFileBasedModule module : ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(CPlusPlusVsProjectFileBasedModule.class)) {
            SourceFileSettings sourceFileSettings;
            ModuleSettings moduleSettings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
            ModuleSettingsSignatureWithTimestamp signature = (ModuleSettingsSignatureWithTimestamp)moduleSettings.getUniqueChild(ModuleSettingsSignatureWithTimestamp.class);
            if (signature != null) {
                signature.setTimestamp(-1L);
            }
            if ((sourceFileSettings = (SourceFileSettings)((Object)moduleSettings.getUniqueChild(SourceFileSettings.class))) == null) continue;
            sourceFileSettings.remove();
        }
    }

    protected void clearRootDirectoryPath(Module module, RootDirectoryPath rootDir) {
        assert (rootDir != null) : "Parameter 'rootDir' of method 'clearRootDirectoryPath' must not be null";
        for (NamedElement child : new ArrayList(rootDir.getChildren())) {
            if (child instanceof RootDirectorySettings) continue;
            child.remove();
        }
    }

    public void aboutToDeleteWorkspaceElements(IWorkerContext workerContext, SoftwareSystem softwareSystem, Module module, List<NamedElement> workspaceElements) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToDeleteWorkspaceElements' must not be null";
        CPlusPlusInternalHeaders headerRoot = (CPlusPlusInternalHeaders)((Object)((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild(CPlusPlusInternalHeaders.class));
        if (headerRoot != null) {
            headerRoot.remove();
        }
        super.aboutToDeleteWorkspaceElements(workerContext, softwareSystem, module, workspaceElements);
    }

    public void refreshModule(IWorkerContext workerContext, ModuleDelta delta, IFilePathListener listener, OperationResult result) {
        assert (delta != null && !delta.isEmpty()) : "'delta' must not be empty";
        assert (this.m_currentRefreshJob != null);
        this.m_currentRefreshJob.refreshModule(delta, result);
    }

    public Set<IIssueId> getIssueIds() {
        return new HashSet<IIssueId>(Arrays.asList(CPlusPlusIssueId.values()));
    }

    public Set<IConfigurableAnalyzerId> getAnalyzerIds() {
        return new HashSet<IConfigurableAnalyzerId>(Arrays.asList(CPlusPlusAnalyzerId.values()));
    }

    public List<? extends AnalyzerAdapter> getAnalyzerAdapters(IAnalyzerController controller, Set<IConfigurableAnalyzerId> licensedAnalyzerIds) {
        assert (controller != null) : "Parameter 'controller' of method 'getAnalyzerAdapters' must not be null";
        assert (licensedAnalyzerIds != null) : "Parameter 'licensedAnalyzerIds' of method 'getAnalyzerAdapters' must not be null";
        ArrayList<Object> result = new ArrayList<Object>();
        if (licensedAnalyzerIds.contains(CPlusPlusNamespaceCyclesInModuleAnalyzerAdapter.ID)) {
            result.add((Object)new CPlusPlusNamespaceCyclesInModuleAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CPlusPlusNamespaceCyclesInSystemAnalyzerAdapter.ID)) {
            result.add((Object)new CPlusPlusNamespaceCyclesInSystemAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CPlusPlusDirectoryCyclesInModulesAnalyzerAdapter.ID)) {
            result.add((Object)new CPlusPlusDirectoryCyclesInModulesAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CPlusPlusDirectoryCyclesInSystemAnalyzerAdapter.ID)) {
            result.add((Object)new CPlusPlusDirectoryCyclesInSystemAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CPLusPlusNamespaceCyclesInModuleMetricsAnalyzerAdapter.ID)) {
            result.add((Object)new CPLusPlusNamespaceCyclesInModuleMetricsAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CPlusPlusNamespaceCyclesInSystemMetricsAnalyzerAdapter.ID)) {
            result.add((Object)new CPlusPlusNamespaceCyclesInSystemMetricsAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CPlusPlusDirectoryCyclesInModulesMetricAnalyzerAdapter.ID)) {
            result.add((Object)new CPlusPlusDirectoryCyclesInModulesMetricAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CPlusPlusDirectoryCyclesInSystemMetricsAnalyzerAdapter.ID)) {
            result.add((Object)new CPlusPlusDirectoryCyclesInSystemMetricsAnalyzerAdapter(controller));
        }
        return result;
    }

    public FilePath getSourceFile(NamedElement element) {
        assert (element != null) : "Parameter 'namedElement' of method 'getSourceFile' must not be null";
        assert (element.isValid()) : "Not a valid element: " + String.valueOf(element);
        if (element instanceof CompilationUnitFragment) {
            CompilationUnitFragment compilationUnitFragment = (CompilationUnitFragment)element;
            return compilationUnitFragment.getAssociatedHeader();
        }
        if (element instanceof CppClassStructUnionNamespace) {
            CppClassStructUnion referencedType = ((CppClassStructUnionNamespace)element).getReferencedType();
            if (referencedType != null) {
                return super.getSourceFile((NamedElement)referencedType);
            }
        } else if (element instanceof CppParserLogSourceFile) {
            return (FilePath)element;
        }
        return super.getSourceFile(element);
    }

    private ICPlusPlusInstallationExtension getInstallationExtension() {
        assert (this.m_installation != null) : "'m_installation' of method 'getInstallationExtension' must not be null";
        return (ICPlusPlusInstallationExtension)this.m_installation.getExtension(ICPlusPlusInstallationExtension.class);
    }

    public boolean prepareRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem, PrepareRefreshResult result) {
        List modules;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareRefresh' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'isRefreshPossible' must not be null";
        assert (result != null) : "Parameter 'result' of method 'isRefreshPossible' must not be null";
        ICPlusPlusInstallationExtension instProvider = this.getInstallationExtension();
        InstCompilerDefinition activeDef = instProvider.getActiveCompilerDefinition();
        if (activeDef == null) {
            result.addError((OperationResult.IMessageCause)RefreshMessageCause.NO_ACTIVE_COMPILER_DEFINITION_FOUND);
            result.setParserRefreshPossible(this.getLanguage(), false);
            return false;
        }
        if (activeDef.hasIssues(Severity.ERROR)) {
            result.addError((OperationResult.IMessageCause)RefreshMessageCause.ACTIVE_COMPILER_DEFINITION_HAS_ERRORS, "Active compiler definition: " + activeDef.getName(), new Object[0]);
            result.setParserRefreshPossible(this.getLanguage(), false);
            return false;
        }
        List<Module> modulesWithIssues = ((ICPlusPlusWorkspaceExtension)softwareSystem.getExtension(ICPlusPlusWorkspaceExtension.class)).validateModulesConfiguration(result);
        CPlusPlusSystemSettings systemSettings = (CPlusPlusSystemSettings)((Object)((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild(CPlusPlusSystemSettings.class));
        List issues = systemSettings.getIssues();
        if (issues.size() > 0) {
            result.addError((OperationResult.IMessageCause)RefreshMessageCause.SYSTEM_SETTINGS_HAVE_ERRRORS);
        }
        long aboutToBeDeletedModules = result.getAboutToBeDeletedElements().stream().filter(e -> e instanceof CPlusPlusModule).count();
        long numberOfRemainingModules = (long)((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(CPlusPlusModule.class).size() - aboutToBeDeletedModules;
        result.setParserRefreshPossible(this.getLanguage(), numberOfRemainingModules > 0L && modulesWithIssues.isEmpty() && issues.isEmpty());
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        CPlusPlusSystemSettings settings = (CPlusPlusSystemSettings)((Object)workspace.getUniqueChild(CPlusPlusSystemSettings.class));
        if (settings != null) {
            if (this.m_commandFile != null && this.m_commandFile.getFile().canRead() && this.m_commandFile.isModified()) {
                Installation inst = ((ISoftwareSystemProvider)softwareSystem.getExtension(ISoftwareSystemProvider.class)).getInstallation();
                ICppImportExtension importer = (ICppImportExtension)inst.getExtension(ICppImportExtension.class);
                this.m_roots = importer.importCommandFile(this.m_commandFile.getFile());
                if (this.m_roots != null) {
                    this.m_commandFile.setTimestamp(this.m_commandFile.getFile().lastModified());
                }
            }
            if (this.m_commandFile != null && this.m_roots == null) {
                result.addError((OperationResult.IMessageCause)RefreshMessageCause.CANNOT_READ_COMMANDFILE, "Could not read compile commands from " + this.m_commandFile.getName(), new Object[0]);
                return false;
            }
        }
        if (!softwareSystem.needsReparse() && softwareSystem.isClearable() && !(modules = workspace.getChildren(CPlusPlusModule.class)).isEmpty()) {
            WorkspaceFilter workspaceFilter = workspace.getWorkspaceFilter();
            PrepareRefreshWorkspaceFilter prepareRefreshWorkspaceFilter = new PrepareRefreshWorkspaceFilter(workspaceFilter.isEnabled());
            for (WildcardPatternInclude nextInclude : workspaceFilter.getChildren(WildcardPatternInclude.class)) {
                prepareRefreshWorkspaceFilter.addChild((NamedElement)new WildcardPatternInclude((NamedElement)prepareRefreshWorkspaceFilter, nextInclude.getName()));
            }
            for (WildcardPatternExclude nextExclude : workspaceFilter.getChildren(WildcardPatternExclude.class)) {
                prepareRefreshWorkspaceFilter.addChild((NamedElement)new WildcardPatternExclude((NamedElement)prepareRefreshWorkspaceFilter, nextExclude.getName()));
            }
            OperationResult operationResult = new OperationResult("Prepare Refresh Detection Result");
            PrepareRefreshWorkerContext prepareRefreshWorkerContext = new PrepareRefreshWorkerContext(workerContext);
            for (CPlusPlusModule nextModule : modules) {
                ModuleDelta nextModuleDelta;
                DeltaDetector nextDeltaDetector = this.createDeltaDetector(prepareRefreshWorkerContext, prepareRefreshWorkspaceFilter, nextModule, result, true);
                if (nextDeltaDetector == null || (nextModuleDelta = nextDeltaDetector.detectDelta((IWorkerContext)prepareRefreshWorkerContext, operationResult, false)).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public void accept(ISourceFileRegionVisitor visitor, String content, IFileType fileType) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        assert (content != null) : "Parameter 'content' of method 'accept' must not be null";
        new SourceLineProcessor().accept(content, this.prepareSourceLineVisitor(visitor, fileType));
    }

    private ISourceLineProcessor.SourceLineVisitor prepareSourceLineVisitor(ISourceFileRegionVisitor visitor, IFileType fileType) {
        return new CppSourceVisitor(visitor, fileType);
    }

    public IAdditionalFileInfoProvider getPersistenceProvider(Installation installation) {
        return new CPlusPlusPersistenceProvider(installation);
    }

    public IProviderId getProviderId() {
        return CPlusPlusProviderId.INSTANCE;
    }

    private void cleanUpDiagnosticsDir() {
        assert (this.m_diagnosticsDir != null) : "diagnostics directory must not be null";
        TFile[] files = this.m_diagnosticsDir.listFiles();
        if (files != null) {
            int dateLength = "yyyy-MM-dd".length();
            TFile[] tFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                TFile file = tFileArray[n2];
                if (file.isDirectory() && file.getName().length() > dateLength) {
                    String datePartOfName = file.getName().substring(0, dateLength);
                    Date date = Iso8601DateFormat.parseDate((String)datePartOfName);
                    Date today = new Date();
                    if (date != null && today.getTime() - date.getTime() > 604800000L) {
                        try {
                            file.rm_r();
                        }
                        catch (IOException e) {
                            LOGGER.error(String.format("Cannot remove C++ diagnostics dir '%s'", file.getName()), (Throwable)e);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public void initialize(Installation installation, IFinishModelProcessor finishModelProcessor) {
        super.initialize(installation, finishModelProcessor);
        installation.addExtension((Extension)new CPlusPlusInstallationExtension(installation, this.m_cppHomeDir, this.m_generatedCompilerDefinitionPath));
        installation.addExtension((Extension)new CPlusPlusVisualStudioSolutionFileImportExtension());
        installation.addExtension((Extension)new CppImportExtension(installation, finishModelProcessor));
        installation.addExtension((Extension)new CaptureExtension());
        installation.addExtension((Extension)new CPlusPlusParserConfigurationExtension(this.m_cppHomeDir));
        if (Platform.isWindows()) {
            installation.addExtension((Extension)new VisualStudioInstallationsExtension(installation, this.m_cppHomeDir));
        }
        this.m_installation = installation;
        this.cleanUpDiagnosticsDir();
    }

    public void initialize(SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor) {
        super.initialize(softwareSystem, finishModelProcessor);
        softwareSystem.addExtension((Extension)new CPlusPlusSoftwareSystemSettingsExtension(this.m_installation, softwareSystem, this.getInstallationExtension(), finishModelProcessor, this));
        softwareSystem.addExtension((Extension)new CPlusPlusVisualStudioExtension(softwareSystem, finishModelProcessor));
        softwareSystem.addExtension((Extension)new CPlusPlusWorkspaceExtension(softwareSystem));
        softwareSystem.addExtension((Extension)new CPlusPlusExportExtension());
        ComponentAssignmentExtension componentAssignmentExtension = new ComponentAssignmentExtension(softwareSystem, finishModelProcessor);
        softwareSystem.addExtension((Extension)componentAssignmentExtension);
        finishModelProcessor.addListener((ISoftwareSystemLifecycleListener)componentAssignmentExtension);
    }

    public void applyInstallationParameters(Map<String, String> instSpecificParameters, OperationResult result) {
        assert (instSpecificParameters != null && !instSpecificParameters.isEmpty()) : "Parameter 'instSpecificParameters' of method 'applyInstallationParameters' must not be null";
        assert (result != null) : "Parameter 'result' of method 'applyInstallationParameters' must not be null";
        String activeCompilerDefinitionPath = instSpecificParameters.get(PARAM_COMPILER_DEFINITION_PATH);
        if (activeCompilerDefinitionPath == null) {
            return;
        }
        if (activeCompilerDefinitionPath.trim().isEmpty()) {
            LOGGER.info("Nothing to do, 'compilerDefinitionPath' is empty");
            return;
        }
        CPlusPlusInstallationExtension instExtension = (CPlusPlusInstallationExtension)this.m_installation.getExtension(CPlusPlusInstallationExtension.class);
        instExtension.setActiveCompilerDefinition(activeCompilerDefinitionPath.trim(), result);
        String numberOfDaemonsVal = instSpecificParameters.get(PARAM_NUMBER_OF_DAEMONS);
        String daemonStackSizeVal = instSpecificParameters.get(PARAM_DAEMON_STACK_SIZE);
        int numberOfDaemons = 8;
        int daemonStackSize = 1;
        if (numberOfDaemonsVal != null) {
            numberOfDaemons = Integer.valueOf(numberOfDaemonsVal);
        }
        if (daemonStackSizeVal != null) {
            daemonStackSize = Integer.valueOf(daemonStackSizeVal);
        }
        ((ICPlusPlusParserConfigurationExtension)this.m_installation.getExtension(ICPlusPlusParserConfigurationExtension.class)).configureParser(null, numberOfDaemons, daemonStackSize, false);
    }

    public LogicalNamespaceRoot createLogicalNamespaceRoot(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createLogicalNamespaceRoot' must not be null";
        return new CppLogicalNamespaceRoot(parent);
    }

    public ExternalLogicalNamespaceRoot createExternalLogicalNamespaceRoot(NamedElement parent, NamedElement external, LogicalNamespaceScope scope) {
        assert (parent != null) : "Parameter 'parent' of method 'createExternalLogicalNamespaceRoot' must not be null";
        assert (external != null) : "Parameter 'external' of method 'createExternalLogicalNamespaceRoot' must not be null";
        return new CppExternalLogicalNamespaceRoot(parent, external, scope);
    }

    public void aboutToCreateFirstModule(SoftwareSystem softwareSystem) {
        super.aboutToCreateFirstModule(softwareSystem);
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        assert (!workspace.hasChildren(false, new Class[]{CPlusPlusExternal.class})) : "Already created external node";
        workspace.addChild((NamedElement)new CPlusPlusExternal((NamedElement)workspace));
        if (workspace.getUniqueChild(CPlusPlusSystemSettings.class) == null) {
            workspace.addChild((NamedElement)new CPlusPlusSystemSettings((NamedElement)workspace));
        }
        CPlusPlusSoftwareSystemSettingsExtension.aboutToCreateFirstModule(workspace);
    }

    public void lastModuleDeleted(SoftwareSystem softwareSystem) {
        super.lastModuleDeleted(softwareSystem);
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        workspace.removeChildren(new Class[]{ActiveDefinitionSignature.class});
        workspace.removeChildren(new Class[]{CPlusPlusParserLogSourceRoot.class});
        workspace.removeChildren(new Class[]{CPlusPlusInternalHeaders.class});
        workspace.removeChildren(new Class[]{CPlusPlusSystemSettings.class});
        workspace.removeChildren(new Class[]{CPlusPlusUnboundComponents.class});
        ((CPlusPlusExternal)((Object)workspace.getUniqueExistingChild(CPlusPlusExternal.class))).remove();
        this.m_roots = null;
        this.m_commandFile = null;
        CPlusPlusSoftwareSystemSettingsExtension.lastModuleDeleted(workspace);
    }

    public void softwareSystemClosed(SoftwareSystem softwareSystem) {
        this.m_roots = null;
        this.m_commandFile = null;
        super.softwareSystemClosed(softwareSystem);
    }

    protected Module.IModuleType getModuleType(String moduleTypeStandardName) {
        assert (moduleTypeStandardName != null) : "Parameter 'moduleTypeStandardName' of method 'getModuleType' must not be null";
        CPlusPlusModuleType moduleType = null;
        try {
            moduleType = CPlusPlusModuleType.fromStandardName(moduleTypeStandardName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return moduleType;
    }

    protected Module createModule(SoftwareSystem softwareSystem, Module.IModuleType type, String id, String name, String description) {
        assert (softwareSystem != null) : "Parameter 'system' of method 'createSpecificModule' must not be null";
        assert (type != null) : "Parameter 'type' of method 'createSpecificModule' must not be null";
        assert (type instanceof CPlusPlusModuleType) : "Not a C++ module type: " + type.getClass().getSimpleName();
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createSpecificModule' must not be empty";
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'createModule' must not be empty";
        CPlusPlusModule module = null;
        if (type == CPlusPlusModuleType.MANUAL) {
            module = new CPlusPlusManualModule((NamedElement)softwareSystem.getUniqueExistingChild(Workspace.class), name, id);
            SettingsBuilder settingsBuilder = new SettingsBuilder((NamedElement)module);
            module.addChild(settingsBuilder.create());
        } else if (type == CPlusPlusModuleType.VISUAL_STUDIO_PROJECT_FILE_IMPORT) {
            module = new CPlusPlusVsProjectFileBasedModule((NamedElement)softwareSystem.getUniqueExistingChild(Workspace.class), name, id);
            module.addChild((NamedElement)new ModuleSettings((NamedElement)module));
        } else if (type == CPlusPlusModuleType.CMAKE_JSON) {
            module = new CPlusPlusCMakeJsonModule((NamedElement)softwareSystem.getUniqueExistingChild(Workspace.class), name, id);
            module.addChild((NamedElement)new ModuleSettings((NamedElement)module));
        } else if (type == CPlusPlusModuleType.CAPTURE) {
            module = new CPlusPlusCaptureModule((NamedElement)softwareSystem.getUniqueExistingChild(Workspace.class), name, id);
            module.addChild((NamedElement)new ModuleSettings((NamedElement)module));
        } else assert (false) : "Module type '" + String.valueOf(type) + "' is not supported.";
        assert (module != null);
        if (description != null) {
            module.setDescription(description);
        }
        ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).addChild((NamedElement)module);
        return module;
    }

    public boolean hasInstallationConfigurationChanged(SoftwareSystem systemFromSnapshot, OperationResult result) {
        assert (systemFromSnapshot != null) : "Parameter 'systemFromSnapshot' of method 'hasInstallationConfigurationChanged' must not be null";
        assert (result != null) : "Parameter 'result' of method 'hasInstallationConfigurationChanged' must not be null";
        ActiveDefinitionSignature signatureFromSnapshot = (ActiveDefinitionSignature)((Object)((Workspace)systemFromSnapshot.getUniqueExistingChild(Workspace.class)).getUniqueChild(ActiveDefinitionSignature.class));
        if (signatureFromSnapshot == null) {
            return true;
        }
        SignatureElement signatureFromInstallation = this.getActiveCompilerDefinitionSignature();
        if (signatureFromInstallation == null) {
            return true;
        }
        return !signatureFromInstallation.getName().equals(signatureFromSnapshot.getName());
    }

    public void finishSaveSoftwareSystemAs(Installation installation, SoftwareSystem softwareSystem) {
        assert (installation != null) : "Parameter 'installation' of method 'finishSaveSoftwareSystemAs' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishSaveSoftwareSystemAs' must not be null";
        SaveAsVisitor visitor = new SaveAsVisitor();
        ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).accept((NamedElement.INamedElementVisitor)visitor);
    }

    public void finishLoadFromPersistence(Installation installation, SoftwareSystem softwareSystem, OperationResult result, boolean snapshotMode) {
        assert (installation != null) : "Parameter 'installation' of method 'finishLoadFromPersistence' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishLoadFromPersistence' must not be null";
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        if (workspace.getUniqueChild(CPlusPlusSystemSettings.class) == null) {
            workspace.addChild((NamedElement)new CPlusPlusSystemSettings((NamedElement)workspace));
        }
        for (CPlusPlusModule module : workspace.getChildren(CPlusPlusManualModule.class)) {
            CPlusPlusWorkspaceExtension.finishModuleCreation(this.m_installation, module);
        }
        for (CPlusPlusModule module : workspace.getChildren(CPlusPlusVsProjectFileBasedModule.class)) {
            CPlusPlusVisualStudioExtension.finishModuleCreation(this.m_installation, softwareSystem, (CPlusPlusVsProjectFileBasedModule)module);
        }
        if (!snapshotMode) {
            this.readCommandFile(installation, softwareSystem);
        }
    }

    private boolean updateAssociatedHeaders(CPlusPlusModule sourceModule, CPlusPlusModule targetModule, EnumSet<Modification> modifications) {
        if (!targetModule.getManuallyAssociatedHeaders().equals(sourceModule.getManuallyAssociatedHeaders())) {
            targetModule.clearAssociatedHeaders();
            for (TFile header : sourceModule.getManuallyAssociatedHeaders()) {
                targetModule.assignAssociatedHeader(header);
            }
            modifications.add(Modification.WORKSPACE_MODIFIED);
            return true;
        }
        return false;
    }

    protected void checkSoftwareSystemSettings(Workspace sourceWorkspace, Workspace targetWorkspace, OperationResult result) {
        assert (sourceWorkspace != null) : "Parameter 'sourceWorkspace' of method 'doSoftwareSystemSettingsMatch' must not be null";
        assert (targetWorkspace != null) : "Parameter 'targetWorkspace' of method 'doSoftwareSystemSettingsMatch' must not be null";
        assert (result != null) : "Parameter 'result' of method 'doSoftwareSystemSettingsMatch' must not be null";
        if (!CPlusPlusSoftwareSystemSettingsExtension.doSoftwareSystemSettingsMatch(sourceWorkspace, targetWorkspace, result)) {
            LOGGER.debug("Recreate components needed due to unbound external filter change");
            this.m_recreateComponents = true;
        }
    }

    protected EnumSet<Modification> moveSoftwareSystemElements(Workspace sourceWorkspace, Workspace targetWorkspace) {
        EnumSet modifications = super.moveSoftwareSystemElements(sourceWorkspace, targetWorkspace);
        for (CPlusPlusModule nextSourceModule : sourceWorkspace.getChildren(CPlusPlusModule.class)) {
            CPlusPlusModule targetModule = (CPlusPlusModule)((Object)targetWorkspace.getUniqueChild((NamedElement.IFilter)new NameFilter(nextSourceModule.getName()), CPlusPlusModule.class));
            if (targetModule == null) continue;
            if (nextSourceModule instanceof CPlusPlusVsProjectFileBasedModule) {
                CPlusPlusVisualStudioExtension.moveElements((CPlusPlusVsProjectFileBasedModule)nextSourceModule, (CPlusPlusVsProjectFileBasedModule)targetModule);
                this.m_recreateComponents = this.m_recreateComponents || this.updateAssociatedHeaders(nextSourceModule, targetModule, modifications);
                continue;
            }
            if (nextSourceModule instanceof CPlusPlusCaptureModule) {
                CaptureExtension.moveElements(nextSourceModule, targetModule);
                this.m_recreateComponents = this.m_recreateComponents || this.updateAssociatedHeaders(nextSourceModule, targetModule, modifications);
                continue;
            }
            if (nextSourceModule instanceof CPlusPlusCMakeJsonModule) {
                CppImportExtension.moveElements(nextSourceModule, targetModule);
                this.m_recreateComponents = this.m_recreateComponents || this.updateAssociatedHeaders(nextSourceModule, targetModule, modifications);
                continue;
            }
            ModuleSettings sourceSettings = (ModuleSettings)nextSourceModule.getUniqueChild(ModuleSettings.class);
            ModuleSettings targetSettings = (ModuleSettings)targetModule.getUniqueChild(ModuleSettings.class);
            targetModule.removeChild((NamedElement)targetSettings);
            sourceSettings.changeParent((NamedElement)targetModule, true);
            SourceFileSettings sourceFileSettingsFromSource = (SourceFileSettings)((Object)nextSourceModule.getUniqueChild(SourceFileSettings.class));
            SourceFileSettings sourceFileSettingsFromTarget = (SourceFileSettings)((Object)targetModule.getUniqueChild(SourceFileSettings.class));
            if (sourceFileSettingsFromTarget != null) {
                targetModule.removeChild((NamedElement)sourceFileSettingsFromTarget);
            }
            if (sourceFileSettingsFromSource != null) {
                sourceFileSettingsFromSource.changeParent((NamedElement)targetModule, true);
            }
            boolean bl = this.m_recreateComponents = this.m_recreateComponents || this.updateAssociatedHeaders(nextSourceModule, targetModule, modifications);
        }
        CPlusPlusSystemSettings sourceSystemSettings = (CPlusPlusSystemSettings)((Object)sourceWorkspace.getUniqueChild(CPlusPlusSystemSettings.class));
        assert (sourceSystemSettings != null) : "CPlusPlusSystemSettings from sourceWorkspace must not be null";
        CPlusPlusSystemSettings targetSystemSettings = (CPlusPlusSystemSettings)((Object)targetWorkspace.getUniqueChild(CPlusPlusSystemSettings.class));
        if (targetSystemSettings != null) {
            targetSystemSettings.remove();
        }
        sourceSystemSettings.changeParent((NamedElement)targetWorkspace, true);
        return modifications;
    }

    public void finishApplySnapshot(IWorkerContext workerContext, SoftwareSystem softwareSystem, IFilePathListener listener) {
        super.finishApplySnapshot(workerContext, softwareSystem, listener);
        if (this.m_recreateComponents) {
            workerContext.working("Re-create components", true);
            LOGGER.debug("Recreate components on apply snapshot");
            ComponentAnalyzer.recreateComponents(softwareSystem);
            LOGGER.debug("Recreate components on apply snapshot - done");
            this.m_recreateComponents = false;
        }
    }

    public void finishSystemFilesRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem, EnumSet<Modification> modifications) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishSystemFilesRefresh' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishSystemFilesRefresh' must not be null";
        if (this.m_recreateComponents) {
            workerContext.working("Re-create components", true);
            LOGGER.debug("Recreate components on system files refresh");
            ComponentAnalyzer.recreateComponents(softwareSystem);
            LOGGER.debug("Recreate components on system files refresh - done");
            this.m_recreateComponents = false;
            if (modifications != null) {
                modifications.add(Modification.WORKSPACE_MODIFIED);
            }
        }
    }

    protected Class<? extends External> getExternalClass() {
        return CPlusPlusExternal.class;
    }

    protected Class<? extends Module> getModuleClass() {
        return CPlusPlusModule.class;
    }

    protected RelevantSourceLinesScanner.ScannerInfo getScannerInfo() {
        return new RelevantSourceLinesScanner.ScannerInfo(IMPORT_START_TOKENS);
    }

    protected List<IStructureItem> getPhysicalStructureItems() {
        return Arrays.asList(CPlusPlusStructureItem.values());
    }

    protected boolean setNeedsReparseOnWorkspaceModification(WorkspaceModification modification) {
        assert (modification != null) : "Parameter 'modification' of method 'setNeedsReparseOnWorkspaceModification' must not be null";
        switch (modification) {
            case MODULE_ORDER_MODIFIED: 
            case ROOT_DIRECTORY_ORDER_MODIFIED: 
            case ROOT_DIRECTORY_CREATED: 
            case MODULE_DEPENDENCY_CREATED: 
            case MODULE_DEPENDENCY_DELETED: {
                return false;
            }
        }
        return true;
    }

    public boolean isSuitableForIncludeDependenciesGraph(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'isSuitableForIncludeDependenciesGraph' must not be null";
        return namedElement instanceof CppSourceFile || namedElement instanceof CompilationUnitFragment;
    }

    protected CoreAccess getSystemAccess(Installation installation, SoftwareSystem system, IMetricIdProvider metricIdProvider, ScriptApi api) {
        assert (installation != null) : "Parameter 'installation' of method 'getSystemAccess' must not be null";
        assert (system != null) : "Parameter 'system' of method 'getSystemAccess' must not be null";
        return new CppAccess(installation, system, metricIdProvider, api);
    }

    public LogicalSystemNamespace createLogicalSystemNamespace(NamedElement parent, String name) {
        return new CPlusPlusLogicalSystemNamespace(parent, name);
    }

    public LogicalModuleNamespace createLogicalModuleNamespace(NamedElement parent, String name) {
        return new CPlusPlusLogicalModuleNamespace(parent, name);
    }

    public WorkspaceDependency createWorkspaceDependency(SoftwareSystem softwareSystem, IWorkspaceDependencyElement from, String toId, String toName, String type, WorkspaceDependency.AdditionalDependencyData dependencyData) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createWorkspaceDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'createWorkspaceDependency' must not be null";
        assert (toId != null && toId.length() > 0) : "Parameter 'toId' of method 'createWorkspaceDependency' must not be empty";
        assert (toName != null && toName.length() > 0) : "Parameter 'toName' of method 'createWorkspaceDependency' must not be empty";
        assert (type != null && type.length() > 0) : "Parameter 'type' of method 'createWorkspaceDependency' must not be empty";
        assert (dependencyData != null) : "Parameter 'dependencyData' of method 'createWorkspaceDependency' must not be null";
        CPlusPlusWorkspaceDependency.DependencyType dependencyType = this.getWorkspaceDependencyType(type);
        if (dependencyType == null) {
            LOGGER.error("Dependency type '{}' is not valid", (Object)type);
            return null;
        }
        CPlusPlusWorkspaceDependency.DependencyType cppDependencyType = dependencyType;
        IWorkspaceDependencyElement endpoint = this.findWorkspaceDependencyElement((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class), from, cppDependencyType, toId, toName, dependencyData, false);
        WorkspaceDependency workspaceDependency = CPlusPlusWorkspaceExtension.createWorkspaceDependency(from, endpoint, toId, toName, cppDependencyType, dependencyData);
        return workspaceDependency;
    }

    private CPlusPlusWorkspaceDependency.DependencyType getWorkspaceDependencyType(String workspaceDependencyStandardName) {
        assert (workspaceDependencyStandardName != null) : "Parameter 'workspaceDependencyStandardName' of method 'getWorkspaceDependencyType' must not be null";
        CPlusPlusWorkspaceDependency.DependencyType dependencyType = null;
        try {
            dependencyType = CPlusPlusWorkspaceDependency.DependencyType.fromStandardName(workspaceDependencyStandardName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return dependencyType;
    }

    public String getBundleId() {
        return "com.hello2morrow.sonargraph.language.provider.cplusplus";
    }

    public TFile getDiagnosticsDir() {
        return this.m_diagnosticsDir;
    }

    public LanguageProviderRefactoringAdapter getRefactoringAdapter() {
        return this.m_refactoringAdapter;
    }

    public CPlusPlusRefactoringDescriptorProvider getRefactoringDescriptorProvider() {
        return new CPlusPlusRefactoringDescriptorProvider();
    }

    public List<IAssignableAttributeRetriever> createAssignableAttributeRetrievers() {
        return Arrays.asList(new IAssignableAttributeRetriever[]{new CppExtendsClassRetriever(), new CppHeaderPathRetriever()});
    }

    public IMetricLevel getNamespaceMetricLevel() {
        return CPlusPlusMetricLevel.CPP_NAMESPACE;
    }

    public IMetricId getNamespacesMetricId() {
        return CPlusPlusMetricId.CPP_NAMESPACES;
    }

    public Set<RelativeCyclicityMetricIds> getRelativeCyclicityMetricIds() {
        return Set.of(new RelativeCyclicityMetricIds((IMetricId)CPlusPlusMetricId.CPP_DIRECTORIES_FULLY_ANALYZED, (IMetricId)CPlusPlusMetricId.CPP_RELATIVE_CYCLICITY_DIRECTORIES, (IMetricId)CPlusPlusMetricId.CPP_AVERAGE_RELATIVE_CYCLICITY_DIRECTORIES), new RelativeCyclicityMetricIds((IMetricId)CPlusPlusMetricId.CPP_NAMESPACES_FULLY_ANALYZED, (IMetricId)CPlusPlusMetricId.CPP_RELATIVE_CYCLICITY_NAMESPACES, (IMetricId)CPlusPlusMetricId.CPP_AVERAGE_RELATIVE_CYCLICITY_NAMESPACES));
    }

    public IMetricId getFullyAnalyzedNamespacesMetricId() {
        return CPlusPlusMetricId.CPP_NAMESPACES_FULLY_ANALYZED;
    }

    public IMetricLevel getDirectoryMetricLevel() {
        return CPlusPlusMetricLevel.CPP_DIRECTORY;
    }

    public IMetricId getDirectoriesMetricId() {
        return CPlusPlusMetricId.CPP_DIRECTORIES;
    }

    public IMetricId getFullyAnalyzedDirectoriesMetricId() {
        return CPlusPlusMetricId.CPP_DIRECTORIES_FULLY_ANALYZED;
    }

    @Override
    public AssignableToArtifactRefactoringDescriptor getPhysicalAssignableToArtifactRefactoringDescriptor(IModelServiceProvider msp) {
        return this.getRefactoringDescriptorProvider().getPhysicalAssignableToArtifactRefactoringDescriptor(msp);
    }

    public Collection<String> getSourceExtensions() {
        String ext;
        ArrayList<String> extensions = new ArrayList<String>();
        String[] stringArray = CPlusPlusFileType.C_SOURCE.getExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            ext = stringArray[n2];
            extensions.add(ext);
            ++n2;
        }
        stringArray = CPlusPlusFileType.CPP_SOURCE.getExtensions();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            ext = stringArray[n2];
            extensions.add(ext);
            ++n2;
        }
        stringArray = CPlusPlusFileType.HEADER_FILE.getExtensions();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            ext = stringArray[n2];
            extensions.add(ext);
            ++n2;
        }
        return extensions;
    }

    public IMetricAwareLanguageProvider.IWeightedAverageCalculator createWeightedAverageCalculator() {
        return new CPlusPlusAverageComplexityCalculator();
    }

    @Override
    public void unboundExternalFilterModified() {
        LOGGER.debug("Recreate components needed due to unbound external filter modification");
        this.m_recreateComponents = true;
    }

    public boolean delayedParsing() {
        return true;
    }

    public void addPluginAccess(Installation installation, SoftwareSystem softwareSystem, Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess> access) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'addPluginAccess' must not be null";
        assert (access != null) : "Parameter 'access' of method 'addPluginAccess' must not be null";
        access.put(IPluginCppAccess.class, (IPluginCoreAccess)new PluginCppAccess(installation, softwareSystem));
    }

    public boolean moduleOrderIsRelevant() {
        return false;
    }

    private static class CppSourceVisitor
    extends ISourceLineProcessor.SourceLineVisitor {
        private final ISourceFileRegionVisitor m_visitor;
        private final String[] m_keywords;

        private CppSourceVisitor(ISourceFileRegionVisitor visitor, IFileType fileType) {
            this.m_visitor = visitor;
            this.m_keywords = fileType == CPlusPlusFileType.C_SOURCE ? C_KEYWORDS : CPP_KEYWORDS;
        }

        public void visitCharLiteral(int offset, String c) {
            assert (c != null) : "Parameter 'c' of method 'visitCharLiteral' must not be null";
            this.m_visitor.visitLiteral(offset, c.length());
        }

        public void visitStringLiteral(int offset, String s) {
            assert (s != null) : "Parameter 's' of method 'visitStringLiteral' must not be null";
            this.m_visitor.visitLiteral(offset, s.length());
        }

        public void visitSingleLineComment(int offset, String comment) {
            assert (comment != null) : "Parameter 'comment' of method 'visitSingleLineComment' must not be null";
            this.m_visitor.visitComment(offset, comment.length());
        }

        public void visitMultiLineComment(int offset, String comment) {
            assert (comment != null) : "Parameter 'comment' of method 'visitMultiLineComment' must not be null";
            this.m_visitor.visitComment(offset, comment.length());
        }

        public void visitWord(int offset, String word) {
            if (Arrays.binarySearch(this.m_keywords, word) >= 0) {
                this.m_visitor.visitKeyword(offset, word.length());
            }
        }

        public void visitNumberSign(int offset, String numberWord) {
            assert (numberWord != null) : "Parameter 'numberWord' of method 'visitNumberSign' must not be null";
            if (Arrays.binarySearch(PREPROCESSOR_DIRECTIVES, numberWord.substring(1)) >= 0) {
                this.m_visitor.visitKeyword(offset, numberWord.length());
            }
        }
    }
}

