/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ICompilationUnitContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.IElementProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDG;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDGVisitor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFlags;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFunctionSpec;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFunctionWithBody;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppSourceFileElement;
import java.util.HashMap;
import java.util.Map;

abstract class ElementProcessor
implements IElementProcessor {
    protected final String ERROR = "<error>";
    private final ICompilationUnitContext m_Context;
    private final IElementProcessor m_ParentProcessor;
    private final Map<Long, CppElement> m_routineLocations = new HashMap<Long, CppElement>();

    protected ICompilationUnitContext getContext() {
        return this.m_Context;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    protected String getElementName(EDG.SourceCorrespondence sc) {
        if (sc.unnamedEntityGivenFabricatedName()) {
            return "";
        }
        if (sc.nameHasBeenMangled()) {
            return sc.unmangledNameOrMangledEncoding();
        }
        String name = sc.name();
        if (name == null) {
            name = "";
        }
        return name;
    }

    protected boolean reportMappingFailures() {
        return true;
    }

    protected ElementProcessor(ICompilationUnitContext context) {
        this.m_Context = context;
        this.m_ParentProcessor = null;
    }

    protected ElementProcessor(ICompilationUnitContext context, IElementProcessor parentProcessor) {
        this.m_Context = context;
        this.m_ParentProcessor = parentProcessor;
    }

    protected void markHeaderAsCPlusPlus(CppProgrammingElement cppElement) {
        CppSourceFileElement src = cppElement.getSource();
        src.markAsCpp();
    }

    @Override
    public CppElement getParentFor(EDG.Position pos) {
        return this.m_ParentProcessor != null ? this.m_ParentProcessor.getParentFor(pos) : null;
    }

    public CppFunctionSpec createRoutineImp(CppElement parent, String name, int lineNumber, boolean isDefined, short noTemplateArgs) {
        CppFunctionSpec result;
        if (isDefined) {
            result = new CppFunctionWithBody(parent, CppElementType.FUNCTION, name, lineNumber);
            result.addFlag(CppFlags.DEFINITION);
        } else {
            result = new CppFunctionSpec(parent, CppElementType.FUNCTION, name, lineNumber);
            result.addFlag(CppFlags.DECLARATION);
        }
        result.setNamespace(this.getNamespace(), this.isAnonymousNamespace());
        return result;
    }

    @Override
    public final CppFunctionSpec createRoutine(CppElement parent, String name, int lineNumber, boolean isDefined, short noTemplateArgs) {
        return this.createRoutineImp(parent, name, lineNumber, isDefined, noTemplateArgs);
    }

    @Override
    public boolean isAnonymousNamespace() {
        return false;
    }

    @Override
    public IElementProcessor getParentProcessor() {
        return this.m_ParentProcessor;
    }

    protected void processScope(EDG.Scope scope) {
        ScopeVisitor visitor = new ScopeVisitor();
        scope.accept(visitor);
    }

    protected void addLambdaBodyRoutine(EDG.Routine routine) {
        assert (routine != null) : "Parameter 'routine' of method 'addLambdaBodyRoutine' must not be null";
    }

    protected void processLambdaClosureClass(EDG.TypeClassStructUnion csu) {
        EDG.Routine routine = csu.extraInfo().assocScope().routines();
        while (routine != null) {
            if (routine.isLambdaBody()) {
                this.addLambdaBodyRoutine(routine);
                break;
            }
            routine = routine.next();
        }
    }

    protected void processTypedef(EDG.TypeTyperef td) {
        IElementProcessor processor = this.m_Context.createTypedefProcessor(this, td);
        if (processor.initElement()) {
            this.m_Context.addProcessor(processor);
        }
    }

    protected void processEnum(EDG.TypeInteger e) {
        IElementProcessor processor = this.m_Context.createEnumProcessor(this, e);
        if (processor.initElement()) {
            this.m_Context.addProcessor(processor);
        }
    }

    protected void processClassStructUnion(EDG.TypeClassStructUnion csu) {
        IElementProcessor processor;
        if (csu.extraInfo().isLambdaClosureClass()) {
            this.processLambdaClosureClass(csu);
        } else if ((!csu.isNonrealClass() && !csu.isTemplateClass() || csu.isPrototypeInstantiation() || csu.isSpecialized()) && (processor = this.m_Context.createClassStructUnionProcessor(this, csu)).initElement()) {
            this.m_Context.addProcessor(processor);
        }
    }

    protected void processNamespace(EDG.NamespaceAssocScope n) {
        IElementProcessor processor = this.m_Context.createNamespaceProcessor(this, n);
        if (processor.initElement()) {
            this.m_Context.addProcessor(processor);
        }
    }

    protected void processRoutine(EDG.Routine r) {
        if (!r.compilerGenerated()) {
            long seq = r.sourceCorresp().declPosition().seq();
            CppProgrammingElement prototypeInstantiation = null;
            if (!r.isPrototypeInstantiation() && (prototypeInstantiation = (CppProgrammingElement)this.m_routineLocations.get(seq)) != null) {
                this.getContext().mapElement(r, prototypeInstantiation);
                return;
            }
            IElementProcessor processor = this.m_Context.createRoutineProcessor(this, r);
            if (processor.initElement()) {
                if (r.isPrototypeInstantiation()) {
                    this.m_routineLocations.put(seq, processor.getElement());
                }
                this.m_Context.addProcessor(processor);
            }
        }
    }

    protected void processStaticVariable(EDG.Variable v) {
        IElementProcessor processor = this.m_Context.createVariableProcessor(this, v);
        if (processor.initElement()) {
            this.m_Context.addProcessor(processor);
        }
    }

    protected void processLocalVariable(EDG.Variable v) {
        IElementProcessor processor = this.m_Context.createLocalVariableProcessor(this, v);
        if (processor.initElement()) {
            this.m_Context.addProcessor(processor);
        }
    }

    private static class NestingInfo {
        private int m_nesting = 0;
        private int m_maxNesting = 0;

        private NestingInfo() {
        }

        private void increment() {
            ++this.m_nesting;
            this.m_maxNesting = Math.max(this.m_nesting, this.m_maxNesting);
        }

        private void decrement() {
            --this.m_nesting;
            assert (this.m_nesting >= 0);
        }
    }

    protected final class ScopeVisitor
    extends EDGVisitor {
        private int m_statementCounter;
        private int m_cyclomaticComplexity;
        private int m_modifiedCyclomaticComplexity;
        private NestingInfo m_nestingInfo;

        protected ScopeVisitor() {
        }

        int getMaxNesting() {
            return this.m_nestingInfo.m_maxNesting;
        }

        int getStatementCounter() {
            return this.m_statementCounter;
        }

        int getCyclomaticComplexity() {
            return this.m_cyclomaticComplexity;
        }

        int getModifiedCyclomaticComplexity() {
            return this.m_modifiedCyclomaticComplexity;
        }

        @Override
        public void visitScope(EDG.Scope obj) {
            EDG.Type t = obj.types();
            while (t != null) {
                t.accept(this);
                t = t.next();
            }
            EDG.Variable v = obj.variables();
            while (v != null) {
                ElementProcessor.this.processStaticVariable(v);
                v = v.next();
            }
            v = obj.nonstaticVariables();
            while (v != null) {
                if (!v.isParameter()) {
                    ElementProcessor.this.processLocalVariable(v);
                }
                v = v.next();
            }
            EDG.Routine r = obj.routines();
            while (r != null) {
                ElementProcessor.this.processRoutine(r);
                r = r.next();
            }
            EDG.Namespace n = obj.namespaces();
            while (n != null) {
                n.accept(this);
                n = n.next();
            }
        }

        @Override
        public void visitTypeTyperef(EDG.TypeTyperef obj) {
            ElementProcessor.this.processTypedef(obj);
        }

        @Override
        public void visitTypeInteger(EDG.TypeInteger obj) {
            if (obj.enumType()) {
                ElementProcessor.this.processEnum(obj);
            }
        }

        @Override
        public void visitNamespaceAssocScope(EDG.NamespaceAssocScope obj) {
            ElementProcessor.this.processNamespace(obj);
        }

        @Override
        public void visitScopeRoutine(EDG.ScopeRoutine obj) {
            this.visitScope(obj);
            this.m_cyclomaticComplexity = 1;
            this.m_modifiedCyclomaticComplexity = 1;
            this.m_nestingInfo = new NestingInfo();
            ++this.m_statementCounter;
            obj.assocBlock().accept(this);
        }

        @Override
        public void visitStatementDynamicInit(EDG.StatementDynamicInit obj) {
            --this.m_statementCounter;
        }

        @Override
        public void visitStatementBlock(EDG.StatementBlock obj) {
            EDG.Scope scope = obj.extraInfo().assocScope();
            if (obj.statements() != null || this.m_statementCounter == 1) {
                --this.m_statementCounter;
            }
            if (scope != null) {
                assert (!(scope instanceof EDG.ScopeRoutine));
                this.visitScope(scope);
            }
            EDG.Statement s = obj.statements();
            while (s != null) {
                ++this.m_statementCounter;
                s.accept(this);
                s = s.next();
            }
        }

        @Override
        public void visitStatementReturnDynamicInit(EDG.StatementReturnDynamicInit s) {
            if (s.position().seq() == 0L && s.expr() == null) {
                --this.m_statementCounter;
            }
        }

        @Override
        public void visitStatementForLoop(EDG.StatementForLoop obj) {
            EDG.Scope forInitScope = obj.extraInfo().forInitScope();
            ++this.m_statementCounter;
            ++this.m_cyclomaticComplexity;
            ++this.m_modifiedCyclomaticComplexity;
            if (forInitScope != null) {
                this.visitScope(forInitScope);
            }
            this.m_nestingInfo.increment();
            obj.statement().accept(this);
            this.m_nestingInfo.decrement();
        }

        private boolean testForSingleIfBlock(EDG.Statement s) {
            if (s instanceof EDG.StatementIfStmt) {
                return true;
            }
            if (s instanceof EDG.StatementBlock) {
                EDG.StatementBlock sb = (EDG.StatementBlock)s;
                EDG.Statement st = sb.statements();
                if (st == null || st.next() != null) {
                    return false;
                }
                long seq = sb.position().seq();
                if (st.position().seq() != seq && seq > 0L) {
                    return false;
                }
                if (st instanceof EDG.StatementBlock) {
                    return this.testForSingleIfBlock(st);
                }
                return st instanceof EDG.StatementIfStmt;
            }
            return false;
        }

        @Override
        public void visitStatementIfStmt(EDG.StatementIfStmt obj) {
            ++this.m_statementCounter;
            ++this.m_cyclomaticComplexity;
            ++this.m_modifiedCyclomaticComplexity;
            this.m_nestingInfo.increment();
            obj.thenStatement().accept(this);
            this.m_nestingInfo.decrement();
            if (obj.elseStatement() != null) {
                ++this.m_statementCounter;
                if (this.testForSingleIfBlock(obj.elseStatement())) {
                    obj.elseStatement().accept(this);
                } else {
                    this.m_nestingInfo.increment();
                    obj.elseStatement().accept(this);
                    this.m_nestingInfo.decrement();
                }
            }
        }

        @Override
        public void visitStatementLoopStatement(EDG.StatementLoopStatement obj) {
            ++this.m_statementCounter;
            ++this.m_cyclomaticComplexity;
            ++this.m_modifiedCyclomaticComplexity;
            this.m_nestingInfo.increment();
            obj.loopStatement().accept(this);
            this.m_nestingInfo.decrement();
        }

        @Override
        public void visitStatementSwitchStmt(EDG.StatementSwitchStmt obj) {
            ++this.m_modifiedCyclomaticComplexity;
            this.m_nestingInfo.increment();
            obj.bodyStatement().accept(this);
            this.m_nestingInfo.decrement();
        }

        @Override
        public void visitStatementSwitchCase(EDG.StatementSwitchCase obj) {
            if (obj.extraInfo().caseValue() != null) {
                ++this.m_cyclomaticComplexity;
            }
        }

        @Override
        public void visitStatementTryBlock(EDG.StatementTryBlock obj) {
            ++this.m_statementCounter;
            this.m_nestingInfo.increment();
            obj.tryBlock().statement().accept(this);
            EDG.Handler h = obj.tryBlock().handlers();
            while (h != null) {
                ++this.m_statementCounter;
                h.statement().accept(this);
                h = h.next();
            }
            this.m_nestingInfo.decrement();
        }

        @Override
        public void visitStatementForEachLoop(EDG.StatementForEachLoop obj) {
            ++this.m_statementCounter;
            ++this.m_cyclomaticComplexity;
            ++this.m_modifiedCyclomaticComplexity;
            this.m_nestingInfo.increment();
            obj.statement().accept(this);
            this.m_nestingInfo.decrement();
        }

        @Override
        public void visitStatementMicrosoftTry(EDG.StatementMicrosoftTry obj) {
            ++this.m_statementCounter;
            this.m_nestingInfo.increment();
            obj.microsoftTry().guardedStatement().accept(this);
            if (obj.microsoftTry().cleanupStatement() != null) {
                ++this.m_statementCounter;
                obj.microsoftTry().cleanupStatement().accept(this);
            }
            this.m_nestingInfo.decrement();
        }

        @Override
        public void visitTypeClassStructUnion(EDG.TypeClassStructUnion obj) {
            ElementProcessor.this.processClassStructUnion(obj);
        }
    }
}

