/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.settings.AbstractSearchPathCommand;
import com.hello2morrow.sonargraph.core.command.system.settings.ISearchPathProviderManager;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.settings.SearchPathDelta;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CPlusPlusCommandId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.settings.ICPlusPlusInstallationExtension;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchPathEditInstSpecDirCommand
extends AbstractSearchPathCommand<ISearchPathEditInstSpecDirInteraction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchPathEditInstSpecDirCommand.class);
    private final TFile m_newPath;
    private final TFile m_instSpecDir;
    private List<TFile> m_definitions;

    public SearchPathEditInstSpecDirCommand(ISoftwareSystemProvider controller, ISearchPathEditInstSpecDirInteraction interaction, ISearchPathProviderManager provider, SearchPathDelta delta, TFile instSpecDir, TFile newPath) {
        super(controller, (ICommandInteraction)interaction, provider, delta, new OperationResult("Edit path for installation specific compiler definitions"));
        assert (controller != null) : "Parameter 'controller' of method 'SearchPathEditInstSpecDirCommand' must not be null";
        assert (newPath != null) : "Parameter 'newPath' of method 'SearchPathEditInstSpecDirCommand' must not be null";
        this.m_newPath = newPath;
        this.m_instSpecDir = instSpecDir;
    }

    public ICommandId getId() {
        return CPlusPlusCommandId.SEARCH_PATH_EDIT_INST_SPEC_DIR;
    }

    protected void internalRun(IWorkerContext workerContext) {
        if (!this.m_newPath.isDirectory() || !this.m_newPath.exists()) {
            ((ISearchPathEditInstSpecDirInteraction)this.getInteraction()).warning("Directory for Installation Specific C++ Compiler Definitions", "Selected directory is not a valid existing directory!");
            return;
        }
        if (this.m_newPath.getNormalizedAbsolutePath().equals(this.m_instSpecDir.getNormalizedAbsolutePath())) {
            LOGGER.debug("Path did not change - nothing to be done.");
            return;
        }
        this.checkIfPathCanBeAdded(this.m_newPath, this.getResult());
        if (this.getResult().isFailure()) {
            return;
        }
        ICPlusPlusInstallationExtension instProvider = (ICPlusPlusInstallationExtension)this.getController().getInstallation().getExtension(ICPlusPlusInstallationExtension.class);
        assert (instProvider != null) : "Extension 'instProvider' must not be null";
        this.m_definitions = instProvider.listDefinitionsFromDir(this.m_newPath);
    }

    public List<TFile> getDefinitions() {
        return this.m_definitions;
    }

    public static interface ISearchPathEditInstSpecDirInteraction
    extends ICommandInteraction {
        public void warning(String var1, String var2);
    }
}

