/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericRootDirectory;
import com.hello2morrow.sonargraph.core.model.system.IAdditionalDynamicInfoProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathType;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.python.controller.settings.PythonSettingsExtension;
import com.hello2morrow.sonargraph.languageprovider.python.foundation.common.PythonCause;
import com.hello2morrow.sonargraph.languageprovider.python.foundation.common.PythonLanguage;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.IPythonVirtualEnvironmentValidator;
import com.hello2morrow.sonargraph.languageprovider.python.model.workspace.PythonModuleType;
import de.schlichtherle.truezip.file.TFile;

public final class PythonDynamicSystemInfoProvider
implements IAdditionalDynamicInfoProvider {
    public Language getLanguage() {
        return PythonLanguage.INSTANCE;
    }

    public void addAdditionalModuleInfo(Installation installation, SoftwareSystem softwareSystem, Module module, ModuleInfo moduleInfo, DynamicSystemInfo systemInfo, OperationResultWithOutcome<SoftwareSystem> result) {
        TFile rootDirectory = systemInfo.getPythonRoot();
        TFile virtualEnv = systemInfo.getPythonVirtualEnvironment();
        if (virtualEnv != null) {
            PythonSettingsExtension settingsExt = (PythonSettingsExtension)installation.getExtension(PythonSettingsExtension.class);
            IPythonVirtualEnvironmentValidator validator = settingsExt.getPythonVirtualEnvironmentPathValidator();
            ValidationResult validation = validator.isValid(null, virtualEnv);
            if (validation.isFailure()) {
                result.addError((OperationResult.IMessageCause)PythonCause.INVALID_VIRTUAL_ENVIRONMENT, (String)validation.getErrors().get(0), new Object[0]);
                return;
            }
            settingsExt.setSystemInterpreterPath((IWorkerContext)DefaultWorkerContext.INSTANCE, softwareSystem, validator.getInterpreterFile().getNormalizedAbsolutePath(), false);
        }
        GenericRootDirectory root = new GenericRootDirectory((IModelServiceProvider)softwareSystem, (NamedElement)module, rootDirectory.getNormalizedAbsoluteFile());
        module.addChild((NamedElement)root);
    }

    public String getDynamicModuleType() {
        return PythonModuleType.PYTHON_MANUAL_MODULE.getStandardName();
    }

    public RootPathType getSourceDirectoryRootPathType() {
        return RootPathType.NON_STANDARD;
    }
}

