/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.api;

import com.hello2morrow.sonargraph.build.api.ResolutionType;
import com.hello2morrow.sonargraph.build.api.Severity;

public abstract class AbstractIssueFilter {
    public static final String ANY = "any";
    protected final String m_type;
    protected final String m_severity;
    protected final String m_resolution;

    protected AbstractIssueFilter(String issueType, String severity, String resolution) {
        assert (issueType != null && issueType.length() > 0) : "Parameter 'issueType' of method 'IssueFilter' must not be empty";
        assert (severity != null && severity.length() > 0) : "Parameter 'severity' of method 'IssueFilter' must not be empty";
        assert (resolution != null && resolution.length() > 0) : "Parameter 'resolution' of method 'IssueFilter' must not be empty";
        this.m_type = issueType;
        this.m_severity = severity;
        this.m_resolution = resolution;
    }

    public final String getIssueType() {
        return this.m_type;
    }

    public final String getSeverity() {
        return this.m_severity;
    }

    public final String getResolution() {
        return this.m_resolution;
    }

    public static abstract class AbstractBuilder<T extends AbstractIssueFilter> {
        private String m_issueType;
        private String m_severity;
        private String m_resolution;

        public AbstractBuilder<T> issueType(String issueType) {
            assert (this.m_issueType == null) : "Cannot set issueType more than once";
            if (issueType == null || issueType.trim().length() == 0) {
                throw new IllegalArgumentException("IssueType must be specified!");
            }
            this.m_issueType = issueType.trim();
            return this;
        }

        public AbstractBuilder<T> severity(String severity) {
            assert (this.m_severity == null) : "Cannot set severity more than once.";
            if (severity == null || severity.trim().length() == 0) {
                this.m_severity = AbstractIssueFilter.ANY;
                return this;
            }
            String trimmed = severity.trim();
            if (trimmed.equalsIgnoreCase(AbstractIssueFilter.ANY)) {
                this.m_resolution = trimmed;
                return this;
            }
            StringBuilder valuesString = new StringBuilder();
            for (Severity value : Severity.values()) {
                if (value.name().equalsIgnoreCase(trimmed)) {
                    this.m_severity = trimmed;
                    return this;
                }
                valuesString.append(value.name()).append(", ");
            }
            valuesString.substring(0, valuesString.length() - 2);
            throw new IllegalArgumentException("Property 'severity' must be one of " + valuesString.toString());
        }

        public AbstractBuilder<T> resolution(String resolution) {
            if (resolution == null || resolution.trim().length() == 0) {
                this.m_resolution = ResolutionType.NONE.name().toLowerCase();
                return this;
            }
            String trimmed = resolution.trim();
            if (trimmed.equalsIgnoreCase(AbstractIssueFilter.ANY)) {
                this.m_resolution = trimmed;
                return this;
            }
            StringBuilder valuesString = new StringBuilder();
            for (ResolutionType value : ResolutionType.values()) {
                if (value.name().equalsIgnoreCase(trimmed)) {
                    this.m_resolution = trimmed;
                    return this;
                }
                valuesString.append(value.name()).append(", ");
            }
            valuesString.substring(0, valuesString.length() - 2);
            throw new IllegalArgumentException("Property 'resolution' must be one of " + valuesString.toString());
        }

        protected void prepareProperties() {
            if (this.m_severity == null) {
                this.m_severity = AbstractIssueFilter.ANY;
            }
            if (this.m_issueType == null) {
                this.m_issueType = AbstractIssueFilter.ANY;
            }
            if (this.m_resolution == null) {
                this.m_resolution = ResolutionType.NONE.name().toLowerCase();
            }
        }

        public abstract T create();

        public String getIssueType() {
            return this.m_issueType;
        }

        public String getResolution() {
            return this.m_resolution;
        }

        public String getSeverity() {
            return this.m_severity;
        }
    }
}

