/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.system.settings;

import com.hello2morrow.sonargraph.core.persistence.system.settings.PropertyFilePersistence;
import com.hello2morrow.sonargraph.foundation.file.SearchPath;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SearchPathFilePersistence
extends PropertyFilePersistence {
    private final List<TFile> m_invalidDirectories = new ArrayList<TFile>();
    private SearchPath m_searchPath;

    protected SearchPathFilePersistence() {
        this.m_searchPath = new SearchPath();
    }

    public SearchPathFilePersistence(TFile file, String[] propertyNames) {
        super(file, propertyNames);
        assert (propertyNames.length > 0) : "propertyNames must contain at least one property!";
    }

    @Override
    public void load(OperationResult result) {
        super.load(result);
        this.m_invalidDirectories.clear();
        if (result.isFailure()) {
            return;
        }
        String pathList = this.getValue(this.getKeys().get(0));
        this.m_searchPath = new SearchPath();
        if (pathList == null || pathList.length() == 0) {
            return;
        }
        String[] stringArray = pathList.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            TFile dir = new TFile(path.trim());
            this.m_searchPath.add(dir.getNormalizedAbsolutePath());
            if (!dir.exists() || !dir.isDirectory()) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.NOT_A_DIRECTORY, "Specified path [" + dir.getNormalizedAbsolutePath() + "] does not exist", new Object[0]);
                this.m_invalidDirectories.add(dir);
            }
            ++n2;
        }
    }

    public void setSearchPath(SearchPath searchPath) {
        assert (searchPath != null) : "Parameter 'searchPath' of method 'setSearchPath' must not be null";
        this.m_searchPath = searchPath;
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (TFile dir : this.m_searchPath.getDirectories()) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            builder.append(dir.getAbsolutePath());
        }
        this.setValue(this.getKeys().get(0), builder.toString());
    }

    public SearchPath getSearchPath() {
        assert (this.m_searchPath != null) : "'m_searchPath' of method 'getSearchPath' must not be null";
        return this.m_searchPath.copy();
    }

    public List<TFile> getInvalidSearchPathDirectories() {
        return Collections.unmodifiableList(this.m_invalidDirectories);
    }
}

