/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.IStructureId;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureAssignmentElement;
import com.hello2morrow.sonargraph.core.model.architecture.WorkspaceRootComponentContainer;
import com.hello2morrow.sonargraph.core.model.element.ArchitectureStructureItem;
import com.hello2morrow.sonargraph.core.model.element.CoreStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.ILogicalElement;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.LogicalStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.StructureInfo;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class StructureItemRegistry {
    private final Map<IStructureId, Pair<StructureInfo, StructureInfo>> m_idToStructures = new HashMap<IStructureId, Pair<StructureInfo, StructureInfo>>();

    public StructureItemRegistry() {
        StructureInfo logicalStructure = new StructureInfo(Arrays.asList(LogicalStructureItem.values()));
        ArrayList<IStructureItem> logicalArchitectureStructure = new ArrayList<IStructureItem>();
        logicalArchitectureStructure.add(ArchitectureStructureItem.ARTIFACT);
        Arrays.stream(LogicalStructureItem.values()).forEach(item -> {
            boolean bl = logicalArchitectureStructure.add((IStructureItem)item);
        });
        this.m_idToStructures.put(LogicalStructureItemId.LOGICAL, (Pair<StructureInfo, StructureInfo>)new Pair((Object)logicalStructure, (Object)new StructureInfo(logicalArchitectureStructure)));
    }

    private void collectArtifactsRecursively(Artifact artifact, Set<Artifact> collected) {
        assert (artifact != null) : "Parameter 'artifact' of method 'collectArtifactsRecursively' must not be null";
        assert (collected != null) : "Parameter 'collected' of method 'collectArtifactsRecursively' must not be null";
        for (Artifact child : artifact.getChildren(Artifact.class, false)) {
            collected.add(child);
            this.collectArtifactsRecursively(child, collected);
        }
    }

    public void createStructure(Language language, List<IStructureItem> physicalStructureItems) {
        assert (language != null) : "Parameter 'language' of method 'createStructure' must not be null";
        assert (physicalStructureItems != null) : "Parameter 'physicalStructureItems' of method 'createStructure' must not be null";
        ArchitectureStructureItem[] architectureOnlyItems = ArchitectureStructureItem.values();
        ArrayList<IStructureItem> architectureStructureItems = new ArrayList<IStructureItem>();
        int i = 0;
        while (i < architectureOnlyItems.length + physicalStructureItems.size()) {
            Enum nextItem;
            IStructureItem iStructureItem = nextItem = i < architectureOnlyItems.length ? architectureOnlyItems[i] : physicalStructureItems.get(i - architectureOnlyItems.length);
            if (nextItem.includedInArchitecture()) {
                if (nextItem.isInternalComponent()) {
                    nextItem = CoreStructureItem.INTERNAL_COMPONENT;
                } else if (nextItem.isExternalComponent()) {
                    nextItem = CoreStructureItem.EXTERNAL_COMPONENT;
                }
                architectureStructureItems.add((IStructureItem)((Object)nextItem));
            }
            ++i;
        }
        StructureInfo physicalStructure = new StructureInfo(physicalStructureItems);
        StructureInfo architectureStructure = new StructureInfo(architectureStructureItems);
        this.m_idToStructures.put(language, (Pair<StructureInfo, StructureInfo>)new Pair((Object)physicalStructure, (Object)architectureStructure));
    }

    public StructureInfo getStructureForElement(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getStructureForElement' must not be null";
        if (namedElement instanceof ILogicalElement) {
            return (StructureInfo)this.m_idToStructures.get(LogicalStructureItemId.LOGICAL).getFirst();
        }
        if (namedElement instanceof IArchitectureAssignmentElement && namedElement.getDomain() == IDomainRoot.Domain.ARCHITECTURE_LOGICAL) {
            return (StructureInfo)this.m_idToStructures.get(LogicalStructureItemId.LOGICAL).getSecond();
        }
        Language language = namedElement.getLanguage();
        if (language != null) {
            Pair<StructureInfo, StructureInfo> structures = this.m_idToStructures.get(language);
            assert (structures != null) : "Parameter 'structures' of method 'getStructureForElement' must not be null";
            if (namedElement instanceof IArchitectureAssignmentElement) {
                return (StructureInfo)structures.getSecond();
            }
            return (StructureInfo)structures.getFirst();
        }
        NamedElement sample = null;
        if (namedElement.hasAllChildren(true, WorkspaceRootComponentContainer.class)) {
            List<WorkspaceRootComponentContainer> children = namedElement.getChildren(WorkspaceRootComponentContainer.class);
            assert (children != null && !children.isEmpty()) : "Parameter 'children' of method 'getStructureForElement' must not be empty";
            sample = children.get(0).getRepresentedElement();
        } else if (namedElement instanceof Artifact) {
            if (namedElement.getDomain() == IDomainRoot.Domain.ARCHITECTURE_LOGICAL) {
                return (StructureInfo)this.m_idToStructures.get(LogicalStructureItemId.LOGICAL).getSecond();
            }
            HashSet<Artifact> collected = new HashSet<Artifact>();
            this.collectArtifactsRecursively((Artifact)namedElement, collected);
            for (Artifact artifact : collected) {
                List<? extends NamedElement> children = artifact.getAllChildren(new NamedElement.IFilter(){

                    @Override
                    public boolean accept(NamedElement namedElement) {
                        return namedElement instanceof WorkspaceRootComponentContainer;
                    }
                });
                if (children.isEmpty()) continue;
                sample = ((WorkspaceRootComponentContainer)children.get(0)).getRepresentedElement();
                break;
            }
        }
        assert (sample != null) : "'sample' of method 'getStructureForElement' must not be null for: " + String.valueOf(namedElement);
        return (StructureInfo)this.m_idToStructures.get(sample.getLanguage()).getSecond();
    }

    public Map<IStructureId, Pair<StructureInfo, StructureInfo>> getAllStructures() {
        return Collections.unmodifiableMap(this.m_idToStructures);
    }

    private static enum LogicalStructureItemId implements IStandardEnumeration,
    IStructureId
    {
        LOGICAL;


        @Override
        public String getImageResourceName() {
            return this.getStandardName();
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }

        public String toString() {
            return this.getStandardName();
        }
    }
}

