/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.representation;

import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingEdge;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationDependency;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import java.util.ArrayList;
import java.util.List;

public final class RepresentationEdge<T extends INode<NamedElement>>
extends RepresentationDependency
implements INode.IEdge,
IParserDependenciesProvidingEdge {
    private final T m_from;
    private final T m_to;
    private final List<Dependency> m_dependencies;
    private final EndpointType m_endpointType;

    public RepresentationEdge(T from, T to, List<Dependency> dependencies, EndpointType endpointType) {
        assert (from != null) : "Parameter 'from' of method 'TreeEdge' must not be null";
        assert (to != null) : "Parameter 'to' of method 'TreeEdge' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'RepresentationEdge' must not be null";
        assert (endpointType != null) : "Parameter 'endpointType' of method 'RepresentationEdge' must not be null";
        this.m_from = from;
        this.m_to = to;
        this.m_dependencies = dependencies;
        this.m_endpointType = endpointType;
    }

    public final T getFrom() {
        return this.m_from;
    }

    public final T getTo() {
        return this.m_to;
    }

    @Override
    public final NamedElement getFromEndPoint() {
        return (NamedElement)this.m_from.getUnderlyingObject();
    }

    @Override
    public final NamedElement getToEndPoint() {
        return (NamedElement)this.m_to.getUnderlyingObject();
    }

    @Override
    public EndpointType getEndpointType() {
        return this.m_endpointType;
    }

    @Override
    @IntProperty(undefinedValue=-1)
    public int getLineNumber() {
        if (this.getWeight() == 1) {
            return this.getFirstDependency().getLineNumber();
        }
        return -1;
    }

    @Override
    public int getWeight() {
        return this.m_dependencies.size();
    }

    @Override
    @IntProperty(undefinedValue=0)
    public int getNumberOfParserDependencies() {
        return this.getWeight();
    }

    @Override
    public Dependency getFirstDependency() {
        return this.m_dependencies.isEmpty() ? null : this.m_dependencies.get(0);
    }

    public List<Dependency> getDependencies() {
        return this.m_dependencies;
    }

    public List<ParserDependency> getParserDependencies() {
        ArrayList<ParserDependency> collected = new ArrayList<ParserDependency>();
        for (Dependency nextDependency : this.getDependencies()) {
            if (!(nextDependency instanceof ParserDependency)) continue;
            collected.add((ParserDependency)nextDependency);
        }
        return collected;
    }

    @Override
    public String getImageResourceName() {
        return ParserDependency.class.getSimpleName();
    }

    @Override
    public boolean isValid() {
        return ((NamedElement)this.m_from.getUnderlyingObject()).isValid() && ((NamedElement)this.m_to.getUnderlyingObject()).isValid();
    }

    @Override
    public Element.IPropertiesManager getPropertiesManager() {
        return ((NamedElement)this.m_from.getUnderlyingObject()).getPropertiesManager();
    }

    @Override
    public String getShortName() {
        if (this.getWeight() == 1) {
            return this.getFirstDependency().getName();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.m_from.getName());
        builder.append(" -> ");
        builder.append(this.m_to.getName());
        return builder.toString();
    }

    @Override
    public String getPresentationName(boolean inContext) {
        if (this.getWeight() == 1) {
            return this.getFirstDependency().getPresentationName(inContext);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(((NamedElement)this.m_from.getUnderlyingObject()).getPresentationName(inContext));
        builder.append(" -> ");
        builder.append(((NamedElement)this.m_to.getUnderlyingObject()).getPresentationName(inContext));
        return builder.toString();
    }

    @Override
    public final boolean hasUnresolvedErrorIssues() {
        if (this.getWeight() == 1) {
            this.getFirstDependency().hasUnresolvedErrorIssues();
        }
        return false;
    }

    @Override
    public final boolean hasUnresolvedWarningIssues() {
        if (this.getWeight() == 1) {
            this.getFirstDependency().hasUnresolvedWarningIssues();
        }
        return false;
    }

    @Override
    public boolean isExternal() {
        return ((NamedElement)this.m_from.getUnderlyingObject()).isExternal();
    }

    @Override
    public boolean isExcluded() {
        return ((NamedElement)this.m_from.getUnderlyingObject()).isExcluded();
    }

    @Override
    public boolean ignoreIssues() {
        return ((NamedElement)this.m_from.getUnderlyingObject()).ignoreIssues();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append("\n");
        builder.append(this.m_from.toString()).append(" -> ").append(this.m_to.toString()).append(" [").append(this.getWeight()).append("]");
        return builder.toString();
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n");
        if (!this.m_dependencies.isEmpty()) {
            builder.append("Class of underlying dependencies: ");
            builder.append(this.m_dependencies.get(0).getClass().getName());
            int i = 1;
            for (Dependency next : this.m_dependencies) {
                builder.append("\n").append("[").append(i++).append("] ").append(next.getName()).append(" [").append(Integer.toHexString(next.hashCode())).append("]");
            }
        } else {
            builder.append("No underlying dependencies");
        }
        return builder.toString();
    }

    @Override
    public Element getDependency() {
        return this;
    }

    @Override
    public ParserDependency getFirstParserDependency() {
        for (Dependency nextDependency : this.getDependencies()) {
            if (!(nextDependency instanceof ParserDependency)) continue;
            return (ParserDependency)nextDependency;
        }
        return null;
    }
}

