/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.refactoring.ICollisionValidator;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringInfo;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringData;

public final class RenameRefactoringData
extends RefactoringData {
    private final ITextValidator m_nameValidator;
    private final String m_originalName;
    private String m_targetName;

    public RenameRefactoringData(MoveRenameRefactoringInfo info, RootDirectoryPath originalRootDirectory, String originalParentName, ICollisionValidator collisionValidator, String parentKind, String parentImageResourceName, String elementImageResourceName, ITextValidator nameValidator, String name) {
        super(info, originalRootDirectory, originalParentName, collisionValidator, parentKind, parentImageResourceName, elementImageResourceName);
        assert (nameValidator != null) : "Parameter 'nameValidator' of method 'RenameRefactoringData' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'RenameRefactoringData' must not be empty";
        this.m_nameValidator = nameValidator;
        this.m_originalName = name;
        this.m_targetName = name;
    }

    @Override
    public ITextValidator getTargetNameValidator() {
        return this.m_nameValidator;
    }

    @Override
    public ValidationResult setTargetName(String targetName) {
        this.m_targetName = targetName;
        return this.validateCollision();
    }

    @Override
    public String getTargetName() {
        return this.m_targetName;
    }

    @Override
    public boolean hasBeenModified() {
        return !this.m_originalName.equals(this.m_targetName);
    }

    @Override
    protected boolean useTargetNameForCollisionCheck() {
        return true;
    }

    @Override
    public boolean hasValidData() {
        return super.hasValidData() && this.m_targetName != null && this.m_nameValidator.isValid(this.m_originalName, this.m_targetName).isSuccess();
    }
}

