/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetrieverProvider;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DependenciesViewRepresentationInfo;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DeprecationInfo;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ParserDependencyNumbers;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ViolationInfo;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.EmptyNodeProgrammingElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOperationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewSortMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import com.hello2morrow.sonargraph.core.model.explorationview.IExplorationViewDependencyInfoProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.NodeLocation;
import com.hello2morrow.sonargraph.core.model.explorationview.NullArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyEndPoints;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyState;
import com.hello2morrow.sonargraph.core.model.explorationview.PatternType;
import com.hello2morrow.sonargraph.core.model.explorationview.PatternTypeComparator;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ResetInfo;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.AssignableToArtifactRefactoringDescriptor;
import com.hello2morrow.sonargraph.core.model.refactoring.RecursiveElementRefactoringDescriptor;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExplorationViewRepresentation
extends ArchitecturalViewElement
implements IExplorationViewDependencyInfoProvider,
IAssignableTarget,
IAssignableAttributeRetrieverProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplorationViewRepresentation.class);
    private final Map<ProgrammingElement, ArchitecturalViewNode> m_programmingElementToLeafNode = new THashMap();
    private final Set<ProgrammingElement> m_excludedProgrammingElements = new THashSet();
    private final Set<ParserDependency> m_excludedParserDependencies = new THashSet();
    private final Set<ProgrammingElement> m_deletedProgrammingElements = new THashSet();
    private final Set<ParserDependency> m_deletedParserDependencies = new THashSet();
    private final DependenciesViewRepresentationInfo m_representationInfo = new DependenciesViewRepresentationInfo();
    private final Map<AssignableToArtifactNode, ArtifactNode> m_assignableNodeToArtifactNode = new THashMap();
    private final Map<String, IAssignableAttributeRetriever> m_nameToRetriever = new LinkedHashMap<String, IAssignableAttributeRetriever>();
    private final Map<Language, RecursiveElementRefactoringDescriptor> m_languageToRecursiveElementCreationDescriptor = new LinkedHashMap<Language, RecursiveElementRefactoringDescriptor>();
    private final Map<Language, AssignableToArtifactRefactoringDescriptor> m_languageToAssignableToArtifactCreationDescriptor = new LinkedHashMap<Language, AssignableToArtifactRefactoringDescriptor>();
    private final NullArchitecturalViewNode m_nullNode;
    private final CategoryProvider m_categoryProvider;
    private final String m_id;
    private final ExplorationViewStructureMode m_structureMode;
    private final IElementResolver m_resolver;
    private final ILazyArchitecturalViewElementCreator m_creator;
    private final ExplorationViewOperationMode m_operationMode;
    private final String m_defaultRetriever;
    private final String m_basedOnArchitectureFile;
    private Map<AssignableToArtifactNode, NodeLocation> m_nodeToOriginalLocation = new LinkedHashMap<AssignableToArtifactNode, NodeLocation>();
    private ExplorationViewFocus m_focus = new ExplorationViewFocus();
    private PresentationMode m_presentationMode = PresentationMode.HIERARCHICAL;
    private ExplorationViewSortMode m_sortMode = ExplorationViewSortMode.getDefault();
    private int m_parserDependencies;
    private int m_internalProgrammingElements;
    private int m_externalProgrammingElements;
    private int m_internalAssignableToArtifactNodes;
    private int m_externalAssignableToArtifactNodes;
    private boolean m_isValid = true;
    private boolean m_inInitialCreation = true;
    private boolean m_inModification = true;
    private boolean m_inEditOperation = false;
    private boolean m_inTransfer = false;

    public ExplorationViewRepresentation(String id, ExplorationViewStructureMode structureMode, CategoryProvider categoryProvider, Map<String, IAssignableAttributeRetriever> nameToRetriever, Map<Language, RecursiveElementRefactoringDescriptor> languageToRecursiveElementCreationDescriptor, Map<Language, AssignableToArtifactRefactoringDescriptor> languageToAssignableToArtifactCreationDescriptor, IElementResolver resolver, ILazyArchitecturalViewElementCreator creator, ExplorationViewOperationMode mode, String defaultRetriever, String basedOnArchitectureFile) {
        super(null);
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'ExplorationViewRepresentation' must not be empty";
        assert (structureMode != null) : "Parameter 'structureMode' of method 'ExplorationViewRepresentation' must not be null";
        assert (categoryProvider != null) : "Parameter 'categoryProvider' of method 'ExplorationViewRepresentation' must not be null";
        assert (nameToRetriever != null) : "Parameter 'retrievers' of method 'ExplorationViewRepresentation' must not be null";
        assert (languageToRecursiveElementCreationDescriptor != null && !languageToRecursiveElementCreationDescriptor.isEmpty()) : "Parameter 'languageToRecursiveElementDescriptor' of method 'ExplorationViewRepresentation' must not be empty";
        assert (languageToAssignableToArtifactCreationDescriptor != null && !languageToAssignableToArtifactCreationDescriptor.isEmpty()) : "Parameter 'languageToAssignableToArtifactCreationDescriptor' of method 'ExplorationViewRepresentation' must not be empty";
        assert (resolver != null) : "Parameter 'resolver' of method 'ExplorationViewRepresentation' must not be null";
        assert (creator != null) : "Parameter 'creator' of method 'ExplorationViewRepresentation' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'ExplorationViewRepresentation' must not be null";
        assert (defaultRetriever != null && defaultRetriever.length() > 0) : "Parameter 'defaultRetriever' of method 'ExplorationViewRepresentation' must not be empty";
        assert (basedOnArchitectureFile == null || !basedOnArchitectureFile.isEmpty()) : "Parameter 'basedOnArchitectureFile' of method 'ExplorationViewRepresentation' must be null or not empty";
        this.m_id = id;
        this.m_structureMode = structureMode;
        this.m_categoryProvider = categoryProvider;
        this.m_nameToRetriever.putAll(nameToRetriever);
        this.m_languageToRecursiveElementCreationDescriptor.putAll(languageToRecursiveElementCreationDescriptor);
        this.m_languageToAssignableToArtifactCreationDescriptor.putAll(languageToAssignableToArtifactCreationDescriptor);
        this.m_nullNode = new NullArchitecturalViewNode(this, this.m_presentationMode, !mode.isArchitectureModelling());
        this.m_resolver = resolver;
        this.m_creator = creator;
        this.m_operationMode = mode;
        this.m_defaultRetriever = defaultRetriever;
        this.m_basedOnArchitectureFile = basedOnArchitectureFile;
    }

    @Override
    public String getShortName() {
        return this.m_id;
    }

    public String getType() {
        return this.m_operationMode.isArchitectureModelling() ? "Architectural View" : "Exploration View";
    }

    @Override
    public String getImageResourceName() {
        return this.m_operationMode.isArchitectureModelling() ? "ArchitecturalView" : "ExplorationView";
    }

    public DependenciesViewRepresentationInfo getRepresentationInfo() {
        return this.m_representationInfo;
    }

    @Property
    public String getBasedOnArchitectureFile() {
        return this.m_basedOnArchitectureFile;
    }

    @Override
    public int getRelativeIndex() {
        return 0;
    }

    public IElementResolver getResolver() {
        return this.m_resolver;
    }

    public ILazyArchitecturalViewElementCreator getCreator() {
        return this.m_creator;
    }

    public NullArchitecturalViewNode getNullNode() {
        return this.m_nullNode;
    }

    @Override
    public boolean isValid() {
        return this.m_isValid;
    }

    public void setInvalid() {
        assert (this.m_isValid) : "Already set to invalid: " + this.getElementInfo();
        this.m_isValid = false;
    }

    public CategoryProvider getCategoryProvider() {
        return this.m_categoryProvider;
    }

    @Override
    public boolean isReadOnly() {
        return !this.m_operationMode.isArchitectureModelling();
    }

    public ExplorationViewFocus getFocus() {
        return this.m_focus;
    }

    public void resetFocus() {
        this.m_focus = new ExplorationViewFocus();
    }

    public RecursiveElementRefactoringDescriptor getRecursiveElementCreationDescriptor(Language language) {
        assert (language != null) : "Parameter 'language' of method 'getRecursiveElementCreationDescriptor' must not be null";
        RecursiveElementRefactoringDescriptor descriptor = this.m_languageToRecursiveElementCreationDescriptor.get(language);
        assert (descriptor != null) : "'descriptor' of method 'getRecursiveElementCreationDescriptor' must not be null";
        return descriptor;
    }

    public AssignableToArtifactRefactoringDescriptor getAssignableToArtifactCreationDescriptor(Language language) {
        assert (language != null) : "Parameter 'language' of method 'getAssignableToArtifactCreationDescriptor' must not be null";
        AssignableToArtifactRefactoringDescriptor descriptor = this.m_languageToAssignableToArtifactCreationDescriptor.get(language);
        assert (descriptor != null) : "'descriptor' of method 'getAssignableToArtifactCreationDescriptor' must not be null";
        return descriptor;
    }

    @Override
    public ArchitecturalViewElement getArchitecturalViewElement() {
        return this;
    }

    @Override
    public NamedElement getFirstUnderlyingElement() {
        return this;
    }

    @Override
    public String getPresentationKind() {
        return this.m_operationMode.isArchitectureModelling() ? "Architectural View" : "Exploration View";
    }

    @Override
    public Language getLanguage() {
        return null;
    }

    @Override
    public List<NamedElement> getUnderlyingElements() {
        return Collections.singletonList(this);
    }

    @Override
    @Property
    public ExplorationViewOperationMode getOperationMode() {
        return this.m_operationMode;
    }

    @Property
    public ExplorationViewStructureMode getStructureMode() {
        return this.m_structureMode;
    }

    @Property
    public ExplorationViewSortMode getSortMode() {
        return this.m_sortMode;
    }

    public void setSortMode(ExplorationViewSortMode sortMode) {
        assert (sortMode != null) : "Parameter 'sortMode' of method 'setSortMode' must not be null";
        assert (this.getSupportedSortModes().contains((Object)sortMode)) : "Not supported sort mode: " + String.valueOf((Object)sortMode);
        this.m_sortMode = sortMode;
    }

    public EnumSet<ExplorationViewSortMode> getSupportedSortModes() {
        EnumSet<ExplorationViewSortMode> modes = EnumSet.allOf(ExplorationViewSortMode.class);
        switch (this.m_operationMode) {
            case ARCHITECTURAL_MODELLING_LOGICAL: 
            case ARCHITECTURE_EXPLORATION_LOGICAL: {
                modes.remove((Object)ExplorationViewSortMode.LOC);
                break;
            }
            case ARCHITECTURAL_MODELLING_PHYSICAL: 
            case ARCHITECTURE_EXPLORATION_PHYSICAL: {
                break;
            }
            case SYSTEM_EXPLORATION_LOGICAL: {
                modes.remove((Object)ExplorationViewSortMode.LEVELIZE_ALL);
                modes.remove((Object)ExplorationViewSortMode.LOC);
                break;
            }
            case SYSTEM_EXPLORATION_PHYSICAL: {
                modes.remove((Object)ExplorationViewSortMode.LEVELIZE_ALL);
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf((Object)this.m_operationMode);
                break;
            }
        }
        return modes;
    }

    @Override
    @Property
    public PresentationMode getPresentationMode() {
        return this.m_presentationMode;
    }

    @Override
    public void setPresentationMode(PresentationMode presentationMode) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'setPresentationMode' must not be null";
        this.m_presentationMode = presentationMode;
        this.m_nullNode.setPresentationMode(presentationMode);
        this.m_nullNode.resetRelativePath();
    }

    public synchronized ResetInfo startModification() {
        assert (!this.m_inModification) : "'m_inModification' of method 'startModification' already set to 'true'";
        ResetInfo resetInfo = new ResetInfo(this.m_nodeToOriginalLocation);
        this.m_nodeToOriginalLocation = new LinkedHashMap<AssignableToArtifactNode, NodeLocation>();
        this.m_assignableNodeToArtifactNode.clear();
        this.m_deletedProgrammingElements.clear();
        this.m_deletedParserDependencies.clear();
        this.m_representationInfo.clear();
        this.m_inModification = true;
        return resetInfo;
    }

    public boolean inInitialCreation() {
        return this.m_inInitialCreation;
    }

    public boolean inModification() {
        return this.m_inModification;
    }

    public void setInEditOperation(boolean inEdit) {
        assert (this.m_inEditOperation != inEdit) : "'m_inEditOperation' already set to: " + inEdit;
        this.m_inEditOperation = inEdit;
    }

    public boolean isInEditOperation() {
        return this.m_inEditOperation;
    }

    public void setInTransfer(boolean inTransfer) {
        assert (this.m_inTransfer != inTransfer) : "'m_inTransfer' already set to: " + inTransfer;
        this.m_inTransfer = inTransfer;
    }

    public boolean isInTransfer() {
        return this.m_inTransfer;
    }

    public void addExcludedProgrammingElement(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'addExcludedProgrammingElement' must not be null";
        this.m_excludedProgrammingElements.add(element);
    }

    private boolean structureModeIncludes(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'structureModeIncludes' must not be null";
        return this.m_structureMode.isLogical() ? element.includeInLogicalModel() : true;
    }

    public static ProgrammingElement includeParserDependency(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'includeParserDependency' must not be null";
        if (!dependency.isArchitectureRelevant() || dependency.getRefactoringState().hasBeenDeleted()) {
            return null;
        }
        ProgrammingElement from = dependency.getFrom();
        if (from.isGhost() || from.isExcluded() || from.isExternal() || from.getRefactoringState().hasBeenDeleted()) {
            return null;
        }
        ProgrammingElement to = dependency.getTo();
        if (to.isGhost() || to.isExcluded() || to.getRefactoringState().hasBeenDeleted()) {
            return null;
        }
        return from;
    }

    public boolean includeParserDependency(ParserDependency dependency, ParserDependencyEndPoints endPoints) {
        assert (dependency != null) : "Parameter 'dependency' of method 'includeParserDependency' must not be null";
        assert (endPoints != null) : "Parameter 'endPoints' of method 'includeParserDependency' must not be null";
        if (!dependency.isArchitectureRelevant() || this.m_excludedParserDependencies.contains(dependency) || this.m_deletedParserDependencies.contains(dependency)) {
            return false;
        }
        ProgrammingElement from = dependency.getFrom();
        if (this.m_excludedProgrammingElements.contains(from) || this.m_deletedProgrammingElements.contains(from)) {
            return false;
        }
        if (from.isGhost()) {
            LOGGER.error("'from' is 'ghost': " + String.valueOf(from));
            return false;
        }
        if (!this.structureModeIncludes(from)) {
            LOGGER.error("'from' not included by structure mode: " + String.valueOf(from));
            return false;
        }
        ProgrammingElement to = dependency.getTo();
        if (this.m_excludedProgrammingElements.contains(to) || this.m_deletedProgrammingElements.contains(to)) {
            return false;
        }
        if (to.isGhost()) {
            LOGGER.error("'to' is 'ghost': " + String.valueOf(to));
            return false;
        }
        if (!this.structureModeIncludes(to)) {
            LOGGER.error("'to' not included by structure mode: " + String.valueOf(to));
            return false;
        }
        endPoints.set(from, to);
        return true;
    }

    public ParserDependencyState includeOutgoingParserDependency(ProgrammingElement origin, ParserDependency dependency, boolean considerFocus, ParserDependencyEndPoints endPoints) {
        assert (origin != null) : "Parameter 'origin' of method 'includeOutgoingParserDependency' must not be null";
        assert (dependency != null) : "Parameter 'dependency' of method 'includeParserDependency' must not be null";
        ProgrammingElement from = dependency.getFrom();
        if (origin != from) {
            return ParserDependencyState.EXCLUDED_BY_DIRECTION;
        }
        if (!dependency.isArchitectureRelevant() || this.m_excludedParserDependencies.contains(dependency) || this.m_deletedParserDependencies.contains(dependency)) {
            return ParserDependencyState.EXCLUDED;
        }
        if (from.isGhost()) {
            LOGGER.error("'from' is 'ghost': " + String.valueOf(from));
            return ParserDependencyState.EXCLUDED;
        }
        if (!this.structureModeIncludes(from)) {
            LOGGER.error("'from' not included by structure mode: " + String.valueOf(from));
            return ParserDependencyState.EXCLUDED;
        }
        if (this.m_excludedProgrammingElements.contains(from) || this.m_deletedProgrammingElements.contains(from)) {
            return ParserDependencyState.EXCLUDED;
        }
        ProgrammingElement to = dependency.getTo();
        if (this.m_excludedProgrammingElements.contains(to) || this.m_deletedProgrammingElements.contains(to)) {
            return ParserDependencyState.EXCLUDED;
        }
        if (to.isGhost()) {
            LOGGER.error("'to' is 'ghost': " + String.valueOf(to));
            return ParserDependencyState.EXCLUDED;
        }
        if (!this.structureModeIncludes(to)) {
            LOGGER.error("'to' not included by structure mode: " + String.valueOf(to));
            return ParserDependencyState.EXCLUDED;
        }
        if (endPoints != null) {
            endPoints.set(from, to);
        }
        if (considerFocus && !this.m_focus.isEmpty() && !this.m_focus.includesParserDependency(dependency, from, to)) {
            return ParserDependencyState.EXCLUDED_BY_FOCUS;
        }
        return ParserDependencyState.INCLUDED;
    }

    public ParserDependencyState includeIncomingParserDependency(ProgrammingElement origin, ParserDependency dependency, boolean considerFocus, ParserDependencyEndPoints endPoints) {
        assert (origin != null) : "Parameter 'origin' of method 'includeIncomingParserDependency' must not be null";
        assert (dependency != null) : "Parameter 'dependency' of method 'includeIncomingParserDependency' must not be null";
        ProgrammingElement to = dependency.getTo();
        if (origin != to) {
            return ParserDependencyState.EXCLUDED_BY_DIRECTION;
        }
        if (!dependency.isArchitectureRelevant() || this.m_excludedParserDependencies.contains(dependency) || this.m_deletedParserDependencies.contains(dependency)) {
            return ParserDependencyState.EXCLUDED;
        }
        if (to.isGhost()) {
            LOGGER.error("'to' is 'ghost': " + String.valueOf(to));
            return ParserDependencyState.EXCLUDED;
        }
        if (!this.structureModeIncludes(to)) {
            LOGGER.error("'to' not included by structure mode: " + String.valueOf(to));
            return ParserDependencyState.EXCLUDED;
        }
        if (this.m_excludedProgrammingElements.contains(to) || this.m_deletedProgrammingElements.contains(to)) {
            return ParserDependencyState.EXCLUDED;
        }
        ProgrammingElement from = dependency.getFrom();
        if (this.m_excludedProgrammingElements.contains(from) || this.m_deletedProgrammingElements.contains(from)) {
            return ParserDependencyState.EXCLUDED;
        }
        if (from.isGhost()) {
            LOGGER.error("'from' is 'ghost': " + String.valueOf(from));
            return ParserDependencyState.EXCLUDED;
        }
        if (!this.structureModeIncludes(from)) {
            LOGGER.error("'from' not included by structure mode: " + String.valueOf(from));
            return ParserDependencyState.EXCLUDED;
        }
        if (endPoints != null) {
            endPoints.set(from, to);
        }
        if (considerFocus && !this.m_focus.isEmpty() && !this.m_focus.includesParserDependency(dependency, from, to)) {
            return ParserDependencyState.EXCLUDED_BY_FOCUS;
        }
        return ParserDependencyState.INCLUDED;
    }

    public boolean isExcluded(ProgrammingElement programmingElement) {
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'include' must not be null";
        return this.m_excludedProgrammingElements.contains(programmingElement);
    }

    public synchronized void finishInitialElementCreation() {
        assert (this.m_inInitialCreation) : "Not in initial creation";
        LOGGER.debug("Finish initial element creation");
        for (ProgrammingElement nextProgrammingElement : this.m_programmingElementToLeafNode.keySet()) {
            assert (!this.m_excludedProgrammingElements.contains(nextProgrammingElement)) : "Is excluded: " + String.valueOf(nextProgrammingElement);
            assert (!nextProgrammingElement.isExcluded()) : "isExcluded() == true";
            assert (!nextProgrammingElement.getRefactoringState().hasBeenDeleted()) : "Is deleted: " + String.valueOf(nextProgrammingElement);
            assert (nextProgrammingElement.getParent() != null) : "Has no parent: " + String.valueOf(nextProgrammingElement);
            boolean nextProgrammingElementIsExternal = nextProgrammingElement.isExternal();
            Iterator<ParserDependency> nextIterator = nextProgrammingElement.getDependencyIterator();
            while (nextIterator.hasNext()) {
                ParserDependency nextParserDependency = nextIterator.next();
                if (!nextParserDependency.isArchitectureRelevant() || this.m_excludedParserDependencies.contains(nextParserDependency)) continue;
                ProgrammingElement nextFrom = nextParserDependency.getFrom();
                if (nextProgrammingElement == nextFrom) {
                    ProgrammingElement nextTo = nextParserDependency.getTo();
                    if (nextTo == null) {
                        LOGGER.error("Ignoring invalid parser dependency ('to' is null): " + nextParserDependency.getClass().getName());
                        this.m_excludedParserDependencies.add(nextParserDependency);
                        continue;
                    }
                    if (this.m_excludedProgrammingElements.contains(nextTo)) continue;
                    if (nextTo.isExcluded()) {
                        this.m_excludedProgrammingElements.add(nextTo);
                        continue;
                    }
                    if (nextProgrammingElementIsExternal || nextParserDependency.getRefactoringState().hasBeenDeleted()) {
                        this.m_excludedParserDependencies.add(nextParserDependency);
                        continue;
                    }
                    ++this.m_parserDependencies;
                    continue;
                }
                if (nextFrom == null) {
                    LOGGER.error("Ignoring invalid parser dependency ('from' is null): " + nextParserDependency.getClass().getName());
                    this.m_excludedParserDependencies.add(nextParserDependency);
                    continue;
                }
                if (this.m_excludedProgrammingElements.contains(nextFrom)) continue;
                if (nextFrom.isExcluded()) {
                    this.m_excludedProgrammingElements.add(nextFrom);
                    continue;
                }
                if (!nextFrom.isExternal() && !nextParserDependency.getRefactoringState().hasBeenDeleted()) continue;
                this.m_excludedParserDependencies.add(nextParserDependency);
            }
            if (nextProgrammingElementIsExternal) {
                ++this.m_externalProgrammingElements;
                continue;
            }
            ++this.m_internalProgrammingElements;
        }
        LOGGER.debug("Finish initial element creation - done [" + this.m_programmingElementToLeafNode.size() + " programming elements with " + this.m_parserDependencies + " parser dependencies]");
    }

    public synchronized void finishInitialElementStructure(int internalAssignableToArtifactNodes, int externalAssignableToArtifactNodes) {
        LOGGER.debug("Finish initial element structure");
        this.m_internalAssignableToArtifactNodes = internalAssignableToArtifactNodes;
        this.m_externalAssignableToArtifactNodes = externalAssignableToArtifactNodes;
        LOGGER.debug("Finish initial element structure - done");
    }

    public void modificationFinished() {
        assert (this.m_inModification) : "Already finished modification";
        this.m_inModification = false;
        this.m_inInitialCreation = false;
    }

    @Override
    public boolean contributesFullyQualifiedNamePartToRelativePath() {
        return false;
    }

    @Override
    protected void addedAsChildTo(ArchitecturalViewElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'addedTo' must not be null";
        assert (false) : "Root element: " + this.getElementInfo();
    }

    @Override
    public void finishModification() {
        LOGGER.debug("Finish modification");
        super.finishModification();
    }

    @Override
    public Collection<ProgrammingElement> getProgrammingElements() {
        return Collections.unmodifiableSet(this.m_programmingElementToLeafNode.keySet());
    }

    public boolean includeProgrammingElement(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'includeProgrammingElement' must not be null";
        return this.m_programmingElementToLeafNode.containsKey(element);
    }

    public void assignProgrammingElementsToLeafNode(List<ProgrammingElement> elements, ArchitecturalViewNode node) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'assignProgrammingElementsToLeafNode' must not be empty";
        assert (node != null) : "Parameter 'node' of method 'assignProgrammingElementToLeafNode' must not be null";
        for (ProgrammingElement nextElement : elements) {
            assert (!(nextElement instanceof EmptyNodeProgrammingElement)) : "Unexpected class: " + nextElement.getClass().getSimpleName();
            assert (!this.m_excludedProgrammingElements.contains(nextElement)) : "Is excluded: " + String.valueOf(nextElement);
            assert (!nextElement.getRefactoringState().hasBeenDeleted()) : "Is deleted: " + String.valueOf(nextElement);
            assert (!nextElement.isExcluded()) : "Is excluded: " + String.valueOf(nextElement);
            assert (nextElement.getParent() != null) : "Has no parent: " + String.valueOf(nextElement);
            ArchitecturalViewNode alreadyAssignedTo = this.m_programmingElementToLeafNode.get(nextElement);
            if (alreadyAssignedTo == null) {
                this.m_programmingElementToLeafNode.put(nextElement, node);
                continue;
            }
            if (alreadyAssignedTo == node) {
                LOGGER.error("Programming element already assigned to same leaf node!");
                LOGGER.error("Programming element: " + nextElement.getFullyQualifiedName() + " [" + nextElement.getClass().getName() + "]");
                LOGGER.error("Leaf node: " + node.getElementInfo());
                continue;
            }
            LOGGER.error("Programming element already assigned to another leaf node!");
            LOGGER.error("Programming element: " + nextElement.getFullyQualifiedName() + " [" + nextElement.getClass().getName() + "]");
            LOGGER.error("Already assigned to leaf node: " + alreadyAssignedTo.getElementInfo());
            LOGGER.error("Ignoring assignment to leaf node: " + node.getElementInfo());
        }
    }

    public void reAssignProgrammingElementToLeafNode(ProgrammingElement element, ProgrammingElementNode node) {
        assert (element != null) : "Parameter 'element' of method 'reAssignProgrammingElementToLeafNode' must not be null";
        assert (!(element instanceof EmptyNodeProgrammingElement)) : "Unexpected class: " + element.getClass().getSimpleName();
        assert (node != null) : "Parameter 'node' of method 'reAssignProgrammingElementToLeafNode' must not be null";
        ArchitecturalViewNode previous = this.m_programmingElementToLeafNode.put(element, node);
        assert (previous != null) : "'previous' of method 'reAssignProgrammingElementToLeafNode' must not be null";
        assert (!this.m_excludedProgrammingElements.contains(element)) : "Is excluded: " + String.valueOf(element);
        assert (!element.getRefactoringState().hasBeenDeleted()) : "Is deleted: " + String.valueOf(element);
        assert (!element.isExcluded()) : "Is excluded: " + String.valueOf(element);
        assert (element.getParent() != null) : "Has no parent: " + String.valueOf(element);
    }

    public Set<ProgrammingElement> getDeletedProgrammingElements() {
        return Collections.unmodifiableSet(this.m_deletedProgrammingElements);
    }

    public Set<ParserDependency> getDeletedParserDependencies() {
        return Collections.unmodifiableSet(this.m_deletedParserDependencies);
    }

    public boolean hasParserDependencyBeenDeleted(ParserDependency parserDependency) {
        assert (parserDependency != null) : "Parameter 'parserDependency' of method 'hasParserDependencyBeenDeleted' must not be null";
        return this.m_deletedParserDependencies.contains(parserDependency);
    }

    public Map<AssignableToArtifactNode, NodeLocation> getOriginalLocations() {
        return Collections.unmodifiableMap(this.m_nodeToOriginalLocation);
    }

    public NodeLocation getOriginalLocation(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'getOriginalLocation' must not be null";
        return this.m_nodeToOriginalLocation.get(node);
    }

    public void removeOriginalLocation(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'removeOriginalLocation' must not be null";
        NodeLocation location = this.m_nodeToOriginalLocation.remove(node);
        assert (location != null) : "'location' of method 'removeOriginalLocation' must not be null";
    }

    public void addOriginalLocation(AssignableToArtifactNode node, NodeLocation location) {
        assert (node != null) : "Parameter 'node' of method 'addOriginalLocation' must not be null";
        assert (location != null) : "Parameter 'location' of method 'addOriginalLocation' must not be null";
        NodeLocation previous = this.m_nodeToOriginalLocation.put(node, location);
        assert (previous == null) : "'previous' of method 'addOriginalLocation' must be null";
    }

    public void addDeletedProgrammingElements(Collection<ProgrammingElement> deleted) {
        assert (deleted != null && !deleted.isEmpty()) : "Parameter 'deleted' of method 'addDeletedProgrammingElements' must not be empty";
        this.m_deletedProgrammingElements.addAll(deleted);
    }

    public boolean hasProgrammingElementBeenDeleted(ProgrammingElement programmingElement) {
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'hasProgrammingElementBeenDeleted' must not be null";
        return this.m_deletedProgrammingElements.contains(programmingElement);
    }

    public boolean hasDeletedProgrammingElements() {
        return !this.m_deletedProgrammingElements.isEmpty();
    }

    public synchronized void addDeletedParserDependencies(Collection<ParserDependency> deleted) {
        assert (deleted != null && !deleted.isEmpty()) : "Parameter 'deleted' of method 'addDeletedParserDependencies' must not be empty";
        this.m_deletedParserDependencies.addAll(deleted);
    }

    public ArchitecturalViewNode getLeafNode(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'getLeafNode' must not be null";
        return this.m_programmingElementToLeafNode.get(element);
    }

    public Map<AssignableToArtifactNode, ArtifactNode> clearAssignableToArtifactCache() {
        this.m_assignableNodeToArtifactNode.clear();
        return this.m_assignableNodeToArtifactNode;
    }

    public ArtifactNode getArtifactNode(ProgrammingElement element) {
        ArchitecturalViewNode leaf = this.m_programmingElementToLeafNode.get(element);
        if (leaf != null) {
            if (leaf instanceof AssignableToArtifactNode) {
                return this.m_assignableNodeToArtifactNode.get(leaf);
            }
            AssignableToArtifactNode assignableNode = leaf.getParent(AssignableToArtifactNode.class, new Class[0]);
            assert (assignableNode != null) : "'assignableNode' of method 'getAssignableNode' must not be null";
            return this.m_assignableNodeToArtifactNode.get(assignableNode);
        }
        return null;
    }

    public synchronized Map<ParserDependency, Set<String>> getViolations(boolean includeIgnored) {
        return this.m_representationInfo.getViolations(includeIgnored);
    }

    public synchronized Map<ParserDependency, Set<String>> getDeprecations(boolean includeIgnored) {
        return this.m_representationInfo.getDeprecations(includeIgnored);
    }

    public synchronized void clearDependencyInfo(boolean clearIgnoredAndToBeFixed) {
        this.m_representationInfo.clearDependencyInfo(clearIgnoredAndToBeFixed);
    }

    public synchronized boolean addArchitectureViolation(List<ParserDependency> parserDependencies, String cause) {
        return this.m_representationInfo.addArchitectureViolation(parserDependencies, cause);
    }

    public synchronized void addViolationsIgnored(Collection<ParserDependency> ignoring) {
        this.m_representationInfo.addViolationsIgnored(ignoring);
    }

    @Override
    @IntProperty
    public synchronized int getNumberOfProgrammingElements() {
        return this.m_internalProgrammingElements;
    }

    @IntProperty
    public synchronized int getNumberOfProgrammingElementsExternal() {
        return this.m_externalProgrammingElements;
    }

    @IntProperty
    public synchronized int getNumberOfParserDependencies() {
        return this.m_parserDependencies;
    }

    public synchronized ParserDependencyNumbers getParserDependencyNumbers() {
        return this.m_representationInfo.getParserDependencyNumbers(this.m_parserDependencies);
    }

    @Property
    public synchronized String getNumberOfParserDependenciesViolating() {
        if (this.m_representationInfo.hasViolations()) {
            ParserDependencyNumbers numbers = this.getParserDependencyNumbers();
            return ExplorationViewFocus.getParserDependenciesViolatingInfo(numbers.getViolations(), numbers.getViolationsIgnored(), numbers.getAll());
        }
        return null;
    }

    @IntProperty(undefinedValue=-1)
    public synchronized int getNumberOfComponents() {
        return this.getStructureMode().isPhysical() ? this.m_internalAssignableToArtifactNodes : -1;
    }

    @IntProperty(undefinedValue=-1)
    public synchronized int getNumberOfComponentsExternal() {
        return this.getStructureMode().isPhysical() ? this.m_externalAssignableToArtifactNodes : -1;
    }

    @IntProperty(undefinedValue=-1)
    public synchronized int getNumberOfLogicalToplevelProgrammingElements() {
        return this.getStructureMode().isLogical() ? this.m_internalAssignableToArtifactNodes : -1;
    }

    @IntProperty(undefinedValue=-1)
    public synchronized int getNumberOfLogicalToplevelProgrammingElementsExternal() {
        return this.getStructureMode().isLogical() ? this.m_externalAssignableToArtifactNodes : -1;
    }

    @Property
    public synchronized String getAppliedFocus() {
        return this.m_focus.getInfo(this.m_representationInfo.getViolating(), this.m_representationInfo.getViolatingIgnored(), this.m_parserDependencies, this.m_structureMode.isPhysical() ? "component" : "logical toplevel programming element", this.m_internalAssignableToArtifactNodes, this.m_externalAssignableToArtifactNodes);
    }

    @Override
    public synchronized ViolationInfo isViolation(ParserDependency dependency) {
        return this.m_representationInfo.isViolation(dependency);
    }

    @Override
    public synchronized DeprecationInfo isDeprecation(ParserDependency dependency) {
        return this.m_representationInfo.isDeprecation(dependency);
    }

    @Override
    public synchronized Collection<Issue> getIssues(ParserDependency parserDependency) {
        return this.m_representationInfo.getIssues(parserDependency);
    }

    @Override
    public List<ArchitecturalViewNode> getVisibleNodeChildren() {
        return this.getChildren(ArchitecturalViewNode.class).stream().filter(ArchitecturalViewElement.NOT_REMOVED).collect(Collectors.toList());
    }

    @Override
    public List<ArchitecturalViewNode> getSortedVisibleNodeChildren() {
        return this.getChildren(ArchitecturalViewNode.class).stream().filter(ArchitecturalViewElement.NOT_REMOVED).sorted().collect(Collectors.toList());
    }

    public List<ArchitecturalViewNode> getAllNodeChildren(Predicate<ArchitecturalViewElement> include, boolean sorted) {
        assert (include != null) : "Parameter 'include' of method 'getAllNodeChildren' must not be null";
        return sorted ? this.getChildren(ArchitecturalViewNode.class).parallelStream().filter(include).sorted().collect(Collectors.toList()) : this.getChildren(ArchitecturalViewNode.class).parallelStream().filter(include).collect(Collectors.toList());
    }

    public List<PatternType> getPatternTypes(Set<Language> available) {
        assert (available != null && !available.isEmpty()) : "Parameter 'available' of method 'getPatternTypes' must not be empty";
        ArrayList<PatternType> corePatternTypes = new ArrayList<PatternType>();
        ArrayList<PatternType> languagePatternTypes = new ArrayList<PatternType>();
        for (IAssignableAttributeRetriever next : this.m_nameToRetriever.values()) {
            if (!next.availableFor(this.m_structureMode.getArchitectureModel())) continue;
            Language nextLanguage = next.getLanguage();
            if (nextLanguage == null) {
                corePatternTypes.add(new PatternType(next));
                continue;
            }
            if (!available.contains(nextLanguage)) continue;
            languagePatternTypes.add(new PatternType(next));
        }
        PatternTypeComparator comparator = new PatternTypeComparator();
        Collections.sort(corePatternTypes, comparator);
        Collections.sort(languagePatternTypes, comparator);
        ArrayList<PatternType> all = new ArrayList<PatternType>(corePatternTypes);
        all.addAll(languagePatternTypes);
        return all;
    }

    @Override
    public IAssignableAttributeRetriever getAttributeRetriever(String name) {
        assert (name != null) : "Parameter 'name' of method 'getAttributeRetriever' must not be null";
        return this.m_nameToRetriever.get(name);
    }

    @Override
    public String getDefaultRetrieverName() {
        return this.m_defaultRetriever;
    }

    public Collection<IAssignableAttributeRetriever> getAttributeRetrievers() {
        return Collections.unmodifiableCollection(this.m_nameToRetriever.values());
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitExplorationViewRepresentation(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface ILazyArchitecturalViewElementCreator {
        public void aboutToAccessChildrenOf(ArchitecturalViewElement var1, ExplorationViewRepresentation var2);
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitExplorationViewRepresentation(ExplorationViewRepresentation var1);
    }
}

