/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.element.pattern;

import com.hello2morrow.sonargraph.core.model.element.IIssueWithLineContext;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.pattern.SimilarityMatchPattern;
import com.hello2morrow.sonargraph.foundation.text.IntBasedHash;
import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import com.hello2morrow.sonargraph.integration.access.foundation.Utility;

public final class LineBasedContextSimilarityMatchPattern
extends SimilarityMatchPattern {
    private final String m_line;
    private final int m_lineNumber;
    private final IntBasedHash m_prefixHashs;
    private final IntBasedHash m_postfixHashs;
    private final String m_sourceFileOriginalFqName;

    public LineBasedContextSimilarityMatchPattern(NamedElement parent, String pattern, String sourceFileOriginalFqName, String line, int lineNumber, IntBasedHash prefix, IntBasedHash postfix) {
        super(parent, pattern);
        assert (sourceFileOriginalFqName != null && sourceFileOriginalFqName.length() > 0) : "Parameter 'sourceFileOriginalFqName' of method 'LineBasedContextSimilarityMatchPattern' must not be empty";
        assert (line != null) : "Parameter 'line' of method 'LineBasedContextSimilarityMatchPattern' must not be null";
        assert (prefix != null) : "Parameter 'prefix' of method 'LineBasedContextSimilarityMatchPattern' must not be null";
        assert (postfix != null) : "Parameter 'postfix' of method 'LineBasedContextSimilarityMatchPattern' must not be null";
        this.m_sourceFileOriginalFqName = sourceFileOriginalFqName;
        this.m_line = line;
        this.m_lineNumber = lineNumber;
        this.m_prefixHashs = prefix;
        this.m_postfixHashs = postfix;
    }

    public LineBasedContextSimilarityMatchPattern(NamedElement parent, String pattern, DataFromPattern data) {
        this(parent, pattern, data.m_sourceFileOriginalFqName, data.m_line, data.m_lineNumber, data.m_prefixHashs, data.m_postfixHashs);
    }

    public String getSourceFileOriginalFqName() {
        return this.m_sourceFileOriginalFqName;
    }

    @Override
    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public String getLine() {
        return this.m_line;
    }

    public IntBasedHash getPostfixHashs() {
        return this.m_postfixHashs;
    }

    public IntBasedHash getPrefixHashs() {
        return this.m_prefixHashs;
    }

    public static String createPattern(String sourceFileFqName, int lineNumber, String line, IntBasedHash prefixHashs, IntBasedHash postfixHashs) {
        assert (sourceFileFqName != null && sourceFileFqName.length() > 0) : "Parameter 'sourceFileFqName' of method 'createPattern' must not be empty";
        assert (lineNumber > 0) : "Invalid line number: " + lineNumber;
        assert (line != null && line.length() > 0) : "Parameter 'line' of method 'createPattern' must not be empty";
        assert (prefixHashs != null) : "Parameter 'prefixHashs' of method 'createPattern' must not be null";
        assert (postfixHashs != null) : "Parameter 'postfixHashs' of method 'createPattern' must not be null";
        StringBuilder result = new StringBuilder(sourceFileFqName);
        result.append(':');
        result.append(HashSupport.MD5.getHexString(line.trim()));
        result.append(':');
        result.append(lineNumber);
        result.append(':');
        result.append(prefixHashs.hashCode());
        result.append(':');
        result.append(postfixHashs.hashCode());
        return result.toString();
    }

    public static String encodeOriginalFqName(String originalFullyQualifiedName) {
        assert (originalFullyQualifiedName != null && originalFullyQualifiedName.length() > 0) : "Parameter 'originalFullyQualifiedName' of method 'convertOriginalFqName' must not be empty";
        return originalFullyQualifiedName.replace(DESCRIPTOR_NAME_PARTS_SEPARATOR, INNER_NAME_PARTS_SEPARATOR);
    }

    public static String decodeOriginalFqName(String encodedFqName) {
        assert (encodedFqName != null && encodedFqName.length() > 0) : "Parameter 'encodedFqName' of method 'decodeOriginalFqName' must not be empty";
        return encodedFqName.replace(INNER_NAME_PARTS_SEPARATOR, DESCRIPTOR_NAME_PARTS_SEPARATOR);
    }

    public static String createPattern(IIssueWithLineContext lineContextIssue) {
        assert (lineContextIssue != null) : "Parameter 'lineContextIssue' of method 'createPattern' must not be null";
        NamedElement element = (NamedElement)lineContextIssue.getAffectedElement();
        String fqNameOfSource = element.getOriginalFullyQualifiedName();
        return LineBasedContextSimilarityMatchPattern.createPattern(fqNameOfSource, lineContextIssue.getLineNumber(), lineContextIssue.getLineText(), lineContextIssue.getPrefixHashs(), lineContextIssue.getPostfixHashs());
    }

    public static String createPatternForPersistence(IIssueWithLineContext lineContextIssue) {
        assert (lineContextIssue != null) : "Parameter 'lineContextIssue' of method 'createPatternForPersistence' must not be null";
        NamedElement element = (NamedElement)lineContextIssue.getAffectedElement();
        String fqNameOfSource = LineBasedContextSimilarityMatchPattern.encodeOriginalFqName(element.getOriginalFullyQualifiedName());
        return LineBasedContextSimilarityMatchPattern.createPattern(fqNameOfSource, lineContextIssue.getLineNumber(), lineContextIssue.getLineText(), lineContextIssue.getPrefixHashs(), lineContextIssue.getPostfixHashs());
    }

    public String getPatternForPersistence() {
        return LineBasedContextSimilarityMatchPattern.createPattern(LineBasedContextSimilarityMatchPattern.encodeOriginalFqName(this.m_sourceFileOriginalFqName), this.m_lineNumber, this.m_line, this.m_prefixHashs, this.m_postfixHashs);
    }

    public String getHash() {
        return LineBasedContextSimilarityMatchPattern.createHash(this.m_sourceFileOriginalFqName, this.m_line, this.m_lineNumber, this.m_prefixHashs, this.m_postfixHashs);
    }

    public static String createHash(IIssueWithLineContext lineContextIssue) {
        assert (lineContextIssue != null) : "Parameter 'lineContextIssue' of method 'createHash' must not be null";
        NamedElement element = (NamedElement)lineContextIssue.getAffectedElement();
        String fqNameOfSource = element.getOriginalFullyQualifiedName();
        return LineBasedContextSimilarityMatchPattern.createHash(fqNameOfSource, lineContextIssue.getLineText(), lineContextIssue.getLineNumber(), lineContextIssue.getPrefixHashs(), lineContextIssue.getPostfixHashs());
    }

    private static String createHash(String sourceFileOriginalFqName, String line, int lineNumber, IntBasedHash prefixHashs, IntBasedHash postfixHashs) {
        assert (sourceFileOriginalFqName != null && sourceFileOriginalFqName.length() > 0) : "Parameter 'sourceFileOriginalFqName' of method 'createHash' must not be empty";
        assert (line != null) : "Parameter 'line' of method 'createHash' must not be null";
        assert (prefixHashs != null) : "Parameter 'prefixHashs' of method 'createHash' must not be null";
        assert (postfixHashs != null) : "Parameter 'postfixHashs' of method 'createHash' must not be null";
        String fqName = LineBasedContextSimilarityMatchPattern.encodeOriginalFqName(sourceFileOriginalFqName);
        StringBuilder hash = new StringBuilder(fqName);
        hash.append(':');
        hash.append(Utility.base64Encode((String)line));
        hash.append(':');
        hash.append(lineNumber);
        hash.append(':');
        hash.append(IntBasedHash.encode((IntBasedHash)prefixHashs));
        hash.append(':');
        hash.append(IntBasedHash.encode((IntBasedHash)postfixHashs));
        return hash.toString();
    }

    public static final class DataFromPattern {
        private final String m_sourceFileOriginalFqName;
        private final String m_line;
        private final int m_lineNumber;
        private final IntBasedHash m_prefixHashs;
        private final IntBasedHash m_postfixHashs;

        public DataFromPattern(String sourceFileOriginalFqName, String line, int lineNumber, IntBasedHash prefixHashs, IntBasedHash postfixHashs) {
            assert (sourceFileOriginalFqName != null && sourceFileOriginalFqName.length() > 0) : "Parameter 'sourceFileOriginalFqName' of method 'DataFromPattern' must not be empty";
            assert (line != null) : "Parameter 'line' of method 'DataFromPattern' must not be null";
            assert (prefixHashs != null) : "Parameter 'prefixHashs' of method 'DataFromPattern' must not be null";
            assert (postfixHashs != null) : "Parameter 'postfixHashs' of method 'DataFromPattern' must not be null";
            this.m_sourceFileOriginalFqName = sourceFileOriginalFqName;
            this.m_line = line;
            this.m_lineNumber = lineNumber;
            this.m_prefixHashs = prefixHashs;
            this.m_postfixHashs = postfixHashs;
        }
    }
}

