/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.sonargraph.core.foundation.common.graph.Adjacency;
import com.hello2morrow.sonargraph.core.foundation.common.graph.MinimizerPolyLogBarnesHut;
import com.hello2morrow.sonargraph.core.foundation.common.graph.PrecisionLocation;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public final class SpringEmbedderLayoutAlgorithm<V> {
    public Map<V, PrecisionLocation> layout(Adjacency<V> adjacency) {
        assert (adjacency != null) : "Parameter 'adjacency' of method 'layout' must not be null";
        assert (!adjacency.isEmpty()) : "'adjacency' must not be empty";
        THashMap locations = new THashMap(adjacency.size());
        ArrayList<V> nonIsolated = new ArrayList<V>(adjacency.mkAllNodesCopy());
        int nonIsolatedNodeCount = nonIsolated.size();
        if (nonIsolatedNodeCount > 0) {
            double diffY;
            float[][] attraction = new float[nonIsolatedNodeCount][nonIsolatedNodeCount];
            int i = 0;
            while (i < nonIsolatedNodeCount) {
                Object fromNode = nonIsolated.get(i);
                Set<V> followerNodes = adjacency.getFollowerNodesRef(fromNode);
                if (followerNodes != null) {
                    for (V toNode : followerNodes) {
                        if (fromNode == toNode) continue;
                        int j = nonIsolated.indexOf(toNode);
                        float weight = adjacency.getWeight(fromNode, toNode);
                        float[] fArray = attraction[i];
                        int n = j;
                        fArray[n] = fArray[n] + weight;
                        float[] fArray2 = attraction[j];
                        int n2 = i;
                        fArray2[n2] = fArray2[n2] + weight;
                    }
                }
                ++i;
            }
            float[][] position = new float[nonIsolatedNodeCount][3];
            Random random = new Random(-17L);
            int idx = 0;
            while (idx < nonIsolatedNodeCount) {
                position[idx][0] = random.nextInt(1000);
                position[idx][1] = random.nextInt(1000);
                ++idx;
            }
            MinimizerPolyLogBarnesHut minimizer = new MinimizerPolyLogBarnesHut(nonIsolatedNodeCount, attraction, position, 0.075f, 3.0f);
            minimizer.minimizeEnergy(100);
            float minX = Float.MAX_VALUE;
            float maxX = -minX;
            float minY = minX;
            float maxY = -minX;
            double minDist = minX;
            int i2 = 0;
            while (i2 < nonIsolatedNodeCount) {
                float x = position[i2][0];
                float y = position[i2][1];
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y > maxY) {
                    maxY = y;
                }
                int j = 0;
                while (j < nonIsolatedNodeCount) {
                    float yj;
                    float xj;
                    double dist;
                    if (i2 != j && (dist = Math.sqrt((x - (xj = position[j][0])) * (x - xj) + (y - (yj = position[j][1])) * (y - yj))) != 0.0 && dist < minDist) {
                        minDist = dist;
                    }
                    ++j;
                }
                ++i2;
            }
            double diffX = maxX - minX;
            if (diffX == 0.0) {
                diffX = 1.0;
            }
            if ((diffY = (double)(maxY - minY)) == 0.0) {
                diffY = 1.0;
            }
            double scaleFactor = Math.min(300.0 / diffX, 300.0 / diffY);
            scaleFactor = Math.max(1000.0 / diffX, scaleFactor);
            scaleFactor = Math.max(700.0 / diffY, scaleFactor);
            if (minDist != 0.0) {
                scaleFactor = Math.max(scaleFactor, 5.0 / minDist);
                scaleFactor = Math.min(scaleFactor, 50.0 / minDist);
            }
            int nonIsolatedIndex = 0;
            float unconnectedSpace = 100.0f;
            for (Object next : nonIsolated) {
                double x = 100.0 + scaleFactor * (double)(position[nonIsolatedIndex][0] - minX);
                double y = scaleFactor * (double)(position[nonIsolatedIndex][1] - minY);
                locations.put(next, new PrecisionLocation(x, y));
                ++nonIsolatedIndex;
            }
        }
        return locations;
    }
}

