/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.sonargraph.core.foundation.common.graph.IInclusionChecker;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.NodeIndexBasedCalculator;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;

public abstract class DependencyCumulator
extends NodeIndexBasedCalculator {
    protected final BitSet[] m_reachable;
    protected final int[] m_cumulatedDependencies;
    protected final BitSet m_included;

    protected DependencyCumulator(Collection<? extends INode<?>> nodes, IWorkerContext workerContext, IInclusionChecker adapter) {
        super(nodes, workerContext, 2);
        assert (adapter != null) : "Parameter 'adapter' of method 'DependencyCumulator' must not be null";
        this.m_reachable = new BitSet[this.m_numberOfNodes];
        this.m_cumulatedDependencies = new int[this.m_numberOfNodes];
        Arrays.fill(this.m_cumulatedDependencies, -1);
        this.m_included = new BitSet(this.m_numberOfNodes);
        int index = 0;
        for (INode<?> nextNode : nodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            if (adapter.isNodeIncluded(nextNode)) {
                this.m_included.set(index);
            }
            ++index;
        }
        this.m_workerContext.endStep();
    }

    protected abstract INode<?> getEndpoint(INode.IEdge var1);

    protected abstract Collection<? extends INode.IEdge> getEdges(INode<?> var1);

    protected void computeReachebleNodes(INode<?> node, int index, BitSet visited) {
        assert (node != null) : "Parameter 'node' of method 'computeReachebleNodes' must not be null";
        assert (visited != null) : "Parameter 'visited' of method 'computeReachebleNodes' must not be null";
        BitSet result = new BitSet(this.m_numberOfNodes);
        boolean canStoreResult = this.m_reachable[index] == null;
        result.set(index);
        visited.set(index);
        for (INode.IEdge iEdge : this.getEdges(node)) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            INode<?> endPoint = this.getEndpoint(iEdge);
            int nextIndex = this.getIndex(endPoint);
            BitSet fromReachable = this.m_reachable[nextIndex];
            if (!visited.get(nextIndex)) {
                if (fromReachable == null) {
                    this.computeReachebleNodes(endPoint, nextIndex, visited);
                    canStoreResult = false;
                    continue;
                }
                result.or(fromReachable);
                continue;
            }
            if (fromReachable != null) {
                result.or(fromReachable);
                continue;
            }
            canStoreResult = false;
        }
        result.and(this.m_included);
        visited.or(result);
        if (canStoreResult) {
            this.m_reachable[index] = result;
        }
    }
}

