/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.controller.system.representation.ExtendableEndpointCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.PotentialDependencyCollector;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.DependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public final class BalancedDependencyIncomingOutgoingCollector
extends ExtendableEndpointCollector {
    private final Map<NamedElement, Map<NamedElement, PotentialDependencyCollector.MatchingType>> m_elementToAdditionalNodes;
    private final boolean m_allowDependenciesToSelf;
    private final DependencyType m_dependencyType;

    public BalancedDependencyIncomingOutgoingCollector(SoftwareSystem softwareSystem, Set<NamedElement> mainNodes, Map<NamedElement, Map<NamedElement, PotentialDependencyCollector.MatchingType>> elementToAdditionalNodes, Map<NamedElement, NamedElement> namedElementToProxy, IDomainRoot.Domain domain, DependencyType dependencyType) {
        super(softwareSystem, mainNodes, Collections.emptySet(), namedElementToProxy, (Set<CoreParserDependencyType>)new THashSet(Arrays.asList(CoreParserDependencyType.values())), domain, PresentationMode.FLAT, true, false, EndpointType.PARSER_DEPENDENCY);
        assert (elementToAdditionalNodes != null) : "Parameter 'elementToAdditionalNodes' of method 'SymmetricDependencyProgrammingElementCollector' must not be null";
        assert (dependencyType != null) : "Parameter 'dependencyType' of method 'SymmetricDependencyProgrammingElementCollector' must not be null";
        this.m_elementToAdditionalNodes = elementToAdditionalNodes;
        this.m_allowDependenciesToSelf = dependencyType == DependencyType.INTERNAL;
        this.m_dependencyType = dependencyType;
    }

    @Override
    public boolean addDependency(NamedElement from, NamedElement to, Dependency dependency) {
        assert (from != null) : "Parameter 'from' of method 'addDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'addDependency' must not be null";
        if (this.m_allowDependenciesToSelf || !from.equals(to)) {
            NamedElement referenceElement = this.m_dependencyType == DependencyType.INCOMING ? to : from;
            NamedElement endPoint = this.m_dependencyType == DependencyType.INCOMING ? from : to;
            Map<NamedElement, PotentialDependencyCollector.MatchingType> additionalNodes = this.m_elementToAdditionalNodes.get(referenceElement);
            if (additionalNodes != null) {
                boolean dependencyExists = additionalNodes.containsKey(endPoint);
                return dependencyExists;
            }
        }
        return false;
    }

    public DependencyType getDependencyType() {
        return this.m_dependencyType;
    }
}

