/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.plugin;

import com.hello2morrow.sonargraph.api.IElementAccess;
import com.hello2morrow.sonargraph.api.IExternalAccess;
import com.hello2morrow.sonargraph.api.IFieldAccess;
import com.hello2morrow.sonargraph.api.IMethodAccess;
import com.hello2morrow.sonargraph.api.IModuleAccess;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.api.IPluginIssueId;
import com.hello2morrow.sonargraph.api.IRoutineAccess;
import com.hello2morrow.sonargraph.api.ITypeAccess;
import com.hello2morrow.sonargraph.api.ModelVisitor;
import com.hello2morrow.sonargraph.core.api.model.ElementAccess;
import com.hello2morrow.sonargraph.core.api.model.RootAccess;
import com.hello2morrow.sonargraph.core.controller.system.api.AbstractCoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.api.CoreFactoryVisitor;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.plugin.PluginDependencyIssue;
import com.hello2morrow.sonargraph.core.model.plugin.PluginElementIssue;
import com.hello2morrow.sonargraph.core.model.plugin.PluginIssueId;
import com.hello2morrow.sonargraph.core.model.programming.AggregatedDependency;
import com.hello2morrow.sonargraph.core.model.programming.IField;
import com.hello2morrow.sonargraph.core.model.programming.IMethod;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginCoreAccess
extends AbstractCoreAccess
implements IPluginCoreAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginCoreAccess.class);

    public PluginCoreAccess(Installation installation, SoftwareSystem softwareSystem, boolean createFactory) {
        super(softwareSystem);
        if (createFactory) {
            this.m_factory = new CoreFactoryVisitor(installation, softwareSystem);
        }
    }

    public final List<IModuleAccess> getModules() {
        return ((SoftwareSystem)this.m_element).getUniqueExistingChild(Workspace.class).getChildren(Module.class).stream().map(m -> (IModuleAccess)this.m_factory.createAccessObject((NamedElement)m)).collect(Collectors.toList());
    }

    public final IExternalAccess getExternalRoot(String language) {
        assert (language != null && language.length() > 0) : "Parameter 'identifier' of method 'getExternalRoot' must not be empty";
        return this.getExternalRoot(language, language);
    }

    public final IExternalAccess getExternalRoot(String language, String identifier) {
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'getExternalRoot' must not be empty";
        assert (language != null && language.length() > 0) : "Parameter 'language' of method 'getExternalRoot' must not be empty";
        External external = ((SoftwareSystem)this.m_element).getUniqueExistingChild(Workspace.class).getChildren(External.class).stream().filter(e -> e.getIdentifier().equals(identifier) && e.getLanguage().getPresentationName().equals(language)).findFirst().orElse(null);
        if (external != null) {
            return (IExternalAccess)this.m_factory.createAccessObject(external);
        }
        return null;
    }

    private NamedElement getSearchRoot(INamedElementAccess searchRoot) {
        if (searchRoot == null) {
            return ((SoftwareSystem)this.m_element).getUniqueExistingChild(Workspace.class);
        }
        return (NamedElement)((ElementAccess)searchRoot).getElement();
    }

    public final ITypeAccess findFirstMatchingType(INamedElementAccess searchRoot, Predicate<ITypeAccess> predicate) {
        assert (predicate != null) : "Parameter 'predicate' of method 'findFirstMatchingType' must not be null";
        SearchVisitor<ITypeAccess> v = new SearchVisitor<ITypeAccess>(IType.class, predicate, 1, true);
        this.getSearchRoot(searchRoot).accept(v);
        List<ITypeAccess> result = v.getResult();
        return result.isEmpty() ? null : result.get(0);
    }

    public final List<ITypeAccess> findAllMatchingTypes(INamedElementAccess searchRoot, Predicate<ITypeAccess> predicate) {
        assert (predicate != null) : "Parameter 'predicate' of method 'findFirstMatchingType' must not be null";
        SearchVisitor<ITypeAccess> v = new SearchVisitor<ITypeAccess>(IType.class, predicate, 0, true);
        this.getSearchRoot(searchRoot).accept(v);
        return v.getResult();
    }

    public final IMethodAccess findFirstMatchingMethod(INamedElementAccess searchRoot, Predicate<IMethodAccess> predicate) {
        assert (predicate != null) : "Parameter 'predicate' of method 'findFirstMatchingType' must not be null";
        SearchVisitor<IMethodAccess> v = new SearchVisitor<IMethodAccess>(IMethod.class, predicate, 1, false);
        this.getSearchRoot(searchRoot).accept(v);
        List<IMethodAccess> result = v.getResult();
        return result.isEmpty() ? null : result.get(0);
    }

    public final List<IMethodAccess> findAllMatchingMethods(INamedElementAccess searchRoot, Predicate<IMethodAccess> predicate) {
        assert (predicate != null) : "Parameter 'predicate' of method 'findFirstMatchingType' must not be null";
        SearchVisitor<IMethodAccess> v = new SearchVisitor<IMethodAccess>(IMethod.class, predicate, 0, false);
        this.getSearchRoot(searchRoot).accept(v);
        return v.getResult();
    }

    public final IRoutineAccess findFirstMatchingRoutine(INamedElementAccess searchRoot, Predicate<IRoutineAccess> predicate) {
        assert (predicate != null) : "Parameter 'predicate' of method 'findFirstMatchingType' must not be null";
        SearchVisitor<IRoutineAccess> v = new SearchVisitor<IRoutineAccess>(IRoutine.class, predicate, 1, false);
        this.getSearchRoot(searchRoot).accept(v);
        List<IRoutineAccess> result = v.getResult();
        return result.isEmpty() ? null : result.get(0);
    }

    public final List<IRoutineAccess> findAllMatchingRoutines(INamedElementAccess searchRoot, Predicate<IRoutineAccess> predicate) {
        assert (predicate != null) : "Parameter 'predicate' of method 'findFirstMatchingType' must not be null";
        SearchVisitor<IRoutineAccess> v = new SearchVisitor<IRoutineAccess>(IRoutine.class, predicate, 0, false);
        this.getSearchRoot(searchRoot).accept(v);
        return v.getResult();
    }

    public final IFieldAccess findFirstMatchingField(INamedElementAccess searchRoot, Predicate<IFieldAccess> predicate) {
        assert (predicate != null) : "Parameter 'predicate' of method 'findFirstMatchingType' must not be null";
        SearchVisitor<IFieldAccess> v = new SearchVisitor<IFieldAccess>(IField.class, predicate, 1, false);
        this.getSearchRoot(searchRoot).accept(v);
        List<IFieldAccess> result = v.getResult();
        return result.isEmpty() ? null : result.get(0);
    }

    public final List<IFieldAccess> findAllMatchingFields(INamedElementAccess searchRoot, Predicate<IFieldAccess> predicate) {
        assert (predicate != null) : "Parameter 'predicate' of method 'findFirstMatchingType' must not be null";
        SearchVisitor<IFieldAccess> v = new SearchVisitor<IFieldAccess>(IField.class, predicate, 0, false);
        this.getSearchRoot(searchRoot).accept(v);
        return v.getResult();
    }

    public final INamedElementAccess findFirstMatchingElement(INamedElementAccess searchRoot, Predicate<INamedElementAccess> predicate) {
        assert (predicate != null) : "Parameter 'predicate' of method 'findFirstMatchingType' must not be null";
        SearchVisitor<INamedElementAccess> v = new SearchVisitor<INamedElementAccess>(NamedElement.class, predicate, 1, false);
        this.getSearchRoot(searchRoot).accept(v);
        List<INamedElementAccess> result = v.getResult();
        return result.isEmpty() ? null : result.get(0);
    }

    public final INamedElementAccess findFirstMatchingElementRecursively(INamedElementAccess searchRoot, Predicate<INamedElementAccess> predicate) {
        assert (predicate != null) : "Parameter 'predicate' of method 'findFirstMatchingType' must not be null";
        SearchVisitor<INamedElementAccess> v = new SearchVisitor<INamedElementAccess>(NamedElement.class, predicate, 1, true);
        this.getSearchRoot(searchRoot).accept(v);
        List<INamedElementAccess> result = v.getResult();
        return result.isEmpty() ? null : result.get(0);
    }

    public final List<INamedElementAccess> findAllMatchingElements(INamedElementAccess searchRoot, Predicate<INamedElementAccess> predicate) {
        assert (predicate != null) : "Parameter 'predicate' of method 'findFirstMatchingType' must not be null";
        SearchVisitor<INamedElementAccess> v = new SearchVisitor<INamedElementAccess>(NamedElement.class, predicate, 0, false);
        this.getSearchRoot(searchRoot).accept(v);
        return v.getResult();
    }

    public final List<INamedElementAccess> findAllMatchingElementsRecursively(INamedElementAccess searchRoot, Predicate<INamedElementAccess> predicate) {
        assert (predicate != null) : "Parameter 'predicate' of method 'findAllMatchingElementsRecursively' must not be null";
        SearchVisitor<INamedElementAccess> v = new SearchVisitor<INamedElementAccess>(NamedElement.class, predicate, 0, true);
        this.getSearchRoot(searchRoot).accept(v);
        return v.getResult();
    }

    private void visitElement(ModelVisitor visitor, NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitElement' must not be null";
        NamedElement root = ((SoftwareSystem)this.m_element).getUniqueExistingChild(Workspace.class);
        this.m_factory.createAccessObject(root).accept((INamedElementAccess.INamedElementAccessVisitor)visitor);
    }

    public final void visitParserModel(ModelVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Parameter 'visitor' must not be null");
        }
        this.visitElement(visitor, ((SoftwareSystem)this.m_element).getUniqueExistingChild(Workspace.class));
    }

    public final void visitLogicalModuleNamespaces(ModelVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Parameter 'visitor' must not be null");
        }
        this.visitElement(visitor, ((SoftwareSystem)this.m_element).getUniqueExistingChild(LogicalModuleNamespaces.class));
    }

    public final void visitLogicalSystemNamespaces(ModelVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Parameter 'visitor' must not be null");
        }
        this.visitElement(visitor, ((SoftwareSystem)this.m_element).getUniqueExistingChild(LogicalSystemNamespaces.class));
    }

    public final INamedElementAccess getWorkspaceRoot() {
        RootAccess rootAccess = new RootAccess(((SoftwareSystem)this.m_element).getUniqueExistingChild(Workspace.class));
        rootAccess.setFactory(this.m_factory);
        return rootAccess;
    }

    public final boolean addIssue(IElementAccess elementAccess, IPluginIssueId id, String description, int line) {
        assert (elementAccess != null) : "Parameter 'elementAccess' of method 'addIssue' must not be null";
        assert (id != null && id instanceof PluginIssueId) : "Unexpected class in method 'addIssue': " + String.valueOf(id);
        assert (description == null || description.length() > 0) : "Parameter 'description' of method 'addIssue' must be null or not empty";
        Object element = ((ElementAccess)elementAccess).getElement();
        boolean result = false;
        if (element instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)element;
            PluginElementIssue issue = new PluginElementIssue((PluginIssueId)id, namedElement, description, line);
            namedElement.addIssue(issue);
            result = !issue.isIgnored();
        } else if (element instanceof AggregatedDependency) {
            AggregatedDependency aggr = (AggregatedDependency)element;
            for (Dependency dep : aggr.getParserDependencies()) {
                PluginDependencyIssue issue = new PluginDependencyIssue((PluginIssueId)id, dep, description, -1);
                dep.addIssue(issue);
                if (issue.isIgnored()) continue;
                result = true;
            }
        } else {
            assert (element instanceof Dependency);
            Dependency dep = (Dependency)element;
            PluginDependencyIssue issue = new PluginDependencyIssue((PluginIssueId)id, dep, description, line);
            dep.addIssue(issue);
            result = !issue.isIgnored();
        }
        return result;
    }

    public final File getHiddenDataDirectory(String pluginId) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'getHiddenDirectory' must not be empty";
        TFile hiddenDataDirectory = ((SoftwareSystem)this.getElement()).getUniqueExistingChild(Files.class).getHiddenDataDirectory();
        TFile pluginsDirectory = new TFile((File)hiddenDataDirectory, "plugins");
        OperationResult result1 = new OperationResult("Get or create hidden plugins directory");
        FileUtility.getOrCreateDirectory((TFile)pluginsDirectory, (OperationResult)result1);
        if (result1.isFailure()) {
            LOGGER.error("Failed to create hidden plugins directory: " + result1.toString());
            return null;
        }
        TFile pluginIdDirectory = new TFile((File)pluginsDirectory, pluginId);
        OperationResult result2 = new OperationResult("Get or create hidden pluginId directory");
        FileUtility.getOrCreateDirectory((TFile)pluginIdDirectory, (OperationResult)result2);
        if (result2.isFailure()) {
            LOGGER.error("Failed to create hidden pluginId directory: " + result2.toString());
            return null;
        }
        return pluginIdDirectory;
    }

    private final class SearchVisitor<T extends INamedElementAccess>
    extends NamedElementVisitor {
        public static final int UNLIMITED = 0;
        public static final int FIND_FIRST = 1;
        private final Class<?> m_classToBeMatched;
        private final List<T> m_result = new ArrayList<T>();
        private final Predicate<T> m_predicate;
        private final int m_limit;
        private final boolean m_recursive;

        private SearchVisitor(Class<?> classToBeMatched, Predicate<T> predicate, int limit, boolean recursive) {
            this.m_classToBeMatched = classToBeMatched;
            this.m_predicate = predicate;
            this.m_limit = limit;
            this.m_recursive = recursive;
        }

        @Override
        public boolean done() {
            return this.m_limit > 0 && this.m_result.size() >= this.m_limit;
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            if (this.m_classToBeMatched.isAssignableFrom(element.getClass())) {
                ElementAccess<? extends NamedElement> accessObject = PluginCoreAccess.this.m_factory.createAccessObject(element);
                if (this.m_predicate.test(accessObject)) {
                    this.m_result.add(accessObject);
                }
                if (this.m_recursive) {
                    this.visitChildrenOf(element);
                }
            } else {
                this.visitChildrenOf(element);
            }
        }

        public List<T> getResult() {
            return this.m_result;
        }
    }
}

