/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFindingList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperationList;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewSortMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IExplorationViewRepresentationOwner;

public final class LoadedRepresentationInfo {
    private final IExplorationViewRepresentationOwner m_owner;
    private final ArchitecturalViewOperationList m_operations;
    private final ArchitecturalViewFindingList m_findings;
    private final ExplorationViewRepresentation m_representation;

    public LoadedRepresentationInfo(IExplorationViewRepresentationOwner owner, ArchitecturalViewOperationList operations, ArchitecturalViewFindingList findings, ExplorationViewRepresentation representation) {
        assert (owner != null) : "Parameter 'owner' of method 'LoadedRepresentationInfo' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'LoadedRepresentationInfo' must not be null";
        assert (representation.isValid()) : "Not valid: " + String.valueOf(representation);
        this.m_owner = owner;
        this.m_operations = operations;
        this.m_findings = findings;
        this.m_representation = representation;
    }

    public boolean isExplorationViewOrInLevelizationModeAll() {
        return !(this.m_owner instanceof ArchitecturalViewFile) || this.m_representation.getSortMode() != ExplorationViewSortMode.LEVELIZE;
    }

    public boolean isExplorationView() {
        return !(this.m_owner instanceof ArchitecturalViewFile);
    }

    public boolean inLevelizationModeAll() {
        return this.m_representation.getSortMode() == ExplorationViewSortMode.LEVELIZE_ALL;
    }

    public IExplorationViewRepresentationOwner getOwner() {
        return this.m_owner;
    }

    public ArchitecturalViewFile getFile() {
        assert (this.m_owner != null && this.m_owner instanceof ArchitecturalViewFile) : "Unexpected class in method 'getFile': " + String.valueOf(this.m_owner);
        return (ArchitecturalViewFile)this.m_owner;
    }

    public ArchitecturalViewOperationList getOperationList() {
        assert (this.m_operations != null) : "Parameter 'm_operations' of method 'getOperationList' must not be null";
        return this.m_operations;
    }

    public ArchitecturalViewFindingList getFindingList() {
        assert (this.m_findings != null) : "Parameter 'm_findings' of method 'getFindingList' must not be null";
        return this.m_findings;
    }

    public ExplorationViewRepresentation getRepresentation() {
        return this.m_representation;
    }

    public PresentationMode getPresentationMode() {
        return this.m_representation.getPresentationMode();
    }
}

