/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationHandler;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ViolationInfo;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFinding;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFindingContainsSameDependencies;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFindingList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFindingProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperationList;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateFindingOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FindingHandler
implements IExplorationViewRepresentationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FindingHandler.class);

    static ArchitecturalViewFindingProperties createFindingProperties(PresentationMode presentationMode, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, final ArchitecturalViewOperationList operationList, final ArchitecturalViewFindingList findingList, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'createFindingProperties' must not be null";
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'createFindingProperties' must not be empty";
        assert (operationList != null) : "Parameter 'operationList' of method 'createFindingProperties' must not be null";
        assert (findingList != null) : "Parameter 'findingList' of method 'createFindingProperties' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'createFindingProperties' must not be null";
        THashSet parserDependencies = new THashSet();
        dependencies.forEach(arg_0 -> FindingHandler.lambda$0((Set)parserDependencies, arg_0));
        return new ArchitecturalViewFindingProperties("Finding", "", true, dependencies, new ITextValidator((Set)parserDependencies){
            private final /* synthetic */ Set val$parserDependencies;
            {
                this.val$parserDependencies = set;
            }

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(true);
                if (newInput != null) {
                    newInput = newInput.trim();
                }
                if (newInput == null || newInput.isEmpty()) {
                    result.addError("Name must not be empty");
                } else {
                    for (CreateFindingOperation createFindingOperation : operationList.getChildren(CreateFindingOperation.class)) {
                        if (!createFindingOperation.getFindingName().equals(newInput)) continue;
                        result.addError("Operation creating finding with name '" + newInput + "' already exists");
                        break;
                    }
                    if (result.isSuccess()) {
                        for (ArchitecturalViewFinding architecturalViewFinding : findingList.getFindings()) {
                            if (!architecturalViewFinding.getParserDependencies().equals(this.val$parserDependencies)) continue;
                            result.addWarning("Finding with name '" + architecturalViewFinding.getName() + "' contains same dependencies");
                        }
                    }
                }
                return result;
            }
        }, representation);
    }

    private static String containSameDependencies(Set<ParserDependency> parserDependencies, ArchitecturalViewFindingList findingList) {
        assert (parserDependencies != null) : "Parameter 'parserDependencies' of method 'containSameDependencies' must not be null";
        assert (findingList != null) : "Parameter 'findingList' of method 'containSameDependencies' must not be null";
        StringBuilder builder = new StringBuilder();
        for (ArchitecturalViewFinding next : findingList.getFindings()) {
            if (!next.getParserDependencies().equals(parserDependencies)) continue;
            builder.append(" '").append(next.getName()).append("'");
        }
        return builder.length() == 0 ? null : "Identical:" + builder.toString();
    }

    static Set<ParserDependency> createFinding(PresentationMode presentationMode, String name, String description, boolean ignoreViolations, Set<String> parserDependencyDescriptors, ArchitecturalViewFindingList findingList, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'createFinding' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createFinding' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'createFinding' must not be null";
        assert (parserDependencyDescriptors != null && !parserDependencyDescriptors.isEmpty()) : "Parameter 'parserDependencyDescriptors' of method 'createFinding' must not be empty";
        assert (findingList != null) : "Parameter 'findingList' of method 'createFinding' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'createFinding' must not be null";
        IElementResolver resolver = representation.getResolver();
        THashSet parserDependencies = new THashSet(parserDependencyDescriptors.size());
        for (String next : parserDependencyDescriptors) {
            Element nextResolved = resolver.resolve(next);
            if (nextResolved == null) continue;
            if (!(nextResolved instanceof ParserDependency)) {
                LOGGER.warn("Not a parser dependency: " + String.valueOf(nextResolved) + " (" + next + ")");
                continue;
            }
            parserDependencies.add((ParserDependency)nextResolved);
        }
        if (!parserDependencies.isEmpty()) {
            if (ignoreViolations) {
                representation.addViolationsIgnored((Collection<ParserDependency>)parserDependencies);
            }
            String sameDependencies = FindingHandler.containSameDependencies((Set<ParserDependency>)parserDependencies, findingList);
            ArchitecturalViewFinding finding = new ArchitecturalViewFinding(findingList, name, description, ignoreViolations, (Set<ParserDependency>)parserDependencies, findingList.getNumberOfChildren() + 1);
            findingList.addChild(finding);
            if (sameDependencies != null) {
                finding.addIssue(new ArchitecturalViewFindingContainsSameDependencies(finding, sameDependencies));
            }
        }
        return parserDependencies;
    }

    static ExplorationViewRepresentation isCreateFindingPossible(PresentationMode presentationMode, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isCreateFindingPossible' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'isCreateFindingPossible' must not be null";
        return RepresentationHandler.getRepresentation(dependencies);
    }

    private static void updateInformation(ArchitecturalViewFinding finding, ExplorationViewRepresentation representation) {
        assert (finding != null) : "Parameter 'finding' of method 'updateInformation' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'updateInformation' must not be null";
        Set<ParserDependency> parserDependencies = finding.getParserDependencies();
        assert (parserDependencies != null && !parserDependencies.isEmpty()) : "'parserDependencies' of method 'updateInformation' must not be empty";
        StringBuilder builder = new StringBuilder();
        builder.append("Matches ").append(parserDependencies.size());
        if (parserDependencies.size() == 1) {
            builder.append(" parser dependency.");
        } else {
            builder.append(" parser dependencies.");
        }
        int deleted = 0;
        int ignoredViolations = 0;
        for (ParserDependency next : parserDependencies) {
            if (representation.hasParserDependencyBeenDeleted(next)) {
                ++deleted;
                continue;
            }
            if (!finding.ignoreViolations() || representation.isViolation(next) == null) continue;
            ++ignoredViolations;
        }
        builder.append(" Contains ").append(deleted).append(" deleted and ").append(ignoredViolations).append(" architecture violating");
        if (deleted == 1 && ignoredViolations == 1) {
            builder.append(" parser dependency.");
        } else {
            builder.append(" parser dependencies.");
        }
        List<Issue> issues = finding.getIssues(CoreIssueId.ARCHITECTURAL_VIEW_FINDING_CONTAINS_SAME_DEPENDENCIES);
        if (issues.size() == 1) {
            builder.append(" ").append(issues.get(0).getId().getPresentationName()).append(" (").append(issues.get(0).getDescription()).append(")");
        }
        finding.setInformation(builder.toString());
    }

    static List<String> createFinding(PresentationMode presentationMode, ArchitecturalViewFindingProperties properties, ArchitecturalViewFindingList findingList, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'createFinding' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'createFinding' must not be null";
        assert (findingList != null) : "Parameter 'findingList' of method 'createFinding' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'createFinding' must not be null";
        IElementResolver resolver = representation.getResolver();
        ArrayList<String> descriptors = new ArrayList<String>();
        THashSet parserDependencies = new THashSet();
        for (ArchitecturalViewNode.ArchitecturalViewDependency next : properties.getDependencies()) {
            for (ParserDependency nextParserDependency : next.getParserDependencies()) {
                descriptors.add(resolver.getDescriptor(nextParserDependency));
                parserDependencies.add(nextParserDependency);
            }
        }
        assert (!parserDependencies.isEmpty()) : "No parser dependencies";
        if (properties.ignoreViolations()) {
            representation.addViolationsIgnored((Collection<ParserDependency>)parserDependencies);
        }
        String sameDependencies = FindingHandler.containSameDependencies((Set<ParserDependency>)parserDependencies, findingList);
        ArchitecturalViewFinding finding = new ArchitecturalViewFinding(findingList, properties.getName(), properties.getDescription(), properties.ignoreViolations(), (Set<ParserDependency>)parserDependencies, findingList.getNumberOfChildren() + 1);
        findingList.addChild(finding);
        if (sameDependencies != null) {
            finding.addIssue(new ArchitecturalViewFindingContainsSameDependencies(finding, sameDependencies));
        }
        FindingHandler.updateInformation(finding, representation);
        RepresentationHandler.updateAggregatedDependencies(representation);
        return descriptors;
    }

    static void updateFindings(ArchitecturalViewFindingList findingList, ExplorationViewRepresentation representation) {
        assert (findingList != null) : "Parameter 'findingList' of method 'updateFindings' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'updateFindings' must not be null";
        List<ArchitecturalViewFinding> findings = findingList.getFindings();
        if (!findings.isEmpty()) {
            LOGGER.debug("Update findings");
            findings.forEach(f -> FindingHandler.updateInformation(f, representation));
            LOGGER.debug("Update findings - done");
        }
    }

    static Set<ParserDependency> getParserDependencies(List<ArchitecturalViewFinding> findings, ExplorationViewRepresentation representation) {
        assert (findings != null) : "Parameter 'findings' of method 'getParserDependencies' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'getParserDependencies' must not be null";
        if (findings.isEmpty()) {
            return Collections.emptySet();
        }
        THashSet parserDependencies = new THashSet();
        for (ArchitecturalViewFinding nextFinding : findings) {
            for (ParserDependency nextParserDependency : nextFinding.getParserDependencies()) {
                if (representation.hasParserDependencyBeenDeleted(nextParserDependency)) continue;
                parserDependencies.add(nextParserDependency);
            }
        }
        return parserDependencies;
    }

    static ArchitecturalViewOperation getCorrespondingOperation(ArchitecturalViewFinding finding) {
        assert (finding != null) : "Parameter 'finding' of method 'getCorrespondingOperation' must not be null";
        ArchitecturalViewFile file = finding.getParent(ArchitecturalViewFile.class, new Class[0]);
        if (file != null) {
            for (ArchitecturalViewOperation nextOp : file.getOperations()) {
                if (!(nextOp instanceof CreateFindingOperation) || !((CreateFindingOperation)nextOp).getFindingName().equals(finding.getName())) continue;
                return nextOp;
            }
        }
        return null;
    }

    public static boolean hasIgnoredViolationsInfo(ArchitecturalViewFindingList findingList, ExplorationViewRepresentation representation) {
        assert (findingList != null) : "Parameter 'findingList' of method 'hasIgnoredViolationsInfo' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'hasIgnoredViolationsInfo' must not be null";
        for (ArchitecturalViewFinding nextFinding : findingList.getChildren(ArchitecturalViewFinding.class)) {
            for (ParserDependency nextParserDependency : nextFinding.getParserDependencies()) {
                ViolationInfo info = representation.isViolation(nextParserDependency);
                if (info == null || !info.isIgnored()) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<ArchitecturalViewFinding, List<ParserDependency>> getIgnoredViolationsInfo(ArchitecturalViewFindingList findingList, ExplorationViewRepresentation representation) {
        assert (findingList != null) : "Parameter 'findingList' of method 'getIgnoredViolationsInfo' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'getIgnoredViolationsInfo' must not be null";
        TreeMap<ArchitecturalViewFinding, List<ParserDependency>> findingToViolations = new TreeMap<ArchitecturalViewFinding, List<ParserDependency>>(new Comparator<ArchitecturalViewFinding>(){

            @Override
            public int compare(ArchitecturalViewFinding f1, ArchitecturalViewFinding f2) {
                if (!$assertionsDisabled && f1 == null) {
                    throw new AssertionError((Object)"Parameter 'f1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && f2 == null) {
                    throw new AssertionError((Object)"Parameter 'f2' of method 'compare' must not be null");
                }
                return f1.getName().compareTo(f2.getName());
            }
        });
        for (ArchitecturalViewFinding nextFinding : findingList.getChildren(ArchitecturalViewFinding.class)) {
            for (ParserDependency nextParserDependency : nextFinding.getParserDependencies()) {
                ViolationInfo info = representation.isViolation(nextParserDependency);
                if (info == null || !info.isIgnored()) continue;
                ArrayList<ParserDependency> nextViolating = (ArrayList<ParserDependency>)findingToViolations.get(nextFinding);
                if (nextViolating == null) {
                    nextViolating = new ArrayList<ParserDependency>();
                    findingToViolations.put(nextFinding, nextViolating);
                }
                nextViolating.add(nextParserDependency);
            }
        }
        return findingToViolations;
    }

    private static /* synthetic */ void lambda$0(Set set, ArchitecturalViewNode.ArchitecturalViewDependency d) {
        boolean bl = set.addAll(d.getParserDependencies());
    }
}

