/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.ArtifactTemplate;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedElements;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class AssignedElementCollector
extends NamedElementVisitor
implements AssignedElement.IVisitor,
Artifact.IVisitor,
ArtifactTemplate.IVisitor,
UnassignedElements.IVisitor {
    private final Set<NamedElement> m_toBeFound;
    private final List<NamedElement> m_collector;

    public AssignedElementCollector(Collection<NamedElement> toBeFound, List<NamedElement> collector) {
        assert (toBeFound != null && !toBeFound.isEmpty()) : "Parameter 'toBeFound' of method 'AssignedElementCollector' must not be empty";
        assert (collector != null) : "Parameter 'collector' of method 'AssignedElementCollector' must not be null";
        this.m_toBeFound = new THashSet(toBeFound);
        this.m_collector = collector;
    }

    @Override
    public void visitUnassignedElements(UnassignedElements element) {
        this.visitChildrenOf(element);
    }

    @Override
    public void visitArtifact(Artifact element) {
        this.visitChildrenOf(element);
    }

    @Override
    public void visitArtifactTemplate(ArtifactTemplate element) {
        this.visitChildrenOf(element);
    }

    @Override
    public void visitAssignedElement(AssignedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitAssignedElement' must not be null";
        if (this.m_toBeFound.remove(element.getRepresentedElement())) {
            this.m_collector.add(element);
        }
    }
}

