/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAnalyzer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.GraphNode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.ICycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ArchitectureCycleAnalyzer
implements ICycleAnalyzerAdapter {
    private final ArchitectureFile m_file;
    private final Map<Artifact, GraphNode<Artifact>> m_artifactToNode = new THashMap();
    private final Map<INode<?>, Integer> m_nodeToGroupIndex = new THashMap();
    private final Set<INode<?>> m_cyclicNodes = new THashSet();
    private final List<List<Artifact>> m_cycleGroups = new ArrayList<List<Artifact>>();
    private List<Artifact> m_currentCycleGroup;
    private int m_lastGroupIndex = -1;

    ArchitectureCycleAnalyzer(ArchitectureFile file) {
        assert (file != null) : "Parameter 'file' of method 'ArchitectureCycleAnalyzer' must not be null";
        this.m_file = file;
    }

    public Collection<GraphNode<Artifact>> getNodes() {
        this.m_file.getChildrenRecursively(Artifact.class, new Class[0]).forEach(a -> {
            GraphNode<Artifact> graphNode = this.m_artifactToNode.put((Artifact)a, new GraphNode<Artifact>((Artifact)a));
        });
        for (GraphNode<Artifact> node : this.m_artifactToNode.values()) {
            Artifact artifact = (Artifact)node.getUnderlyingObject();
            for (Artifact connected : artifact.getConnectedElements()) {
                GraphNode<Artifact> connectedNode = this.m_artifactToNode.get(connected);
                if (connectedNode == null) continue;
                node.connectTo(connectedNode);
            }
        }
        this.m_artifactToNode.values().forEach(n -> n.finishModification());
        return this.m_artifactToNode.values();
    }

    @Override
    public boolean calculateLevels() {
        return false;
    }

    @Override
    public boolean isCyclic(INode<?> node) {
        assert (node != null) : "Parameter 'node' of method 'isCyclic' must not be null";
        return this.m_cyclicNodes.contains(node);
    }

    @Override
    public void setGroupIndex(INode<?> node, int groupIndex, boolean isCyclic) {
        assert (node != null) : "Parameter 'node' of method 'setGroupIndex' must not be null";
        if (isCyclic) {
            this.m_cyclicNodes.add(node);
            if (groupIndex != this.m_lastGroupIndex) {
                this.m_lastGroupIndex = groupIndex;
                this.m_currentCycleGroup = new ArrayList<Artifact>();
                this.m_currentCycleGroup.add((Artifact)node.getUnderlyingObject());
                this.m_cycleGroups.add(this.m_currentCycleGroup);
            } else {
                this.m_currentCycleGroup.add((Artifact)node.getUnderlyingObject());
            }
        }
        this.m_nodeToGroupIndex.put(node, groupIndex);
    }

    @Override
    public int getGroupIndex(INode<?> node) {
        assert (node != null) : "Parameter 'node' of method 'getGroupIndex' must not be null";
        Integer val = this.m_nodeToGroupIndex.get(node);
        return val == null ? -1 : val;
    }

    @Override
    public void setLevel(INode<?> node, int level) {
    }

    public List<List<Artifact>> getCycleGroups() {
        CycleAnalyzer.compute(this, (IWorkerContext)DefaultWorkerContext.INSTANCE);
        return Collections.unmodifiableList(this.m_cycleGroups);
    }
}

