/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.base.AbstractUndoRedoProvider;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IVirtualModelExtension;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.IPersistableVirtualModel;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.transaction.AnalyzerExecutionInfo;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public final class VirtualModelUndoRedoProvider
extends AbstractUndoRedoProvider {
    private final IVirtualModelExtension m_extension;

    public VirtualModelUndoRedoProvider(IVirtualModelExtension extension) {
        assert (extension != null) : "Parameter 'extension' of method 'VirtualModelUndoRedoProvider' must not be null";
        this.m_extension = extension;
    }

    @Override
    public List<Class<? extends IModifiableFile>> getModifiableFileClasses() {
        return Arrays.asList(ModifiableModel.class);
    }

    @Override
    public AnalyzerExecutionInfo getAnalyzerExecutionInfo(String identifyingPath, RestoreStateDto restoreDto) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getAnalyzerExecutionInfo' must not be empty";
        return AnalyzerExecutionInfo.all();
    }

    @Override
    public void writeModifiableFileToStream(IModifiableFile file, OutputStream outputStream, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'writeModifiableFileToStream' must not be null";
        assert (file instanceof IPersistableVirtualModel) : "Unexpected class: " + file.getClass().getName();
        assert (outputStream != null) : "Parameter 'outputStream' of method 'writeModifiableFileToStream' must not be null";
        this.m_extension.save((IPersistableVirtualModel)file, outputStream, result);
    }

    @Override
    public OperationResultWithOutcome<? extends IModifiableFile> restoreModifiableFileFromStream(InputStream inputStream, RestoreStateDto dto, EnumSet<Modification> determinedModifications, List<String> otherFilesOfTx) throws IOException {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restoreModifiableFileFromStream' must not be null";
        assert (dto != null) : "Parameter 'dto' of method 'restoreModifiableFileFromStream' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreModifiableFileFromStream' must not be null";
        assert (otherFilesOfTx != null) : "Parameter 'otherFilesOfTx' of method 'restoreModifiableFileFromStream' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Restoring model '" + dto.getCurrentStateFileEntry().getIdentifyingPath() + "' from stream");
        boolean switchModels = false;
        VirtualModel currentModel = this.m_extension.getCurrentVirtualModel();
        switchModels = this.isDifferentFromCurrentModel(dto, currentModel);
        if (currentModel instanceof ModifiableModel) {
            ((ModifiableModel)currentModel).resetResolutions();
            currentModel.removeChildren(new Class[0]);
        }
        ModifiableModel existingModel = this.m_extension.findModifiableModelByIdentifyingPath(dto.getCurrentStateFileEntry().getIdentifyingPath());
        assert (existingModel != null) : "'existingModel' of method 'restoreModifiableFileFromStream' must not be null";
        this.m_extension.load(existingModel, inputStream, (OperationResult)result);
        result.setOutcome((Object)existingModel);
        if (switchModels) {
            this.m_extension.switchToModel(existingModel, null);
            determinedModifications.add(Modification.VIRTUAL_MODEL_CHANGED);
        } else {
            existingModel.setNeedsApplication();
        }
        return result;
    }

    private boolean isDifferentFromCurrentModel(RestoreStateDto dto, VirtualModel currentModel) {
        if (!(currentModel instanceof ModifiableModel)) {
            return true;
        }
        return !((ModifiableModel)currentModel).getIdentifyingPath().equals(dto.getCurrentStateFileEntry().getIdentifyingPath());
    }

    @Override
    public String getConfirmationMessageForNextRestore(RestoreStateDto dto) {
        assert (dto != null) : "Parameter 'dto' of method 'getConfirmationMessageForNextRestore' must not be null";
        VirtualModel currentModel = this.m_extension.getCurrentVirtualModel();
        if (this.isDifferentFromCurrentModel(dto, currentModel)) {
            return "Restoring state of '" + dto.getCurrentStateFileEntry().getIdentifyingPath() + "' will set this model as the active model." + StringUtility.LINE_SEPARATOR + "Do you want to continue?";
        }
        return null;
    }
}

